<?php

/**
 * Create general settings & controls
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_footer_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'footer_general_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'footer_general_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_footer_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle footer
	$wp_customize->add_setting(
		'footer_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'footer_toggle',
		array(
			'type'        => 'checkbox',
			'priority'    => 0,
			'section'     => 'general_footer_options',
			'description' => __( 'Toggle this to off if you want to use the Divi footer.', 'klasse-theme' ),
			'label'       => __( 'Toggle footer', 'klasse-theme' ),
		)
	);
	// Select navigation type
	$wp_customize->add_setting(
		'footer_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'footer_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_footer_options',
			'label'    => __( 'Footer theme selection', 'klasse-theme' ),
			'choices'  => array(
				'default-v1' => __( 'Default v1', 'klasse-theme' ),
				// 'shop-v1' => __('Shop v1', 'klasse-theme'),
				'shop-v2'    => __( 'Shop v2', 'klasse-theme' ),
				'shop-v4'    => __( 'Shop v4', 'klasse-theme' ),
				// 'bottom_bar-v1' => __('Bottom bar v1', 'klasse-theme'),
			),
		)
	);
	// Select footer creation type
	$wp_customize->add_setting(
		'footer_creation_type',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'footer_creation_type',
		array(
			'priority'    => 0,
			'type'        => 'select',
			'section'     => 'general_footer_options',
			'label'       => __( 'Select footer creation type', 'klasse-theme' ),
			'description' => __( 'Default = standard generated with theme options. Widgets = generated by Wordpress widgets.', 'klasse-theme' ),
			'choices'     => array(
				'default' => __( 'Default', 'klasse-theme' ),
				'widgets' => __( 'Widgets', 'klasse-theme' ),
			),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_footer_settings_controls' );
