<?php
/**
 * Create customizer panel
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_footer_customizer_panels( $wp_customize ) {
	// Add the footer panel
	$wp_customize->add_panel(
		'footer_editor',
		array(
			'priority'    => 10,
			'title'       => __( 'Footer editor', 'klasse-theme' ),
			'description' => __( 'Edit the footer settings', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_footer_customizer_panels' );

/**
 * Create customizer sections
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_footer_customizer_sections( $wp_customize ) {
	// Add general footer sections
	$wp_customize->add_section(
		'general_footer_options',
		array(
			'title'    => __( 'General footer', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'footer_editor',
		)
	);

	// Add main footer section
	$wp_customize->add_section(
		'main_footer_options',
		array(
			'title'    => __( 'Main footer', 'klasse-theme' ),
			'priority' => '5',
			'panel'    => 'footer_editor',
		)
	);

	// Add bottom footer section
	$wp_customize->add_section(
		'bottom_footer_options',
		array(
			'title'    => __( 'Bottom footer', 'klasse-theme' ),
			'priority' => '10',
			'panel'    => 'footer_editor',
		)
	);
}
add_action( 'customize_register', 'kls_create_footer_customizer_sections' );

require_once __DIR__ . '/general-footer-settings.php';
require_once __DIR__ . '/main-footer-settings.php';
require_once __DIR__ . '/bottom-footer-settings.php';
