<?php

/**
 * Add checkbox callback
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function sanitize_checkbox_field( $input ) {
	if ( true === $input ) {
		return 1;
	} else {
		return 0;
	}
}

/**
 * Sanatize page dropdown
 *
 * @since 0.0.73
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function themeslug_sanitize_dropdown_pages( $page_id, $setting ) {
	$page_id = absint( $page_id );
	return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

/**
 * Sanatize radio buttons callback
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function sanitize_radio_field( $input, $setting ) {
	global $wp_customize;
	$control = $wp_customize->get_control( $setting->id );
	if ( array_key_exists( $input, $control->choices ) ) {
		return $input;
	} else {
		return $setting->default;
	}
}
