<?php
if ( isset( $GLOBALS['wp_customize'] ) ) {
	/**
	 * Adding custom sanatizing
	 *
	 * @since 0.0.07
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/customizer_callbacks.php';

	/**
	 * Adding custom controls
	 *
	 * @since 0.0.23
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/customizer_custom_controls.php';

	/**
	 * Add general theme options
	 *
	 * @since 0.0.12
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/general/general.php';

	/**
	 * Add button theme options
	 *
	 * @since 0.1.14
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/button/button.php';

	/**
	 * Add navigation options
	 *
	 * @since 0.0.07
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/navigation/navigation.php';

	/**
	 * Add forms options
	 *
	 * @since 0.1.79
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/forms/forms.php';

	/**
	 * Add footer options
	 *
	 * @since 0.0.12
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/footer/footer.php';

	/**
	 * Add 404 options
	 *
	 * @since 0.0.32
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	require_once __DIR__ . '/not_found_404/not_found_404.php';

	/**
	 * Add Woocommerce options
	 *
	 * @since 0.0.11
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	if ( get_option( 'kls_webshop_toggle' ) == 'on' ) {
		require_once __DIR__ . '/woocommerce/woocommerce.php';
	}
}

/**
 * Add css generator
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/css_generator.php';

/**
 * Add js generator
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/js_generator.php';

/**
 * Enqueue customizer styling
 *
 * @since 0.0.08
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_enqueue_color_picker( $hook_suffix ) {
	 wp_enqueue_style( 'wp-color-picker' );
}
add_action( 'admin_enqueue_scripts', 'kls_enqueue_color_picker' );

/**
 * Enqueue customizer scripts
 *
 * @since 0.0.08
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * Todo, this gives the following error:
 * Warning: Cannot modify header information - headers already sent by (output started at /home/opzetweb/tegelzetbedrijflees.opzet-website.nl/wp-content/themes/klasse-theme/public/includes/customizer/customizer.php:108) in /home/opzetweb/tegelzetbedrijflees.opzet-website.nl/wp-admin/customize.php on line 126
 * It's the ?> <style>.
 */
function kls_enqueue_customizer_scripts() {
	wp_enqueue_script( 'kls_customizer_js', KT_ASSETS_PATH_ADMIN . 'admin.js', array( 'jquery' ), $GLOBALS['kls_theme_version'], true );
	?>
	<style>
		#accordion-panel-woocommerce_editor {
			margin-bottom: 20px;
		}
	</style>
	<?php
}
add_action( 'customize_controls_enqueue_scripts', 'kls_enqueue_customizer_scripts' );
