<?php

/**
 * Create link button settings & controls
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.14
 */
function kls_create_link_button_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'link_button_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'link_button_title',
			array(
				'priority' => 0,
				'section'  => 'link_button_theme_options',
				'label'    => __( 'Link button colors', 'klasse-theme' ),
			)
		)
	);

	// Button link color
	$wp_customize->add_setting(
		'button_link_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'button_link_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'link_button_theme_options',
				'label'        => __( 'Button link color', 'klasse-theme' ),
			)
		)
	);

	// Button link hover color
	$wp_customize->add_setting(
		'button_link_hover_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'button_link_hover_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'link_button_theme_options',
				'label'        => __( 'Button link hover color', 'klasse-theme' ),
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_link_button_settings_controls' );
