<?php

/**
 * Create button settings & controls
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.14
 */
function kls_create_button_settings_controls( $wp_customize ) {
	foreach ( array_keys( $GLOBALS['kls_buttons'] ) as $button ) :
		// Seperator
		$wp_customize->add_setting(
			'button_' . $button . '_title',
			array(
				'capability' => 'edit_theme_options',
			)
		);

		$wp_customize->add_control(
			new kls_seperator(
				$wp_customize,
				'button_' . $button . '_title',
				array(
					'priority' => 0,
					'section'  => $button . '_button_theme_options',
					'label'    => __( $button . ' button colors', 'klasse-theme' ),
				)
			)
		);

		// Button color
		$wp_customize->add_setting(
			'button_' . $button . '_color',
			array(
				'default'    => '',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'type'       => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control(
				$wp_customize,
				'button_' . $button . '_color',
				array(
					'show_opacity' => true,
					'priority'     => 0,
					'section'      => $button . '_button_theme_options',
					'label'        => __( 'Button ' . $button . ' color', 'klasse-theme' ),
				)
			)
		);

		// Button background color
		$wp_customize->add_setting(
			'button_' . $button . '_background_color',
			array(
				'default'    => '',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'type'       => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control(
				$wp_customize,
				'button_' . $button . '_background_color',
				array(
					'show_opacity' => true,
					'priority'     => 0,
					'section'      => $button . '_button_theme_options',
					'label'        => __( 'Button ' . $button . ' background-color', 'klasse-theme' ),
				)
			)
		);

		// Button border color
		$wp_customize->add_setting(
			'button_' . $button . '_border_color',
			array(
				'default'    => '',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'type'       => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control(
				$wp_customize,
				'button_' . $button . '_border_color',
				array(
					'show_opacity' => true,
					'priority'     => 0,
					'section'      => $button . '_button_theme_options',
					'label'        => __( 'Button ' . $button . ' border-color', 'klasse-theme' ),
				)
			)
		);

		// Button hover color
		$wp_customize->add_setting(
			'button_' . $button . '_hover_color',
			array(
				'default'    => '',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'type'       => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control(
				$wp_customize,
				'button_' . $button . '_hover_color',
				array(
					'show_opacity' => true,
					'priority'     => 0,
					'section'      => $button . '_button_theme_options',
					'label'        => __( 'Button ' . $button . ' hover color', 'klasse-theme' ),
				)
			)
		);

		// Button hover background color
		$wp_customize->add_setting(
			'button_' . $button . '_hover_background_color',
			array(
				'default'    => '',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'type'       => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control(
				$wp_customize,
				'button_' . $button . '_hover_background_color',
				array(
					'show_opacity' => true,
					'priority'     => 0,
					'section'      => $button . '_button_theme_options',
					'label'        => __( 'Button ' . $button . ' hover background-color', 'klasse-theme' ),
				)
			)
		);

		// Button border hover color
		$wp_customize->add_setting(
			'button_' . $button . '_hover_border_color',
			array(
				'default'    => '',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'type'       => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control(
				$wp_customize,
				'button_' . $button . '_hover_border_color',
				array(
					'show_opacity' => true,
					'priority'     => 0,
					'section'      => $button . '_button_theme_options',
					'label'        => __( 'Button ' . $button . ' hover border-color', 'klasse-theme' ),
				)
			)
		);

		// Seperator
		$wp_customize->add_setting(
			'button_' . $button . '_title_border',
			array(
				'capability' => 'edit_theme_options',
			)
		);

		$wp_customize->add_control(
			new kls_seperator(
				$wp_customize,
				'button_' . $button . '_title_border',
				array(
					'priority' => 0,
					'section'  => $button . '_button_theme_options',
					'label'    => __( $button . ' button border settings', 'klasse-theme' ),
				)
			)
		);

		// Button border size
		$wp_customize->add_setting(
			'button_' . $button . '_border_size',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			'button_' . $button . '_border_size',
			array(
				'type'     => 'text',
				'priority' => 0,
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button border size', 'klasse-theme' ),
			)
		);

		// Button border radius
		$wp_customize->add_setting(
			'button_' . $button . '_border_radius',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			'button_' . $button . '_border_radius',
			array(
				'type'     => 'text',
				'priority' => 0,
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button border radius', 'klasse-theme' ),
			)
		);

		// Seperator
		$wp_customize->add_setting(
			'button_' . $button . '_text_title',
			array(
				'capability' => 'edit_theme_options',
			)
		);

		$wp_customize->add_control(
			new kls_seperator(
				$wp_customize,
				'button_' . $button . '_text_title',
				array(
					'priority' => 0,
					'section'  => $button . '_button_theme_options',
					'label'    => __( $button . ' button text settings', 'klasse-theme' ),
				)
			)
		);

		// Button font weight
		$wp_customize->add_setting(
			'button_' . $button . '_font_weight',
			array(
				'default'   => '',
				// 'sanitize_callback' => 'sanitize_select_field',
				'transport' => 'refresh',
				'type'      => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_font_weight',
			array(
				'priority' => 0,
				'type'     => 'select',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button font weight', 'klasse-theme' ),
				'choices'  => array(
					'normal'  => __( 'Normal', 'klasse-theme' ),
					'bold'    => __( 'Bold', 'klasse-theme' ),
					'bolder'  => __( 'Bolder', 'klasse-theme' ),
					'lighter' => __( 'Light', 'klasse-theme' ),
				),
			)
		);

		// Button font size
		$wp_customize->add_setting(
			'button_' . $button . '_font_size',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_font_size',
			array(
				'priority' => 0,
				'type'     => 'text',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button font size', 'klasse-theme' ),
			)
		);

		// Button line height
		$wp_customize->add_setting(
			'button_' . $button . '_line_height',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_line_height',
			array(
				'priority' => 0,
				'type'     => 'text',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button line height', 'klasse-theme' ),
			)
		);

		// Button letter spacing
		$wp_customize->add_setting(
			'button_' . $button . '_letter_spacing',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_letter_spacing',
			array(
				'priority' => 0,
				'type'     => 'text',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button letter spacing', 'klasse-theme' ),
			)
		);

		// Button text transform
		$wp_customize->add_setting(
			'button_' . $button . '_text_transform',
			array(
				'default'   => '',
				// 'sanitize_callback' => 'sanitize_select_field',
				'transport' => 'refresh',
				'type'      => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_text_transform',
			array(
				'priority' => 0,
				'type'     => 'select',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button text transform', 'klasse-theme' ),
				'choices'  => array(
					'none'       => __( 'None', 'klasse-theme' ),
					'capitalize' => __( 'Capitalize', 'klasse-theme' ),
					'uppercase'  => __( 'Uppercase', 'klasse-theme' ),
					'lowercase'  => __( 'Lowercase', 'klasse-theme' ),
					'initial'    => __( 'Initial', 'klasse-theme' ),
				),
			)
		);

		// Button padding
		$wp_customize->add_setting(
			'button_' . $button . '_padding',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_padding',
			array(
				'priority' => 0,
				'type'     => 'text',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button padding', 'klasse-theme' ),
			)
		);

		// Seperator
		$wp_customize->add_setting(
			'button_' . $button . '_icon_title',
			array(
				'capability' => 'edit_theme_options',
			)
		);

		$wp_customize->add_control(
			new kls_seperator(
				$wp_customize,
				'button_' . $button . '_icon_title',
				array(
					'priority' => 0,
					'section'  => $button . '_button_theme_options',
					'label'    => __( $button . ' button icon settings', 'klasse-theme' ),
				)
			)
		);

		// Button icon code
		$wp_customize->add_setting(
			'button_' . $button . '_icon_code',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			'button_' . $button . '_icon_code',
			array(
				'type'     => 'text',
				'priority' => 0,
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button icon Font Awesome unicode', 'klasse-theme' ),
			)
		);

		// Button icon font weight
		$wp_customize->add_setting(
			'button_' . $button . '_icon_font_weight',
			array(
				'default'   => '',
				'transport' => 'refresh',
				'type'      => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_icon_font_weight',
			array(
				'priority' => 0,
				'type'     => 'select',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button icon font weight', 'klasse-theme' ),
				'choices'  => array(
					'light'  => __( 'Light', 'klasse-theme' ),
					'normal' => __( 'Normal', 'klasse-theme' ),
					'bold'   => __( 'Bold', 'klasse-theme' ),
				),
			)
		);

		// Button icon position
		$wp_customize->add_setting(
			'button_' . $button . '_icon_position',
			array(
				'default'   => '',
				'transport' => 'refresh',
				'type'      => 'theme_mod',
			)
		);

		$wp_customize->add_control(
			'button_' . $button . '_icon_position',
			array(
				'priority' => 0,
				'type'     => 'select',
				'section'  => $button . '_button_theme_options',
				'label'    => __( $button . ' button icon position', 'klasse-theme' ),
				'choices'  => array(
					'left-text'  => __( 'Left text', 'klasse-theme' ),
					'left-full'  => __( 'Left full', 'klasse-theme' ),
					'right-text' => __( 'Right text', 'klasse-theme' ),
					'right-full' => __( 'Right full', 'klasse-theme' ),
				),
			)
		);
	endforeach;
}
add_action( 'customize_register', 'kls_create_button_settings_controls' );
