<?php

/**
 * Install options on installation
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

// Settings
add_option( 'kls_updates_toggle', 'on' );
add_option( 'kls_theme_settings_toggle', 'on' );
add_option( 'kls_theme_admin_link_toggle', 'on' );
add_option( 'kls_action_bar_button_toggle', 'on' );
add_option( 'kls_popup_text', '' );
add_option( 'kls_popup_cookie_name', 'popupclosed' );

// Customizer
function kls_set_theme_mods() {
	// General menu
	set_theme_mod( 'content_max_width', '1080px' );
	set_theme_mod( 'navigation_breakpoint', '768px' );
	set_theme_mod( 'navigation_toggle', 1 );
	set_theme_mod( 'navigation_item_color', '#888888' );
	set_theme_mod( 'navigation_item_active_color', '#222222' );
	set_theme_mod( 'navigation_item_hover_color', '#222222' );
	set_theme_mod( 'navigation_sub_item_color', '#888888' );
	set_theme_mod( 'navigation_sub_item_active_color', '#222222' );
	set_theme_mod( 'navigation_sub_item_hover_color', '#222222' );
	set_theme_mod( 'navigation_sub_item_background_color', '#ffffff' );
	set_theme_mod( 'navigation_sub_item_border_color', '#eeeeee' );
	// Main menu
	set_theme_mod( 'main_navigation_toggle', 1 );
	set_theme_mod( 'main_navigation_version', 'default-v1' );
	set_theme_mod( 'main_navigation_background_color', '#ffffff' );
	set_theme_mod( 'main_navigation_scroll_background_color', '#ffffff' );
	set_theme_mod( 'main_navigation_font_size', '14px' );
	set_theme_mod( 'main_navigation_icon_font_size', '20px' );
	set_theme_mod( 'main_navigation_font_weight', 'normal' );
	set_theme_mod( 'kls_logo_height', '53px' );
	// Top menu
	set_theme_mod( 'top_navigation_version', 'default-v1' );
	set_theme_mod( 'top_navigation_background_color', '#222222' );
	set_theme_mod( 'top_navigation_fixed_background_color', '#222222' );
	set_theme_mod( 'top_navigation_item_color', '#dddddd' );
	set_theme_mod( 'top_navigation_item_active_color', '#ffffff' );
	set_theme_mod( 'top_navigation_item_hover_color', '#ffffff' );
	set_theme_mod( 'top_navigation_font_size', '12px' );
	set_theme_mod( 'top_navigation_toggle_contact_info_text', 1 );
	// Mobile
	set_theme_mod( 'mobile_navigation_version', 'bottom_bar-v1' );
	set_theme_mod( 'mobile_navigation_position', 'bottom' );
	set_theme_mod( 'mobile_menu_position', 'right' );
	set_theme_mod( 'mobile_navigation_font_size', '14px' );
	set_theme_mod( 'mobile_navigation_font_weight', 'normal' );
	set_theme_mod( 'mobile_navigation_menu_toggle_color', '#888888' );
	set_theme_mod( 'mobile_navigation_contact_title_color', '#222222' );
	set_theme_mod( 'mobile_navigation_contact_link_color', '#888888' );
	set_theme_mod( 'mobile_navigation_contact_title_font_size', '24px' );
	set_theme_mod( 'mobile_navigation_background_color', '#ffffff' );
	set_theme_mod( 'kls_featured_button_mobile_menu_text', 'Volg ons op instagram' );
	set_theme_mod( 'kls_featured_button_mobile_menu_link', get_option( 'kls_customer_instagram' ) );
	set_theme_mod( 'mobile_bottom_bar_logo_above_content_background_color', '#ffffff' );
	set_theme_mod( 'mobile_bottom_bar_logo_toggle', 1 );
	set_theme_mod( 'mobile_bottom_bar_logo_above_content_toggle', 0 );
	set_theme_mod( 'mobile_bottom_bar_icon_font_size', '18px' );
	set_theme_mod( 'mobile_bottom_bar_icons_color', '#888888' );
	set_theme_mod( 'mobile_bottom_bar_icons_active_color', '#222222' );
	set_theme_mod( 'mobile_bottom_bar_v2_contact_link', '/contact/' );
	set_theme_mod( 'mobile_bottom_bar_v2_contact_text', 'Contact' );
	set_theme_mod( 'mobile_bottom_bar_v2_contact_icon', 'fas fa-envelope' );
	// Woocommerce general
	set_theme_mod( 'general_theme_version', 'v1' );
	set_theme_mod( 'general_disable_standard_woocommerce_styling_toggle', 1 );
	set_theme_mod( 'general_menu_cart_toggle', 1 );
	set_theme_mod( 'general_menu_wishlist_toggle', 1 );
	set_theme_mod( 'general_hot_label_toggle', 1 );
	set_theme_mod( 'general_sales_label_toggle', 1 );
	set_theme_mod( 'general_sales_label_percentage_toggle', 1 );
	set_theme_mod( 'general_image_zoom_effect_toggle', 1 );
	set_theme_mod( 'kls_woocommerce_product_page_version', 'v1' );
	set_theme_mod( 'kls_product_tabs_mode', 'accordion' );

	// Cart
	set_theme_mod( 'cart_recently_viewed_products_toggle', 1 );
	set_theme_mod( 'cart_recently_viewed_products_amount', '3' );
	set_theme_mod( 'cart_upsells_toggle', 1 );
	// Checkout
	set_theme_mod( 'checkout_menu_toggle', 0 );
	set_theme_mod( 'checkout_footer_toggle', 0 );
	set_theme_mod( 'checkout_field_order_toggle', 1 );
	set_theme_mod( 'kls_checkout_button_styling', 'primary' );
	// Product archive
	set_theme_mod( 'archive_sidebar_toggle', 1 );
	set_theme_mod( 'archive_ajax_filter_toggle', 1 );
	set_theme_mod( 'archive_products_per_page_count', '12' );
	set_theme_mod( 'archive_price_toggle', 1 );
	set_theme_mod( 'archive_wishlist_toggle', 1 );
	set_theme_mod( 'archive_quickview_toggle', 1 );
	set_theme_mod( 'archive_filter_read_more_toggle', 0 );
	set_theme_mod( 'archive_filter_read_more_amount', '6' );
	set_theme_mod( 'archive_filter_read_more_text', 'Lees meer' );
	set_theme_mod( 'archive_add_divi_shortcode_id', 'none' );
	set_theme_mod( 'kls_archive_show_sorting', 1 );
	// Product page
	set_theme_mod( 'product_sku_toggle', 0 );
	set_theme_mod( 'product_categories_toggle', 0 );
	set_theme_mod( 'product_tags_toggle', 0 );
	set_theme_mod( 'product_variation_selection_mode_select', 'label' );
	set_theme_mod( 'product_related_products_toggle', 1 );
	set_theme_mod( 'product_related_products_count', '4' );
	set_theme_mod( 'product_related_products_column_count', '4' );
	set_theme_mod( 'product_up_sells_toggle', 1 );
	set_theme_mod( 'product_up_sells_count', '4' );
	set_theme_mod( 'product_up_sells_column_count', '4' );
	set_theme_mod( 'product_add_divi_shortcode_id', 'none' );
	set_theme_mod( 'product_variation_read_more_toggle', 0 );
	set_theme_mod( 'product_variation_read_more_amount', '6' );
	set_theme_mod( 'product_variation_read_more_text', 'Lees meer' );
	// Wishlist
	set_theme_mod( 'wishlist_recently_viewed_products_toggle', 1 );
	set_theme_mod( 'wishlist_recently_viewed_products_amount', '3' );
	set_theme_mod( 'wishlist_stock_status_toggle', 1 );
	// My account
	set_theme_mod( 'my_account_downloads_toggle', 1 );
	// Footer
	set_theme_mod( 'footer_toggle', 1 );
	set_theme_mod( 'footer_version', 'default-v1' );
	set_theme_mod( 'footer_creation_type', 'default' );
	set_theme_mod( 'main_footer_toggle', 1 );
	set_theme_mod( 'main_footer_font_size', '14px' );
	set_theme_mod( 'main_footer_heading_font_size', '22px' );
	set_theme_mod( 'main_footer_background_color', '#eeeeee' );
	set_theme_mod( 'main_footer_text_color', '#222222' );
	set_theme_mod( 'main_footer_heading_text_color', '#222222' );
	set_theme_mod( 'main_footer_link_color', '#848484' );
	set_theme_mod( 'main_footer_link_hover_color', '#000000' );
	set_theme_mod( 'bottom_footer_toggle', 1 );
	set_theme_mod( 'bottom_footer_font_size', '14px' );
	set_theme_mod( 'bottom_footer_background_color', '#eeeeee' );
	set_theme_mod( 'bottom_footer_text_color', '#222222' );
	set_theme_mod( 'bottom_footer_link_color', '#848484' );
	set_theme_mod( 'bottom_footer_link_hover_color', '#000000' );
	// Not found 404
	set_theme_mod( 'theme_404_version', 'default-v1' );
	// Fonts
	set_theme_mod( 'google_fonts_toggle', 1 );
	set_theme_mod( 'kls_headings_font', 'Open Sans' );
	set_theme_mod( 'kls_body_font', 'Open Sans' );
	// Colors
	set_theme_mod( 'primary_color', '#222222' );
	set_theme_mod( 'secundary_color', '#222222' );
	// Fonts colors
	set_theme_mod( 'heading_text_color', '#222222' );
	set_theme_mod( 'body_text_color', '#222222' );
	// Button colors
	set_theme_mod( 'button_link_color', '#222222' );
	set_theme_mod( 'button_link_hover_color', '#222222' );
	set_theme_mod( 'button_primary_color', '#ffffff' );
	set_theme_mod( 'button_primary_background_color', '#222222' );
	set_theme_mod( 'button_primary_border_color', '#222222' );
	set_theme_mod( 'button_primary_hover_color', '#222222' );
	set_theme_mod( 'button_primary_hover_background_color', '#ffffff' );
	set_theme_mod( 'button_primary_hover_border_color', '#222222' );
	set_theme_mod( 'button_secundary_color', '#222222' );
	set_theme_mod( 'button_secundary_background_color', '#eeeeee' );
	set_theme_mod( 'button_secundary_border_color', '#eeeeee' );
	set_theme_mod( 'button_secundary_hover_color', '#eeeeee' );
	set_theme_mod( 'button_secundary_hover_background_color', '#222222' );
	set_theme_mod( 'button_secundary_hover_border_color', '#222222' );

}
// add_action('after_switch_theme', 'kls_set_theme_mods');
