<?php

add_action( 'tgmpa_register', 'register_required_plugins' );

function register_required_plugins()
{
	/**
	 * Register the required plugins for this theme.
	 * 
	 *  In this example, we register two plugins – one included with the TGMPA library
	 *  and one from the .org repo.
	 * 
	 *  The variable passed to tgmpa_register_plugins() should be an array of plugin
	 *  arrays.
	 * 
	 *  This function is hooked into tgmpa_init, which is fired within the
	 *  TGM_Plugin_Activation class constructor.
	 */
	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
		array(
			'name'      => 'Ninja Forms',
			'slug'      => 'ninja-forms',
			'required'  => true,
		),

		array(
			'name'      => 'Yoast SEO',
			'slug'      => 'wordpress-seo',
			'required'  => false,
		),

		array(
			'name' => 'Duplicator',
			'slug' => 'duplicator',
			'required' => false,
		),

		array(
			'name'      => 'Better Search Replace',
			'slug'      => 'better-search-replace',
			'required'  => false,
		),

		array(
			'name'      => 'Redirection',
			'slug'      => 'redirection',
			'required'  => false,
		),

		array(
			'name'      => 'TablePress',
			'slug'      => 'tablepress',
			'required'  => false,
		),
	
		array(
			'name'      => 'Click to Chat',
			'slug'      => 'click-to-chat-for-whatsapp',
			'required'  => false,
		),

		array(
			'name'      => 'Simple Job Board',
			'slug'      => 'simple-job-board',
			'required'  => false,
		),

		array(
			'name'      => 'Smash Balloon Social Photo Feed',
			'slug'      => 'instagram-feed',
			'required'  => false,
		),

		array(
			'name'      => 'PublishPress Capabilities',
			'slug'      => 'capability-manager-enhanced',
			'required'  => true,
		),

		array(
			'name'      => 'WP Mail SMTP by WPForms',
			'slug'      => 'wp-mail-smtp',
			'required'  => true,
		),


		array(
			'name'      => 'ManageWP Worker',
			'slug'      => 'worker',
			'required'  => true,
		),

		array(
			'name'      => 'Wordfence',
			'slug'      => 'wordfence',
			'required'  => true,
		),

		array(
			'name'      => 'Woocommerce',
			'slug'      => 'woocommerce',
			'required'  => false,
		),

		array(
			'name'      => 'YITH WooCommerce Wishlist',
			'slug'      => 'yith-woocommerce-wishlist',
			'required'  => false,
		),

		array(
			'name'      => 'Mollie',
			'slug'      => 'mollie-payments-for-woocommerce',
			'required'  => false,
		),

		array(
			'name'      => 'YITH WooCommerce Ajax Product Filter',
			'slug'      => 'yith-woocommerce-ajax-navigation',
			'required'  => false,
		),

		array(
			'name'      => 'YITH WooCommerce Gift Cards',
			'slug'      => 'yith-woocommerce-gift-cards',
			'required'  => false,
		),

		array(
			'name'      => 'YITH WooCommerce Ajax Search',
			'slug'      => 'yith-woocommerce-ajax-search',
			'required'  => false,
		),

		array(
			'name'      => 'YITH WooCommerce Quick View',
			'slug'      => 'yith-woocommerce-quick-view',
			'required'  => false,
		),

		array(
			'name'      => 'Variation Swatches for WooCommerce',
			'slug'      => 'woo-variation-swatches',
			'required'  => false,
		),

		array(
			'name'      => 'PDF Invoices & Packing Slips for WooCommerce',
			'slug'      => 'woocommerce-pdf-invoices-packing-slips',
			'required'  => false,
		),

		array(
			'name' => 'Product Attachment for WooCommerce',
			'slug' => 'woo-product-attachment',
			'required' => false,
		),

		array(
			'name'      => 'WP Rocket',
			'slug'      => 'wp-rocket',
			'source'    => 'https://klassebv.nl/theme-plugins/wp-rocket.zip',
			'required'  => false,
		),

		array(
			'name'      => 'Divi Builder',
			'slug'      => 'divi-builder',
			'source'    => 'https://klassebv.nl/theme-plugins/divi-builder.zip',
			'required'  => true,
		),

		array(
			'name'      => 'Ninja Forms Conditional Logic',
			'slug'      => 'ninja-forms-conditional-logic-v3.1',
			'source'    => 'https://klassebv.nl/theme-plugins/ninja-forms-conditional-logic.zip',
			'required'  => false,
		),

		array(
			'name'      => 'Ninja Forms Layout & Styles',
			'slug'      => 'ninja-forms-layout-styles-v3.0.29',
			'source'    => 'https://klassebv.nl/theme-plugins/ninja-forms-layout-styles.zip',
			'required'  => false,
		),

		array(
			'name'      => 'Ninja Forms Multi Step Forms',
			'slug'      => 'ninja-forms-multi-part-v3.0.26',
			'source'    => 'https://klassebv.nl/theme-plugins/ninja-forms-multi-part.zip',
			'required'  => false,
		),

		array(
			'name'      => 'Ninja Forms Zapier',
			'slug'      => 'ninja-forms-zapier-v3.0.8',
			'source'    => 'https://klassebv.nl/theme-plugins/ninja-forms-zapier.zip',
			'required'  => false,
		),
	);

	if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' ) {
		$plugins[] = 
		array(
			'name'      => 'SyncSilo',
			'slug'      => 'syncsilo-woocommerce',
			'source'    => 'https://syncsilo-wp.s3-eu-west-1.amazonaws.com/syncsilo-woocommerce.zip',
			'required'  => false,
		);
	}

	/**
	 * Array of configuration settings. Amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * leave the strings uncommented.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	// if(function_exists('buildUpdateChecker')){
	if (in_array( 'klasse-plugin/klasse-plugin.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) )) {
		$config = array(
			'default_path' => '', // Default absolute path to pre-packaged plugins.
			'menu' => 'kls_install_plugins', // Menu slug.
			'parent_slug' => 'kls_dashboard',
			'capability' => 'manage_kls',
			'has_notices' => true, // Show admin notices or not.
			'dismissable' => true, // If false, a user cannot dismiss the nag message.
			'dismiss_msg' => '', // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false, // Automatically activate plugins after installation or not.
			'message' => '', // Message to output right before the plugins table.
			'strings' => array(
				'page_title' => __( 'Install Required Plugins', 'kls' ),
				'menu_title' => __( 'Install Plugins', 'kls' ),
				'installing' => __( 'Installing Plugin: %s', 'kls' ), // %s = plugin name.
				'oops' => __( 'Something went wrong with the plugin API.', 'kls' ),
				'notice_can_install_required' => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s).
				'notice_can_install_recommended' => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s).
				'notice_cannot_install' => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s).
				'notice_can_activate_required' => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s).
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s).
				'notice_cannot_activate' => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s).
				'notice_ask_to_update' => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s).
				'notice_cannot_update' => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s).
				'install_link' => _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
				'activate_link' => _n_noop( 'Begin activating plugin', 'Begin activating plugins' ),
				'return' => __( 'Return to Required Plugins Installer', 'kls' ),
				'plugin_activated' => __( 'Plugin activated successfully.', 'kls' ),
				'complete' => __( 'All plugins installed and activated successfully. %s', 'kls' ), // %s = dashboard link.
				'nag_type' => 'updated', // Determines admin notice type – can only be 'updated', 'update-nag' or 'error'.
			),
		);
	} else {
		$config = array(
			'default_path' => '', // Default absolute path to pre-packaged plugins.
			'menu' => 'kls_install_plugins', // Menu slug.
		// 'parent_slug' => 'kls_dashboard',
		// 'capability' => 'manage_kls',
			'has_notices' => true, // Show admin notices or not.
			'dismissable' => true, // If false, a user cannot dismiss the nag message.
			'dismiss_msg' => '', // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false, // Automatically activate plugins after installation or not.
			'message' => '', // Message to output right before the plugins table.
			'strings' => array(
				'page_title' => __( 'Install Required Plugins', 'kls' ),
				'menu_title' => __( 'Install Plugins', 'kls' ),
				'installing' => __( 'Installing Plugin: %s', 'kls' ), // %s = plugin name.
				'oops' => __( 'Something went wrong with the plugin API.', 'kls' ),
				'notice_can_install_required' => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s).
				'notice_can_install_recommended' => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s).
				'notice_cannot_install' => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s).
				'notice_can_activate_required' => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s).
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s).
				'notice_cannot_activate' => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s).
				'notice_ask_to_update' => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s).
				'notice_cannot_update' => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s).
				'install_link' => _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
				'activate_link' => _n_noop( 'Begin activating plugin', 'Begin activating plugins' ),
				'return' => __( 'Return to Required Plugins Installer', 'kls' ),
				'plugin_activated' => __( 'Plugin activated successfully.', 'kls' ),
				'complete' => __( 'All plugins installed and activated successfully. %s', 'kls' ), // %s = dashboard link.
				'nag_type' => 'updated', // Determines admin notice type – can only be 'updated', 'update-nag' or 'error'.
			),
		);
	}

	tgmpa( $plugins, $config );
}
