<?php

/**
 * Load theme textdomain
 *
 * @since 0.0.63
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
load_theme_textdomain( 'klasse-theme', TEMPLATEPATH . '/languages' );

/**
 * Require the theme config
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 */
require_once __DIR__ . '/includes/theme-configuration.php';


/**
 * Require admin functions
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( is_admin() ) {
	require_once __DIR__ . '/admin/klasse-theme-admin.php';
	require_once __DIR__ . '/includes/installation.php';
}

/**
* Require public functions
*
* @since 0.0.04
* @author Joeri van der Stek <joeri@klassebv.nl>
*/
require_once __DIR__ . '/public/klasse-theme-public.php';

/**
 * Include add-ons
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( is_admin() ) {
	require_once __DIR__ . '/includes/add-ons/plugin-installer/plugin-installer-options.php';
	require_once __DIR__ . '/includes/add-ons/plugin-installer/class-tgm-plugin-activation.php';
}

if ( isset( $GLOBALS['wp_customize'] ) ) {
	require_once __DIR__ . '/includes/add-ons/alpha-color-picker/alpha-color-picker.php';
}

/**
 * Set global variables
 *
 * @since 0.0.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$kls_theme         = wp_get_theme( 'klasse-theme' );
$kls_theme_version = $kls_theme->get( 'Version' );

define('KT_THEME', '/klasse-theme/');
define('KT_THEME_PATH', get_template_directory_uri() . KT_THEME);
define('KT_ASSETS_PATH', get_template_directory_uri() . '/assets/');
define('KT_ASSETS_PATH_ADMIN', KT_ASSETS_PATH . 'build/admin/');
define('KT_ASSETS_PATH_PUBLIC_SCRIPTS', KT_ASSETS_PATH . 'build/public/');
define('KT_ASSETS_PATH_PUBLIC_STYLES', KT_ASSETS_PATH . 'build/public/');

/**
 * Add the plugin update checker function
 *
 * @since 0.0.01
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require 'vendor/yahnis-elsts/plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

if ( is_admin() && get_option( 'kls_updates_toggle' ) == 'on' ) {
	$kls_update_checker = PucFactory::buildUpdateChecker(
		'https://github.com/Klasse-Software-Development-B-V/klasse-theme',
		__FILE__,
		'klasse-theme'
	);

	$kls_update_checker->setAuthentication( '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' );

	if ( get_option( 'kls_beta_updates_toggle' ) == 'on' ) {
		$kls_update_checker->setBranch( 'development' );
	} else {
		$kls_update_checker->setBranch( 'main' );
	}

	$kls_update_checker->getVcsApi()->enableReleaseAssets();
}

/**
 * Add theme support
 *
 * @since 0.0.14
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_support() {
	add_theme_support(
		'woocommerce',
		array(
			'product_grid'                  => array(
				'default_columns' => 3,
				'min_columns'     => 2,
				'max_columns'     => 4,
			),
			'gallery_thumbnail_image_width' => 150,
		)
	);
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'kls_theme_support' );
