jQuery(document).on('ready', function () {
	var fadeOutTimer;
	var productShowcase = jQuery('.mega-product-menu .product-menu-showcase');

	jQuery('.mega-product-menu').on('mouseenter', '.menu-item.product-item a', function () {
		if (fadeOutTimer) {
			clearTimeout(fadeOutTimer);
		}

		var $this = jQuery(this);
		var productID = $this.parent().data('product-id');

		if (productID !== undefined) {
			var productImage = $this.parent().data('product-image');
			var productTitle = $this.parent().data('product-name');
			var productShortDesc = $this.parent().data('product-description');
			var productShipping = $this.parent().data('product-24');
			var productShippingHtml = '';
			var productShippingHtmlLong = '';

			if (productShipping == 1) {
				productShippingHtml = '<span class="always-shipping">24u</span>';
				productShippingHtmlLong = '<p class="alway-shipping-text" style="display: none;">Voor 21:30 besteld, binnen 2 werkdagen geleverd</p>';
			}

			productShowcase.html(`
                <img src="${productImage}" alt="${productTitle}">
                <p class="title">${productTitle} ${productShippingHtml}</p>
                <p>${productShortDesc}</p>
                ${productShippingHtmlLong}
            `);

			productShowcase.stop(true, true).hide().fadeIn('fast');
		}
	}).on('mouseleave', '.menu-item.product-item a', function () {
		fadeOutTimer = setTimeout(function () {
			productShowcase.stop(true, true).fadeOut('fast', function () {
				jQuery(this).html('');
			});
		}, 300);
	});
});
