<?php // phpcs:ignore
/**
 * Popup page class
 *
 * @category   Klasse_Plugin
 * @package    KT
 * @subpackage KT/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.77
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Popup_Page')) {
	/**
	 * Popup page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KT_Popup_Page
	{
		/**
		 * Construct the popup page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			if (in_array('klasse-plugin/klasse-plugin.php', apply_filters('active_plugins', get_option('active_plugins')))) {
				add_submenu_page('kls_dashboard', __('Popup', 'klasse-theme'), __('Popup', 'klasse-theme'), 'manage_kls_theme', 'kls_popup_page', array($this, 'popupPageOutput'));
			} else {
				add_submenu_page('options-general.php', __('Popup', 'klasse-theme'), __('Popup', 'klasse-theme'), 'manage_kls_theme', 'kls_popup_page', array($this, 'popupPageOutput'));
			}
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Popup', 'klasse-theme'),
				'description' => __('Popup settings', 'klasse-theme'),
				'url' => 'kls_popup_page',
				'capability' => 'manage_kls_theme',
				'order' => '48',
			);

			return $pages;
		}

		/**
		 * Popup page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function popupPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_kls_theme')) {
				return;
			}

			if (in_array('klasse-plugin/klasse-plugin.php', apply_filters('active_plugins', get_option('active_plugins')))) {
				require WP_PLUGIN_DIR . '/klasse-plugin/admin/pages/components/header.class.php';
			}
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Popup', 'klasse-theme'); ?>
								</h1>
								<p>
									<?php _e('', 'klasse-theme'); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_popup_section');

									do_settings_sections('kls_popup');

									// Output save settings button..
									submit_button(__('Save', 'klasse-theme'));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KT_Popup_Page();
}