<?php // phpcs:ignore
/**
 * Help page class
 *
 * @category   Klasse_Plugin
 * @package    KT
 * @subpackage KT/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.77
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Help_Page')) {
	/**
	 * Help page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KT_Help_Page
	{
		/**
		 * Construct the help page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('kp_help_nav', array($this, 'helpPageNavOutput'));
			add_action('kp_help_content', array($this, 'helpPageContentOutput'));
			add_action('kp_help_general_tab', array($this, 'helpPageGeneralShortcodes'));
		}

		/**
		 * Help page nav output.
		 * 
		 * @param string $active_tab String of the active tab.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function helpPageNavOutput($active_tab)
		{
			?>
			<a href="?page=kls_help_page&tab=kt_woocommerce" class="nav-tab <?php echo $active_tab == 'kt_woocommerce' ? 'nav-tab-active' : ''; ?>"><?php _e('WooCommerce shortcodes', 'klasse-theme'); ?></a>
			<?php
		}

		/**
		 * Help page content output.
		 * 
		 * @param string $active_tab String of the active tab.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function helpPageContentOutput($active_tab)
		{
			if ($active_tab == 'kt_woocommerce'): ?>
				<h2>
					<?php _e('WooCommerce shortcodes', 'klasse-theme'); ?>
				</h2>
				<h3>
					<?php _e('Product shortcodes', 'klasse-theme'); ?>
				</h3>
				<p>
					<?php _e('Product slider', 'klasse-theme'); ?>: <code>[product_slider orderby="name" order="asc"]</code>
				</p>
				<p>
					<?php _e('Product slider small', 'klasse-theme'); ?>: <code>[product_slider_small orderby="name" order="asc" maximum="4" exclude_id="12,54"]</code>
				</p>
				<p>
					<?php _e('Product slider page', 'klasse-theme'); ?>: <code>[product_slider_page orderby="name" order="asc"]</code>
				</p>
				<p>
					<?php _e('Product block', 'klasse-theme'); ?>: <code>[product_block orderby="name" order="asc" maximum="4"]</code>
				</p>

				<h3>
					<?php _e('Category shortcodes', 'klasse-theme'); ?>
				</h3>
				<p>
					<?php _e('Category slider', 'klasse-theme'); ?>: <code>[category_slider orderby="name" order="asc" hide_empty="1" exclude_id="12,36" include_id="43,78"]</code>
				</p>
				<p>
					<?php _e('Category block layout', 'klasse-theme'); ?>: <code>[category_block_layout orderby="name" order="asc" hide_empty="1" exclude_id="12,36" include_id="43,78" layout="two-three" maximum="100"]</code>
				</p>

				<h3>
					<?php _e('Other shortcodes', 'klasse-theme'); ?>
				</h3>
				<p>
					<?php _e('Login form shortcode', 'klasse-theme'); ?>: <code>[login_form redirect_url="https://domain.com/test-page/"]</code>
				</p>
				<p>
					<?php _e('Lost password', 'klasse-theme'); ?>: <code>[login_form_middle]</code>
				</p>
				<?php
			endif;
		}

		/**
		 * Help page general tab content output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function helpPageGeneralShortcodes()
		{
			?>
			<p>
				<?php _e('Theme button shortcode', 'klasse-theme'); ?>: <code>[theme_button text="Button text" styling="primary" url="/test-page/" target="_blank" rel="noopener" data-test="test" data-test-two="test 2" class="classname#1 classname#2"]</code>
			</p>
			<?php
		}
	}

	new KT_Help_Page();
}