<?php // phpcs:ignore
/**
 * Action bar page class
 *
 * @category   Klasse_Plugin
 * @package    KT
 * @subpackage KT/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.77
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Action_Bar_Page')) {
	/**
	 * Action bar page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KT_Action_Bar_Page
	{
		/**
		 * Construct the action bar page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			if (in_array('klasse-plugin/klasse-plugin.php', apply_filters('active_plugins', get_option('active_plugins')))) {
				add_submenu_page('kls_dashboard', __('Action bar', 'klasse-theme'), __('Action bar', 'klasse-theme'), 'manage_kls_theme', 'kls_action_bar', array($this, 'actionBarPageOutput'));
			} else {
				add_submenu_page('options-general.php', __('Action bar', 'klasse-theme'), __('Action bar', 'klasse-theme'), 'manage_kls_theme', 'kls_action_bar', array($this, 'actionBarPageOutput'));
			}
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Actionbar', 'klasse-theme'),
				'description' => __('Actionbar settings', 'klasse-theme'),
				'url' => 'kls_action_bar',
				'capability' => 'manage_kls_theme',
				'order' => '45',
			);

			return $pages;
		}

		/**
		 * Action bar page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function actionBarPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_kls_theme')) {
				return;
			}

			if (in_array('klasse-plugin/klasse-plugin.php', apply_filters('active_plugins', get_option('active_plugins')))) {
				require WP_PLUGIN_DIR . '/klasse-plugin/admin/pages/components/header.class.php';
			}
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Actionbar settings', 'klasse-theme'); ?>
								</h1>
								<p>
									<?php _e('Action bar that displays an action with or withouth a button. If minimized it stays minimized for 1 day.', 'klasse-theme'); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_action_bar_section');

									do_settings_sections('kls_action_bar');

									// output save settings button
									submit_button(__('Save', 'klasse-theme'));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KT_Action_Bar_Page();
}