<?php

/**
 * Include theme admin includes
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/includes/permissions/permissions.php';
require_once __DIR__ . '/includes/options.php';
require_once __DIR__ . '/includes/wordpress/menus.php';
require_once __DIR__ . '/includes/settings/settings.php';

/**
 * Theme pages files.
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once 'pages/action_bar.class.php';
require_once 'pages/popup.class.php';
require_once 'pages/theme.class.php';
require_once 'pages/help.class.php';

function kt_theme_setup_link()
{
	?>
	<a href="#" class="kls-setup-button" disabled>
		<span class="dashicons dashicons-admin-settings"></span>
		<span>
			<?php _e('Theme setup', 'klasse-theme'); ?>
		</span>
	</a>
	<?php
}
add_action('kp_topbar_installer_links', 'kt_theme_setup_link');

function kt_theme_version()
{
	?>
	<br>
	<?php _e('Theme version', 'klasse-plugin'); ?>:
	<?php echo $GLOBALS['kls_theme_version'];
}
add_action('kp_sidebar_info', 'kt_theme_version');

// Todo, this causes php warnings.
function kt_change_submenu_order($menu_ord)
{
	global $submenu;

	$arr = array();
	$arr[] = $submenu['kls_dashboard'][0];
	$arr[] = $submenu['kls_dashboard'][1];
	$arr[] = $submenu['kls_dashboard'][2];
	$arr[] = $submenu['kls_dashboard'][3];
	if (get_option('kls_webshop_toggle') == 'on') {
		$arr[] = $submenu['kls_dashboard'][13];
		$arr[] = $submenu['kls_dashboard'][14];
	} else {
		$arr[] = $submenu['kls_dashboard'][12];
		$arr[] = $submenu['kls_dashboard'][13];
	}
	$arr[] = $submenu['kls_dashboard'][4];
	$arr[] = $submenu['kls_dashboard'][5];
	$arr[] = $submenu['kls_dashboard'][6];
	$arr[] = $submenu['kls_dashboard'][7];
	$arr[] = $submenu['kls_dashboard'][8];
	$arr[] = $submenu['kls_dashboard'][9];
	$arr[] = $submenu['kls_dashboard'][10];
	if (get_option('kls_webshop_toggle') == 'on') {
		$arr[] = $submenu['kls_dashboard'][15];
	} else {
		$arr[] = $submenu['kls_dashboard'][14];
	}
	$arr[] = $submenu['kls_dashboard'][11];
	$arr[] = $submenu['kls_dashboard'][12];
	if (get_option('kls_webshop_toggle') == 'on') {
		$arr[] = $submenu['kls_dashboard'][16];
	} else {
		$arr[] = $submenu['kls_dashboard'][15];
	}
	$submenu['kls_dashboard'] = $arr;

	return $menu_ord;
}
add_filter('custom_menu_order', 'kt_change_submenu_order');
