<?php

/**
 * Create all sections
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_theme_sections() {
	add_settings_section( 'kls_theme_section', __( 'Customer data', 'klasse-theme' ), 'kls_section_cb_empty_theme', 'kls_theme_settings' );
	add_settings_section( 'kls_action_bar_section', __( 'Action bar', 'klasse-theme' ), 'kls_section_cb_empty_theme', 'kls_action_bar' );

	// Popup.
	add_settings_section( 'kls_popup_section', __( 'Popup page', 'klasse-theme' ), 'kls_section_cb_empty_theme', 'kls_popup' );
}
add_action( 'admin_init', 'kls_create_theme_sections' );

/**
 * Create theme settings fields
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_theme() {
	if ( ! in_array( 'klasse-plugin/klasse-plugin.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		add_settings_field(
			'kls_updates_toggle',
			__( 'Toggle updates', 'klasse-theme' ),
			'kls_theme_toggle_field',
			'kls_theme_settings',
			'kls_theme_section',
			array(
				'label_for'   => 'kls_updates_toggle',
				'check_value' => 'on',
			)
		);
	}
	add_settings_field(
		'kls_theme_settings_toggle',
		__( 'Toggle theme settings', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for'   => 'kls_theme_settings_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_syncsilo_compatibility_toggle',
		__( 'Toggle Syncsilo compatibility', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for'   => 'kls_syncsilo_compatibility_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_faq_module_toggle',
		__( 'Toggle FAQ module', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for'   => 'kls_faq_module_toggle',
			'check_value' => 'on',
		)
	);
	// add_settings_field('kls_theme_header_toggle', __('Toggle theme header', 'klasse-theme'), 'kls_theme_toggle_field', 'kls_theme_settings', 'kls_theme_section', ['label_for' => 'kls_theme_header_toggle', 'check_value' => 'on', 'info_text' => __('Toggle this off if you want to use the Divi Theme builder for the header.', 'klasse-theme')]);
	// add_settings_field('kls_theme_footer_toggle', __('Toggle theme footer', 'klasse-theme'), 'kls_theme_toggle_field', 'kls_theme_settings', 'kls_theme_section', ['label_for' => 'kls_theme_footer_toggle', 'check_value' => 'on', 'info_text' => __('Toggle this off if you want to use the Divi Theme builder for the footer.', 'klasse-theme')]);

	add_settings_field(
		'kls_theme_deinstallation_toggle',
		__( 'Toggle theme deinstallation', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for'   => 'kls_theme_deinstallation_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_ratings_select',
		__( 'Select ratings method', 'klasse-theme' ),
		'kls_theme_select_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for' => 'kls_ratings_select',
			'selects'   => array( 'Manually', 'Kiyoh', 'Site-Reviews-plugin' ),
			'class'     => 'select-choice',
		)
	);
	add_settings_field(
		'kls_rating',
		__( 'Manual rating percentage', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for' => 'kls_rating',
			'class'     => 'select-row manually',
		)
	);
	add_settings_field(
		'kls_rating_url',
		__( 'Manual rating url', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for' => 'kls_rating_url',
			'class'     => 'select-row manually site-reviews-plugin',
		)
	);
	add_settings_field(
		'kls_rating_text',
		__( 'Manual rating text', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for' => 'kls_rating_text',
			'class'     => 'select-row manually',
		)
	);
	add_settings_field(
		'kls_rating_image',
		__( 'Manual rating image', 'klasse-theme' ),
		'kls_theme_image_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for'   => 'kls_rating_image',
			'button_text' => __( 'Manual rating image', 'klasse-theme' ),
			'class'       => 'select-row manually site-reviews-plugin',
		)
	);
	add_settings_field(
		'kls_kiyoh_url',
		__( 'Kiyoh url', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_theme_settings',
		'kls_theme_section',
		array(
			'label_for' => 'kls_kiyoh_url',
			'class'     => 'select-row kiyoh',
		)
	);

	if ( current_user_can( 'administrator' ) ) :
		add_settings_field(
			'kls_theme_admin_link_toggle',
			__( 'Toggle Admin link in bottom bar', 'klasse-theme' ),
			'kls_theme_toggle_field',
			'kls_theme_settings',
			'kls_theme_section',
			array(
				'label_for'   => 'kls_theme_admin_link_toggle',
				'check_value' => 'on',
			)
		);
	endif;
}
add_action( 'admin_init', 'kls_create_settings_theme' );

/**
 * Register theme settings
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_theme() {
	if ( ! in_array( 'klasse-plugin/klasse-plugin.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		register_setting( 'kls_theme_section', 'kls_updates_toggle' );
	}
	register_setting( 'kls_theme_section', 'kls_theme_settings_toggle' );
	register_setting( 'kls_theme_section', 'kls_syncsilo_compatibility_toggle' );
	register_setting( 'kls_theme_section', 'kls_faq_module_toggle' );
	// register_setting('kls_theme_section', 'kls_theme_header_toggle');
	// register_setting('kls_theme_section', 'kls_theme_footer_toggle');
	register_setting( 'kls_theme_section', 'kls_theme_deinstallation_toggle' );
	register_setting( 'kls_theme_section', 'kls_ratings_select' );
	register_setting( 'kls_theme_section', 'kls_rating' );
	register_setting( 'kls_theme_section', 'kls_rating_url' );
	register_setting( 'kls_theme_section', 'kls_rating_text' );
	register_setting( 'kls_theme_section', 'kls_rating_image' );
	register_setting( 'kls_theme_section', 'kls_kiyoh_url' );
	if ( current_user_can( 'administrator' ) ) :
		register_setting( 'kls_theme_section', 'kls_theme_admin_link_toggle' );
	endif;
}
add_action( 'admin_init', 'kls_register_settings_theme' );

/**
 * Create action bar fields
 *
 * @since 0.0.73
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_action_bar() {
	add_settings_field(
		'kls_action_bar_toggle',
		__( 'Toggle action bar', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_action_bar',
		'kls_action_bar_section',
		array(
			'label_for'   => 'kls_action_bar_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field( 'kls_action_bar_text', __( 'Action bar text', 'klasse-theme' ), 'kls_theme_wysiwyg_field', 'kls_action_bar', 'kls_action_bar_section', array( 'label_for' => 'kls_action_bar_text' ) );
	add_settings_field( 'kls_action_bar_text_color', __( 'Action bar text color', 'klasse-theme' ), 'kls_theme_colorpicker_field', 'kls_action_bar', 'kls_action_bar_section', array( 'label_for' => 'kls_action_bar_text_color' ) );
	add_settings_field(
		'kls_action_bar_button_toggle',
		__( 'Toggle action bar button', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_action_bar',
		'kls_action_bar_section',
		array(
			'label_for'   => 'kls_action_bar_button_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field( 'kls_action_bar_button_text', __( 'Action bar button text', 'klasse-theme' ), 'kls_theme_text_field', 'kls_action_bar', 'kls_action_bar_section', array( 'label_for' => 'kls_action_bar_button_text' ) );
	add_settings_field(
		'kls_action_bar_button_styling',
		__( 'Action bar button styling', 'klasse-theme' ),
		'kls_theme_select_field',
		'kls_action_bar',
		'kls_action_bar_section',
		array(
			'label_for' => 'kls_action_bar_button_styling',
			'selects'   => array_keys( $GLOBALS['kls_buttons'] ),
		)
	);
	add_settings_field( 'kls_action_bar_url', __( 'Action bar button url', 'klasse-theme' ), 'kls_theme_text_field', 'kls_action_bar', 'kls_action_bar_section', array( 'label_for' => 'kls_action_bar_url' ) );
	add_settings_field(
		'kls_action_bar_close_button_location',
		__( 'Action bar close button location', 'klasse-theme' ),
		'kls_theme_radio_field',
		'kls_action_bar',
		'kls_action_bar_section',
		array(
			'label_for' => 'kls_action_bar_close_button_location',
			'radios'    => array(
				'Left',
				'Right',
			),
		)
	);
	add_settings_field( 'kls_action_bar_background_color', __( 'Action bar background color', 'klasse-theme' ), 'kls_theme_colorpicker_field', 'kls_action_bar', 'kls_action_bar_section', array( 'label_for' => 'kls_action_bar_background_color' ) );
}
add_action( 'admin_init', 'kls_create_settings_action_bar' );

/**
 * Register theme settings
 *
 * @since 0.0.73
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_action_bar() {
	register_setting( 'kls_action_bar_section', 'kls_action_bar_toggle' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_text' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_text_color' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_button_toggle' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_button_text' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_button_styling' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_url' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_background_color' );
	register_setting( 'kls_action_bar_section', 'kls_action_bar_close_button_location' );
}
add_action( 'admin_init', 'kls_register_settings_action_bar' );

/**
 * Create popup page settings
 *
 * @since 0.1.71
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_popup() {
	add_settings_field(
		'kls_popup_toggle',
		__( 'Toggle popup', 'klasse-theme' ),
		'kls_theme_toggle_field',
		'kls_popup',
		'kls_popup_section',
		array(
			'label_for'   => 'kls_popup_toggle',
			'check_value' => 'on',
		)
	);

	add_settings_field( 'kls_popup_title', __( 'Title', 'klasse-theme' ), 'kls_theme_text_field', 'kls_popup', 'kls_popup_section', array( 'label_for' => 'kls_popup_title' ) );
	add_settings_field( 'kls_popup_text', __( 'Text', 'klasse-theme' ), 'kls_theme_wysiwyg_field', 'kls_popup', 'kls_popup_section', array( 'label_for' => 'kls_popup_text' ) );

	add_settings_field(
		'kls_popup_image',
		__( 'Popup image', 'klasse-theme' ),
		'kls_theme_image_field',
		'kls_popup',
		'kls_popup_section',
		array(
			'label_for'   => 'kls_popup_image',
			'button_text' => __( 'Upload image', 'klasse-theme' ),
		)
	);

	add_settings_field( 'kls_popup_cookie_name', __( 'Cookie name (Change this to reset the cookie)', 'klasse-theme' ), 'kls_theme_text_field', 'kls_popup', 'kls_popup_section', array( 'label_for' => 'kls_popup_cookie_name' ) );
	add_settings_field( 'kls_popup_cookie_expiration', __( 'Cookie expiration in days', 'klasse-theme' ), 'kls_theme_text_field', 'kls_popup', 'kls_popup_section', array( 'label_for' => 'kls_popup_cookie_expiration' ) );

	add_settings_field(
		'kls_popup_cta_method',
		__( 'Select call to action methode', 'klasse-theme' ),
		'kls_theme_select_field',
		'kls_popup',
		'kls_popup_section',
		array(
			'label_for' => 'kls_popup_cta_method',
			'selects'   => array( 'none', 'form', 'buttoncta' ),
			'class'     => 'select-choice',
		)
	);

	add_settings_field(
		'kls_popup_form_shortcode',
		__( 'Form shortcode', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_popup',
		'kls_popup_section',
		array(
			'label_for' => 'kls_popup_form_shortcode',
			'class'     => 'select-row form',
		)
	);

	add_settings_field(
		'kls_popup_button_text',
		__( 'Button text', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_popup',
		'kls_popup_section',
		array(
			'label_for' => 'kls_popup_button_text',
			'class'     => 'select-row buttoncta',
		)
	);
	add_settings_field(
		'kls_popup_button_url',
		__( 'Button url', 'klasse-theme' ),
		'kls_theme_text_field',
		'kls_popup',
		'kls_popup_section',
		array(
			'label_for' => 'kls_popup_button_url',
			'class'     => 'select-row buttoncta',
		)
	);

	add_settings_field( 'kls_popup_background_color', __( 'Background color', 'klasse-theme' ), 'kls_theme_colorpicker_field', 'kls_popup', 'kls_popup_section', array( 'label_for' => 'kls_popup_background_color' ) );
	add_settings_field( 'kls_popup_text_color', __( 'Text color', 'klasse-theme' ), 'kls_theme_colorpicker_field', 'kls_popup', 'kls_popup_section', array( 'label_for' => 'kls_popup_text_color' ) );

}
add_action( 'admin_init', 'kls_create_settings_popup' );

/**
 * Register popup settings
 *
 * @since 0.1.71
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_popup() {
	register_setting( 'kls_popup_section', 'kls_popup_toggle' );

	register_setting( 'kls_popup_section', 'kls_popup_title' );
	register_setting( 'kls_popup_section', 'kls_popup_text' );

	register_setting( 'kls_popup_section', 'kls_popup_image' );

	register_setting( 'kls_popup_section', 'kls_popup_cta_method' );

	register_setting( 'kls_popup_section', 'kls_popup_form_shortcode' );

	register_setting( 'kls_popup_section', 'kls_popup_button_text' );
	register_setting( 'kls_popup_section', 'kls_popup_button_url' );

	register_setting( 'kls_popup_section', 'kls_popup_background_color' );
	register_setting( 'kls_popup_section', 'kls_popup_text_color' );
}
add_action( 'admin_init', 'kls_register_settings_popup' );

/**
 * Create section callbacks
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_section_cb_empty_theme() { }

/**
 * Require all the field callbacks
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/field_callbacks.php';
