<?php
/**
 * Create text field callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_text_field( $args ) {
	$field_name = $args['label_for'];
	$options    = get_option( $field_name );
	?>
		<input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $options; ?>" 
											<?php
											if ( isset( $args['placeholder'] ) ) {
												$placeholder = $args['placeholder'];
												?>
			placeholder="<?php echo $placeholder; ?>" 
												<?php
											};
											?>
								  class="kls_input kls_text_field"/>
		
	<?php
	if ( isset( $args['info_text'] ) ) {
		$info_text = $args['info_text'];

		?>
		<p class="small"><?php echo $info_text; ?></p>
		<?php
	}
}

/**
 * Create textarea field callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_textarea_field( $args ) {
	$field_name = $args['label_for'];
	$options    = get_option( $field_name );

	?>
		<textarea type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" class="kls_textarea"><?php echo $options; ?></textarea>
	<?php
	if ( isset( $args['info_text'] ) ) {
		$info_text = $args['info_text'];

		?>
		<p class="small"><?php echo $info_text; ?></p>
		<?php
	}
}

/**
 * Create select field callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_select_field( $args ) {
	$field_name     = $args['label_for'];
	$select_options = $args['selects'];
	$options        = get_option( $field_name );
	?>

	<select id='<?php echo $field_name; ?>' name='<?php echo $field_name; ?>' class="kls_input kls_select">
		<?php
		foreach ( $select_options as $select_option ) {
			$selected = ( $options == $select_option ) ? 'selected="selected"' : '';
			?>
			<option value='<?php echo $select_option; ?>' <?php echo $selected; ?>><?php _e( $select_option ); ?></option>
		<?php } ?>
	</select>
	<?php
	if ( isset( $args['info_text'] ) ) {
		$info_text = $args['info_text'];

		?>
		<p class="small"><?php echo $info_text; ?></p>
		<?php
	}
}

/**
 * Create toggle field
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_toggle_field( $args ) {
	$field_name  = $args['label_for'];
	$check_value = $args['check_value'];
	$options     = get_option( $field_name );

	$checked = ( $options == true ) ? 'checked' : '';
	?>
		<label for="<?php echo $field_name; ?>" class="kls_toggle">
			<input <?php echo $checked; ?> type="checkbox" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $check_value; ?>"/>
			<span class="slider"></span>
		</label>
	<?php
	if ( isset( $args['info_text'] ) ) {
		$info_text = $args['info_text'];

		?>
		<p class="small"><?php echo $info_text; ?></p>
		<?php
	}
}

/**
 * Create color picker callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_colorpicker_field( $args ) {
	 $field_name = $args['label_for'];
	$options     = get_option( $field_name );

	?>
		<input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $options; ?>" class="color-picker" data-alpha-enabled="true" data-default-color="#ffffff" />
	<?php

	wp_enqueue_style( 'wp-color-picker' );
	wp_register_script( 'wp-color-picker-alpha', '/wp-content/plugins/klasse-plugin/includes/add-ons/wp-color-picker-alpha/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), $GLOBALS['kls_theme_version'] );
	wp_add_inline_script(
		'wp-color-picker-alpha',
		'jQuery( function() { jQuery( ".color-picker" ).wpColorPicker(); } );'
	);
	wp_enqueue_script( 'wp-color-picker-alpha' );
}

/**
 * Create color picker without transparancy callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_colorpicker_no_transparancy_field( $args ) {
	 $field_name = $args['label_for'];
	$options     = get_option( $field_name );

	?>
		<input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $options; ?>" class="color-picker" data-default-color="#ffffff" />
	<?php

	wp_enqueue_style( 'wp-color-picker' );
	wp_register_script( 'wp-color-picker-alpha', '/wp-content/plugins/klasse-plugin/includes/add-ons/wp-color-picker-alpha/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), $GLOBALS['kls_theme_version'] );
	wp_add_inline_script(
		'wp-color-picker-alpha',
		'jQuery( function() { jQuery( ".color-picker" ).wpColorPicker(); } );'
	);
	wp_enqueue_script( 'wp-color-picker-alpha' );
}

/**
 * Create select field callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_select_page_field( $args ) {
	 $field_name = $args['label_for'];
	$options     = get_option( $field_name );
	?>

		<select id='<?php echo $field_name; ?>' name='<?php echo $field_name; ?>' class="kls_input kls_select">
			<option value=''>None</option>
		<?php
		$pages = get_pages();
		if ( $pages = get_pages() ) {
			foreach ( $pages as $page ) {
				$pageID   = $page->ID;
				$selected = ( $options == $pageID ) ? 'selected="selected"' : '';
				?>
				<option value='<?php echo $pageID; ?>' <?php echo $selected; ?>><?php echo $page->post_title; ?></option>
				<?php
			}
		};
		?>

		</select>
		<?php
}

/**
 * Create image field callback
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_image_field( $args ) {
	$field_name  = $args['label_for'];
	$button_text = $args['button_text'];
	$options     = get_option( $field_name );

	$image = wp_get_attachment_image_src( $options, 'thumbnail' );

	wp_enqueue_media();

	?>
		<div class='image-preview-wrapper'>
			<img id='image-preview<?php echo $field_name; ?>' src='<?php echo $image[0]; ?>' width='100' height='100' style='max-height: 100px; width: 100px;'>
		</div>
		<input id="upload_image_button<?php echo $field_name; ?>" type="button" class="button" value="<?php echo $button_text; ?>" />
		<input type='hidden' name='<?php echo $field_name; ?>' id='<?php echo $field_name; ?>' value='<?php echo $options; ?>'>
	<?php

	// Image media gallery script
	$my_saved_attachment_post_id = get_option( 'media_selector_attachment_id', 0 );

	?>
	<script type='text/javascript'>

		jQuery( document ).ready( function( $ ) {

			// Uploading files
			var file_frame;
			var wp_media_post_id = wp.media.model.settings.post.id; // Store the old id
			var set_to_post_id = <?php echo $my_saved_attachment_post_id; ?>; // Set this

			jQuery('#upload_image_button<?php echo $field_name; ?>').on('click', function( event ){

				event.preventDefault();

				// If the media frame already exists, reopen it.
				if ( file_frame ) {
					// Set the post ID to what we want
					file_frame.uploader.uploader.param( 'post_id', set_to_post_id );
					// Open frame
					file_frame.open();
					return;
				} else {
					// Set the wp.media post id so the uploader grabs the ID we want when initialised
					wp.media.model.settings.post.id = set_to_post_id;
				}

				// Create the media frame.
				file_frame = wp.media.frames.file_frame = wp.media({
					title: 'Select a image to upload',
					button: {
						text: 'Use this image',
					},
					multiple: false // Set to true to allow multiple files to be selected
				});

				// When an image is selected, run a callback.
				file_frame.on( 'select', function() {
					// We set multiple to false so only get one image from the uploader
					attachment = file_frame.state().get('selection').first().toJSON();

					// Do something with attachment.id and/or attachment.url here
					$( '#image-preview<?php echo $field_name; ?>' ).attr( 'src', attachment.url ).css( 'width', 'auto' );
					$( '#<?php echo $field_name; ?>' ).val( attachment.id );

					// Restore the main post ID
					wp.media.model.settings.post.id = wp_media_post_id;
				});

					// Finally, open the modal
					file_frame.open();
			});

			// Restore the main ID when the add media button is pressed
			jQuery( 'a.add_media' ).on( 'click', function() {
				wp.media.model.settings.post.id = wp_media_post_id;
			});
		});

	</script>
	<?php
}

/**
 * Create WYSIWYG editor callback
 *
 * @since 0.0.73
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_wysiwyg_field( $args ) {
	 $options = get_option( $args['label_for'], array() );
	$content  = isset( $options ) ? $options : false;
	wp_editor(
		$content,
		$args['label_for'],
		array(
			'textarea_name' => $args['label_for'],
			'media_buttons' => false,
		)
	);
}

/**
 * Create radio callback
 *
 * @since 0.0.95
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_theme_radio_field( $args ) {
	$field_name    = $args['label_for'];
	$options       = get_option( $field_name );
	$radio_options = $args['radios'];
	foreach ( $radio_options as $radio ) {
		$checked = ( $radio == $options ) ? 'checked' : '';
		?>
		<input type="radio" name="<?php echo $field_name; ?>" id="<?php echo $radio; ?>" value="<?php echo $radio; ?>" <?php echo $checked; ?>><label for="<?php echo $radio; ?>"><?php echo $radio; ?></label><br>
		<?php
	}
}
