<?php

/**
 * Remove options if uninstall is run & uninstall option is checked
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.04
 *
 * [Dev] Todo, the options arent accurate anymore. Needs to be fixed.
 * [Dev] Todo, on uninstall also remove consentlog database.
 * [Dev] Todo, on uninstall also remove plugin log file.
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Uninstall only if deinstallation toggle is on in the admin dashboard.
if ( get_option( 'kls_deinstallation_toggle' ) == 'on' ) {
	$options = array(
		// Customer.
		'kls_customer_logo',
		'kls_customer_favicon',

		'kls_customer_name',
		'kls_customer_email',
		'kls_customer_phone',
		'kls_customer_street',
		'kls_customer_postcode',
		'kls_customer_city',
		'kls_customer_country',

		'kls_opening_hours_monday',
		'kls_opening_hours_tuesday',
		'kls_opening_hours_wednesday',
		'kls_opening_hours_thursday',
		'kls_opening_hours_friday',
		'kls_opening_hours_saterday',
		'kls_opening_hours_sunday',

		'kls_customer_facebook',
		'kls_customer_twitter',
		'kls_customer_instagram',
		'kls_customer_linkedin',
		'kls_customer_youtube',
		'kls_customer_whatsapp',
		'kls_customer_tiktok',

		// Scripts & tracking.
		'kls_scripts_gtm',
		'kls_scripts_ua',
		'kls_scripts_fbpixel',

		'kls_scripts_header',
		'kls_scripts_body',
		'kls_scripts_footer',

		// Maintenance.
		'kls_maintenance_toggle',

		'kls_maintenance_title',
		'kls_maintenance_text',
		'kls_maintenance_background_select',

		'kls_maintenance_background_image',
		'kls_maintenance_background_color',
		'kls_maintenance_background_gradient',

		// Cookie.
		'kls_cookie_toggle',

		'kls_cookie_title',
		'kls_cookie_text',

		'kls_cookie_button_text',
		'kls_cookie_button_color',
		'kls_cookie_button_background_color',

		'kls_cookie_link_text',
		'kls_cookie_link',

		// Speed settings.
		'kls_speed_toggle',
		'kls_dequeue_styles',
		'kls_dequeue_scripts',
		'kls_front_page_css',

		// Settings.
		'kls_updates_toggle',
		'kls_webshop_toggle',
		'kls_wordpress_standard_toggle',
		'kls_debug_toggle',
		'kls_dashboard_clean_up_toggle',
		'kls_toggle_font_awesome',

		// Admin.
		'kls_admin_select',

		'kls_admin_logo',
		'kls_admin_favicon',

		'kls_admin_name',
		'kls_admin_email',
		'kls_admin_phone',
		'kls_admin_website',
		'kls_admin_city',
		'kls_admin_country',

		'kls_beta_updates_toggle',
		'kls_deinstallation_toggle',
	);

	foreach ( $options as $option ) {
		if ( get_option( $option ) ) {
			delete_option( $option );
		}
	}
}
