<?php
use PHPUnit\Framework\MockObject\MockObject;

class KP_Api_Test extends \Codeception\TestCase\WPTestCase
{
	/**
	 * @var \UnitTester
	 */
	protected $tester;

	// Testing the getCurrentDate method.
	public function testGetCurrentDate()
	{
		$kp_api = new KP_Api();
		$date = new DateTime('now', new DateTimeZone('Europe/Amsterdam'));
		$expectedDate = $date->format('d-m-y H:i:s');

		$this->assertEquals($expectedDate, $kp_api->getCurrentDate());
	}

	// Testing the generateApiSecret method.
	public function testGenerateApiSecret()
	{
		$kp_api = new KP_Api();
		$generated_key = $kp_api->generateApiSecret();

		$this->assertEquals(64, strlen($generated_key));
	}
}