<?php
namespace KP\PublicManager;

/**
 * Include all public includes
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.01
 */
if (!class_exists('PublicManager')) {
	class PublicManager
	{
		public function __construct()
		{
			$this->loadDependencies();

			// Todo, move this to somewhere relevant.
			add_action('wp_head', array($this, 'kls_add_meta_color'));
		}

		private function loadDependencies()
		{
			// Maintenance is toggled.
			if (get_option('kls_maintenance_toggle') == 'on' && !isset($_COOKIE['skip_maintenance_cookie'])) {
				include_once __DIR__ . '/includes/maintenance/maintenance.class.php';
			}

			// Cookie notice is toggled.
			if (get_option('kls_cookie_toggle') == 'on') {
				include_once __DIR__ . '/includes/cookie/cookie.class.php';
				include_once __DIR__ . '/includes/cookie/cookie-consentlog.class.php';
			}
			// Debug is toggled.
			if (get_option('kls_debug_toggle') == 'on') {
				include_once __DIR__ . '/includes/debug/debug.class.php';
			}

			// Speed is toggled.
			if (get_option('kls_speed_toggle') == 'on') {
				include_once __DIR__ . '/includes/speed/speed.php';
				include_once __DIR__ . '/includes/speed/wp-rocket.php';
			}

			// Security is toggled.
			if (get_option('kls_security_toggle') == 'on') {
				include_once __DIR__ . '/includes/security/security.php';
			}

			// Woocommerce is toggled.
			if (get_option('kls_webshop_toggle') == 'on') {
				include_once __DIR__ . '/includes/woocommerce/woocommerce.php';
			}
			
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
			if (is_plugin_active('wordpress-seo/wp-seo.php')) {
				include_once __DIR__ . '/includes/yoast/yoast-variables.class.php';
			}

			if (get_option('kls_user_tracking_toggle') == 'on') {
				require_once __DIR__ . '/includes/tracking/tracking.class.php';
			}

			require_once __DIR__ . '/includes/shortcodes/shortcodes.php';
			require_once __DIR__ . '/includes/scripts/scripts.class.php';
			require_once __DIR__ . '/includes/wordpress/custom_meta_boxes.php';
			require_once __DIR__ . '/includes/wordpress/linkintegration.class.php';
			require_once __DIR__ . '/includes/wordpress/i18n.php';

			require_once __DIR__ . '/includes/api/api.php';
			require_once __DIR__ . '/includes/api/api.class.php';

			require_once __DIR__ . '/includes/ninjaforms/ninjaforms.php';
			require_once __DIR__ . '/includes/gravity-forms/gravity-forms.class.php';
			new GravityForms\GravityFormsController();
		}

		public function kls_add_meta_color()
		{
			if (get_option('kls_customer_main_color')) {
				echo '<meta name="theme-color" content="' . get_option('kls_customer_main_color') . '"/>';
			}
		}
	}

	new PublicManager;
}