<?php // phpcs:ignore
/**
 * Tracking class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/tracking
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.92
 * 
 * Todo, this has to be fine tuned and finisht.
 * Todo, this needs it's own database instead of using options.
 * Todo, this has to be implementend with the new cookie notice.
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Tracking')) {
	/**
	 * tracking class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/tracking
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.92
	 */
	class KP_Tracking
	{
		private $optionName = 'kls_user_interactions';

		/**
		 * Construct the tracking.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function __construct()
		{
			require_once __DIR__ . '/parameter.class.php';

			// add_action('wp_enqueue_scripts', array($this, 'enqueueScripts'));

			// add_action('wp_ajax_save_user_interaction_data', array($this, 'handle_ajax_request'));
			// add_action('wp_ajax_nopriv_save_user_interaction_data', array($this, 'handle_ajax_request'));
		}

		/**
		 * Enqueue the scripts.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function enqueueScripts()
		{
			wp_enqueue_script('kls-user-experience', KP_ASSETS_PATH . 'build/public/user-experience.js', array('jquery'), KP_VERSION, true);
			wp_localize_script(
				'kls-user-experience',
				'my_ajax_object',
				array(
					'ajax_url' => admin_url('admin-ajax.php'),
					'nonce' => wp_create_nonce('my_ajax_nonce'),
				)
			);
		}

		function handle_ajax_request()
		{
			// Verify nonce
			if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'my_ajax_nonce')) {
				wp_send_json_error('Security check failed');
				wp_die();
			}

			// You might want to do nonce verification here
			if (!isset($_POST['interaction_data'])) {
				wp_send_json_error('No data received');
				wp_die();
			}

			$result = $this->saveData($_POST['interaction_data']);

			if (is_wp_error($result)) {
				wp_send_json_error($result->get_error_message());
			} else {
				wp_send_json_success('Data saved successfully');
			}

			wp_die();
		}

		public function saveData($data)
		{
			if (empty($data)) {
				return new WP_Error('empty_data', 'No data provided to save', array('status' => 400));
			}

			$decodedData = json_decode(wp_unslash($data), true);
			if (json_last_error() !== JSON_ERROR_NONE) {
				return new WP_Error('invalid_data_format', 'Invalid JSON format', array('status' => 400));
			}

			$userIP = $_SERVER['REMOTE_ADDR'];
			$hashedIP = hash('sha256', $userIP);

			// Retrieve existing data
			$existingData = get_option($this->optionName, []);

			// If this user's data doesn't exist, create a new entry
			if (!isset($existingData[$hashedIP])) {
				$existingData[$hashedIP] = [];
			}

			// Append new data to this user's data array
			array_push($existingData[$hashedIP], $decodedData);

			// Update the option with the new data
			update_option($this->optionName, $existingData);

			return new WP_REST_Response('Data saved successfully', 200);
		}

	}

	new KP_Tracking();
}
