<?php

/**
 * Dequeue styles and scripts added through the backend option
 *
 * @since 0.0.02
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
// Dequeue front page styles and scripts
function kls_dequeue_front_page() {
	 // Check if it's the homepage
	if ( is_page_template( 'page-optimized.php' ) || is_front_page() ) {
		// Dequeue styles
		$styles        = get_option( 'kls_dequeue_styles' );
		$stylesnospace = str_replace( ' ', '', $styles );
		$stylesexplode = explode( ',', $stylesnospace );

		foreach ( $stylesexplode as $style ) {
			wp_dequeue_style( $style );
		}

		// Dequeue scripts
		$scripts        = get_option( 'kls_dequeue_scripts' );
		$scriptsnospace = str_replace( ' ', '', $scripts );
		$scriptsexplode = explode( ',', $scriptsnospace );

		foreach ( $scriptsexplode as $script ) {
			wp_dequeue_script( $script );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'kls_dequeue_front_page', 999999 );

/**
 * Load critical path css for the homepage.
 *
 * @since 0.0.05
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_front_page_css' ) ) {
	function kls_load_critical_path_homepage() {
		if ( is_front_page() ) {
			echo get_option( 'kls_front_page_css' );
		}
	}
	add_action( 'wp_head', 'kls_load_critical_path_homepage' );
}
