<?php

/**
 * Anytime Fitness shortcode
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.49
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Register anytime scripts.
 *
 * @since 0.1.01
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kpEnqueueAnytimeStyle()
{
	wp_register_style('kls_anytime_carousel_style', KP_ASSETS_PATH . 'build/public/anytime-carousel.css', array(), KP_VERSION, 'all');

	wp_register_style('kls_anytime_marquee_style', KP_ASSETS_PATH . 'build/public/anytime-marquee.css', array(), KP_VERSION, 'all');
}
add_action('wp_head', 'kpEnqueueAnytimeStyle');

function kpEnqueueAnytimeScript()
{
	wp_register_script('kls_anytime_carousel_script', KP_ASSETS_PATH . 'build/public/anytime-carousel.js', false, KP_VERSION);

	wp_register_script('kls_anytime_marquee_script', KP_ASSETS_PATH . 'build/public/anytime-marquee.js', false, KP_VERSION);
}
add_action('wp_footer', 'kpEnqueueAnytimeScript');

// Group lesson URL.
function kls_anytime_grouplesson_url()
{
	return get_option('kls_anytime_grouplesson');
}
add_shortcode('af_groepsles_url', 'kls_anytime_grouplesson_url');

// Registration URL
function kls_anytime_registration_url()
{
	return get_option('kls_anytime_registration');
}
add_shortcode('af_inschrijf_url', 'kls_anytime_registration_url');

// Grouplessen button.
function kls_anytime_grouplesson_button($atts)
{
	$option = get_option('kls_anytime_grouplesson');
	$output = '';

	$style = isset($atts['style']) && !empty($atts['style']) ? $atts['style'] : 'primary';
	$margin = isset($atts['margin']) && !empty($atts['margin']) ? 'margin:' . $atts['margin'] . ';' : '';
	$text = isset($atts['text']) && !empty($atts['text']) ? $atts['text'] : __('View schedule', KP_TXT_DOMAIN);

	if (isset($option) && !empty($option)) {
		$output = '<a class="theme-button theme-button-' . $style . '" href="' . esc_url($option) . '" target="_blank" style="' . $margin . '">' . $text . '</a>';
	}

	return $output;
}
add_shortcode('af_groepslessen_knop', 'kls_anytime_grouplesson_button');

// 24 7 text.
function kls_anytime_24_7_text($atts)
{
	extract(
		shortcode_atts(
			array(
				'original' => 0,
				'other' => 0,
			),
			$atts
		)
	);

	if (get_option('kls_anytime_openings_data', 'always') == 'other') {
		$output = $other;
	} else {
		$output = $original;
	}

	return $output;
}
add_shortcode('af_24_7', 'kls_anytime_24_7_text');

// Terms and conditions shortcode.
function kls_anytime_terms($args)
{
	require_once 'anytime-terms/nl-nl.php';
	require_once 'anytime-terms/nl-en.php';
	require_once 'anytime-terms/nl-be.php';

	$nl_nl = kls_anytime_terms_nl_nl();
	$nl_en = kls_anytime_terms_nl_en();
	$nl_be = kls_anytime_terms_nl_be();

	$terms = '<div class="one_line_col">';

	if (get_option('kls_anytime_language') == 'Nederlands'):
		if (isset($args['lang']) && !empty($args['lang']) && 'en' == $args['lang']) {
			$terms .= $nl_en;
		} else {
			$terms .= $nl_nl;
		}
	elseif (get_option('kls_anytime_language') == 'Vlaams'):
		$terms .= $nl_be;
	endif;

	$terms .= '</div>';

	$terms .= '<style>.et-db #et-boc .et-l:not(.et-l--footer) .et_pb_module:not(.override_styling) ol>li{list-style: auto;} .et-db #et-boc .et-l:not(.et-l--footer) .et_pb_module:not(.override_styling) ul>li{list-style: disc;} .et-db #et-boc .et-l:not(.et-l--footer) .et_pb_module:not(.override_styling) li {font-family: "f37_moonregular", Helvetica, sans-serif !important;font-weight: normal !important;}</style>';

	return $terms;
}
add_shortcode('af_algemene_voorwaarden', 'kls_anytime_terms');

/**
 * Presale shortcodes
 *
 * @since 0.0.77
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_option('kls_toggle_anytime_presale_integration') == 'on'):
	// Registration costs.
	function kls_anytime_presale_opening_date()
	{
		return get_option('kls_anytime_presale_opening');
	}
	add_shortcode('af_locatie_opening', 'kls_anytime_presale_opening_date');

	// Registration costs.
	function kls_anytime_vip_weekend_date()
	{
		return get_option('kls_anytime_vip_weekend');
	}
	add_shortcode('af_vip_weekend', 'kls_anytime_vip_weekend_date');

	// Registration costs.
	function kls_anytime_presale_discount()
	{
		return get_option('kls_anytime_presale_discount');
	}
	add_shortcode('af_presale_korting', 'kls_anytime_presale_discount');

	// Registration costs.
	function kls_anytime_presale_date()
	{
		return get_option('kls_anytime_presale_date');
	}
	add_shortcode('af_presale_datum', 'kls_anytime_presale_date');
endif;

function wpse_setup_theme()
{
	add_theme_support('post-thumbnails');
	add_image_size('anytime-carousel-big', 500, 333, true);
}

add_action('after_setup_theme', 'wpse_setup_theme');

function klsAnytimeGrouplessonCarousel()
{
	$carousel_items = [];

	$grouplessons_option = get_option('kls_anytime_grouplessons');
	$grouplesson_array = isset($grouplessons_option) && !empty($grouplessons_option) ? $grouplessons_option : [
		array(
			'image' => 'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Anne-Jannes-3967s.jpg',
			'title' => 'Pilates',
		),
		array(
			'image' => 'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Kimroufs_anytime_capelle_maart22_FINALS-7.jpg',
			'title' => 'Small group',
		),
		array(
			'image' => 'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Anne-Jannes-6089.jpg',
			'title' => 'Bodypump',
		),
		array(
			'image' => 'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Anne-Jannes-5969.jpg',
			'title' => 'Boksen',
		),
		array(
			'image' => 'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Anne-Jannes-5845.jpg',
			'title' => 'Yoga',
		),
		array(
			'image' => 'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Anne-Jannes-6152.jpg',
			'title' => 'Spinning',
		),
	];

	foreach ($grouplesson_array as $grouplesson) {
		if (filter_var($grouplesson['image'], FILTER_VALIDATE_URL) === false) {
			$grouplesson['image'] = wp_get_attachment_image_src($grouplesson['image'], 'anytime-carousel-big')[0];
		}
		$carousel_items[] = '<div class="item"><img src="' . $grouplesson['image'] . '" /><div class="overlay"><span>' . $grouplesson['title'] . '</span></div></div>';
	}

	$html = '<div class="owl-carousel owl-theme anytime-grouplesson">';
	foreach ($carousel_items as $item) {
		$html .= $item;
	}
	$html .= '</div>';

	wp_enqueue_style('kls_anytime_carousel_style');
	wp_enqueue_script('kls_owl_carousel_script');
	wp_enqueue_script('kls_anytime_carousel_script');

	return $html;
}
add_shortcode('af_groepslessen_slider', 'klsAnytimeGrouplessonCarousel');

function klsAnytimeClubimpressionCarousel()
{
	$carousel_items = [];

	$club_video_url = get_option('kls_anytime_clubimpression_video');
	$video_url = isset($club_video_url) && !empty($club_video_url) ? $club_video_url : 'https://www.youtube.com/embed/niugLmVnR7c';

	$carousel_items[] = '<div class="item"><iframe width="500" height="333" data-src="' . $video_url . '" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe></div>';

	$club_images_option = get_option('kls_anytime_clubimpression_images');
	$club_images = isset($club_images_option) && !empty($club_images_option) ? explode(',', $club_images_option) : [
		'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Aandacht.jpg',
		'https://sync.afbenelux.nl/wp-content/uploads/2023/08/gewichten.jpg',
		'https://sync.afbenelux.nl/wp-content/uploads/2023/08/inschrijven.jpg',
		'https://sync.afbenelux.nl/wp-content/uploads/2023/08/cardio.jpg',
		'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Interieur-Nuth.jpg',
		'https://sync.afbenelux.nl/wp-content/uploads/2023/08/Kimroufs_anytime_capelle_maart22_FINALS-46-1.png',
	];

	foreach ($club_images as $image) {
		if (filter_var($image, FILTER_VALIDATE_URL) === false) {
			$image = wp_get_attachment_image_src($image, 'anytime-carousel-big')[0];
		}
		$carousel_items[] = '<div class="item"><img src="' . $image . '" /></div>';
	}

	$html = '<div class="owl-carousel owl-theme anytime-clubimpression">';
	foreach ($carousel_items as $item) {
		$html .= $item;
	}
	$html .= '</div>';

	wp_enqueue_style('kls_anytime_carousel_style');
	wp_enqueue_script('kls_owl_carousel_script');
	wp_enqueue_script('kls_anytime_carousel_script');

	return $html;
}
add_shortcode('af_clubimpressie_slider', 'klsAnytimeClubimpressionCarousel');

function klsAnytimeMarquee($atts)
{
	$language = isset($atts['lang']) && !empty($atts['lang']) ? $atts['lang'] : 'nl';

	ob_start();
	if (get_option('kls_toggle_anytime_presale_integration') == 'on') {
		?>
		<div class="marquee">
			<ul>
				<li>BINNENKORT OPENT ANYTIME FITNESS BIJ JOU OM DE HOEK</li>
				<li>Onze clubs zijn 365 dagen per jaar open en 24/7 toegankelijk</li>
				<li>In al onze clubs is de koffie gratis!</li>
				<li>BINNENKORT OPENT ANYTIME FITNESS BIJ JOU OM DE HOEK</li>
				<li>Met onze handige app heb je altijd 1700 workouts binnen handbereik</li>
				<li>In al onze clubs hebben we privé douches èn privé kleedkamers</li>
				<li>BINNENKORT OPENT ANYTIME FITNESS BIJ JOU OM DE HOEK</li>
				<li>Onze trainers zijn er voor je om je te begeleiden en motiveren</li>
				<li>Parkeren doe je dichtbij bijna altijd gratis voor de deur</li>
				<li>BINNENKORT OPENT ANYTIME FITNESS BIJ JOU OM DE HOEK</li>
				<li>De kluisjes in de club bewaken je waardevolle spullen</li>
				<li>We vinden het belangrijk dat de club schoon en hygiënisch is</li>
				<li>BINNENKORT OPENT ANYTIME FITNESS BIJ JOU OM DE HOEK</li>
				<li>We zorgen er graag voor dat je met plezier komt sporten</li>
				<li>Onze clubs liggen altijd centraal en bij jou om de hoek</li>
				<li>BINNENKORT OPENT ANYTIME FITNESS BIJ JOU OM DE HOEK</li>
				<li>Persoonlijke aandacht vinden we erg belangrijk, dat geven we je graag</li>
				<li>Regelmatig voegen we in overleg met onze leden nieuwe apparaten toe aan ons aanbod</li>
			</ul>
		</div>
		<?php
	} else {
		if ($language === 'en') {
			?>
			<div class="marquee">
				<ul>
					<li>SPORT 7 DAYS FREE AND NON-BINDING TO TRY ANYTIME FITNESS WITHOUT OBLIGATIONS</li>
					<li>Review Matthijs K.: “It’s great to have a club where I really don’t have to worry about the opening hours”</li>
					<li>Our clubs are open 365 days a year and accessible 24/7</li>
					<li>Coffee is free in all our clubs.</li>
					<li>Review Tom van Z.: “I have never had so much fun working out”</li>
					<li>All our clubs have private showers and private changing rooms</li>
					<li>Our useful app offers 1,700 workout that are just a tap away</li>
					<li>SPORT 7 DAYS FREE AND NON-BINDING TO TRY ANYTIME FITNESS WITHOUT OBLIGATIONS</li>
					<li>Review Lisa T.: “I never have to wait long for a machine, which is very nice.”</li>
					<li>Our trainers are there to guide and motivate you</li>
					<li>Parking is close by and almost always free</li>
					<li>Review Thomas V.: “When I started working out at Anytime Fitness, my friends switched at the same time”</li>
					<li>Store your belongings safely in our lockers</li>
					<li>We believe it is important to keep the club clean and hygienic</li>
					<li>SPORT 7 DAYS FREE AND NON-BINDING TO TRY ANYTIME FITNESS WITHOUT OBLIGATIONS</li>
					<li>Review Sharon S.: “It is very nice here, I always feel at ease”</li>
					<li>We are more than happy to ensure you enjoy working out</li>
					<li>Our clubs are always located centrally, around the corner from you</li>
					<li>Review Jeroen de H.: “The atmosphere here is so nice that I often linger for hours”</li>
					<li>Personal attention is very important to us and we are happy to provide it</li>
					<li>We regularly add new machines in consultation with our members</li>
					<li>SPORT 7 DAYS FREE AND NON-BINDING TO TRY ANYTIME FITNESS WITHOUT OBLIGATIONS</li>
					<li>Review Steffie S.: “The guidance I receive is very nice. If only I had started sooner!”</li>
					<li>The club where trainers and members know each other</li>
				</ul>
			</div>
			<?php
		} elseif ($language === 'de') {
			?>
			<div class="marquee">
				<ul>
					<li>SPORT 7 TAGE KOSTENLOS UND UNVERBINDLICH, UM ANYTIME FITNESS AUSZUPROBIEREN, OHNE VERPFLICHTUNGEN</li>
					<li>Bewertung Matthijs K.: "Toll, dass es einen Club gibt, bei dem ich wirklich nie auf die Öffnungszeiten achten muss".</li>
					<li>Unsere Clubs sind an 365 Tagen im Jahr geöffnet und rund um die Uhr nutzbar</li>
					<li>In allen unseren Clubs gibt es auch kostenlosen Kaffee!</li>
					<li>Bewertung Tom van Z.: “Ich habe noch nie zuvor solchen Spaß am Sport gehabt”</li>
					<li>In all unseren Clubs verfügen wir über private Duschen und private Umkleideräume.</li>
					<li>Mit unserer praktischen App stehen Ihnen jederzeit 1700 Workouts zur Verfügung</li>
					<li>SPORT 7 TAGE KOSTENLOS UND UNVERBINDLICH, UM ANYTIME FITNESS AUSZUPROBIEREN, OHNE VERPFLICHTUNGEN</li>
					<li>Bewertung Lisa T.: "Hier brauche ich nie lange auf eines der Geräte zu warten, das ist wirklich klasse!"</li>
					<li>Unsere Trainer stehen Ihnen zur Seite und motivieren Sie</li>
					<li>In der Nähe gibt es zahlreiche Parkmöglichkeiten, die fast immer kostenlos sind</li>
					<li>Bewertung Thomas V.: "Als ich bei Anytime Fitness anfing zu trainieren, wechselten auch meine Freunde dorthin."</li>
					<li>Bewahren Sie Ihre Habseligkeiten sicher in unseren Schließfächern auf</li>
					<li>Wir legen großen Wert auf Sauberkeit und Hygiene im Club</li>
					<li>SPORT 7 TAGE KOSTENLOS UND UNVERBINDLICH, UM ANYTIME FITNESS AUSZUPROBIEREN, OHNE VERPFLICHTUNGEN</li>
					<li>Bewertung Sharon S.: "Es ist sehr angenehm hier, ich fühle mich immer wohl"</li>
					<li>Unser Ziel ist es, Ihnen Freude am Sport zu vermitteln</li>
					<li>Unsere Clubs sind zentral gelegen und immer bei Ihnen um die Ecke</li>
					<li>Bewertung Jeroen de H.: "Es ist hier oft so angenehm, dass ich mich stundenlang aufhalte"</li>
					<li>Wir legen großen Wert auf persönliche Begleitung und freuen uns darauf, Ihnen diese zu bieten</li>
					<li>In Absprache mit unseren Mitgliedern erweitern wir regelmäßig unsere Auswahl an Geräten</li>
					<li>SPORT 7 TAGE KOSTENLOS UND UNVERBINDLICH, UM ANYTIME FITNESS AUSZUPROBIEREN, OHNE VERPFLICHTUNGEN</li>
					<li>Bewertung Steffie S.: "Die Begleitung, die ich erhalte, ist sehr gut! Wenn ich nur früher angefangen hätte"</li>
					<li>Der Club, in dem Trainer und Mitglieder einander kennen</li>
				</ul>
			</div>
			<?php
		} else {
			?>
			<div class="marquee">
				<ul>
					<li>SPORT 7 DAGEN GRATIS EN VRIJBLIJVEND OM ANYTIME FITNESS TE PROBEREN ZONDER VERPLICHTINGEN</li>
					<li>Review Matthijs K.: “Fijn dat er een club is waar ik ècht nooit hoef te kijken naar openingstijden”</li>
					<li>Onze clubs zijn 365 dagen per jaar open en 24/7 toegankelijk</li>
					<li>Review Tom van Z.: “Ik heb nog nooit met zoveel plezier gesport”</li>
					<li>In al onze clubs hebben we privé douches èn privé kleedkamers</li>
					<li>Met onze handige app heb je altijd 1700 workouts binnen handbereik</li>
					<li>SPORT 7 DAGEN GRATIS EN VRIJBLIJVEND OM ANYTIME FITNESS TE PROBEREN ZONDER VERPLICHTINGEN</li>
					<li>Review Lisa T.: “Ik hoef hier nooit lang te wachten op een apparaat, dat is heel fijn!”</li>
					<li>Onze trainers zijn er voor je om je te begeleiden en motiveren</li>
					<li>Parkeren doe je dichtbij en bijna altijd gratis</li>
					<li>Review Thomas V.: “Toen ik ging sporten bij Anytime Fitness stapten mijn vrienden ook over”</li>
					<li>Berg je spullen veilig op in onze kluisjes</li>
					<li>We vinden het belangrijk dat de club schoon en hygiënisch is</li>
					<li>SPORT 7 DAGEN GRATIS EN VRIJBLIJVEND OM ANYTIME FITNESS TE PROBEREN ZONDER VERPLICHTINGEN</li>
					<li>Review Sharon S.: “Het is heel fijn hier, ik voel me altijd op mijn gemak”</li>
					<li>We zorgen er graag voor dat je met plezier komt sporten</li>
					<li>Onze clubs liggen altijd centraal en bij jou om de hoek</li>
					<li>Review Jeroen de H.: “Het is hier vaak zo gezellig dat ik uren blijf hangen”</li>
					<li>Persoonlijke aandacht vinden we erg belangrijk, die geven we je graag</li>
					<li>Regelmatig voegen we in overleg met onze leden nieuwe apparaten toe aan ons aanbod</li>
					<li>SPORT 7 DAGEN GRATIS EN VRIJBLIJVEND OM ANYTIME FITNESS TE PROBEREN ZONDER VERPLICHTINGEN</li>
					<li>Review Steffie S.: “De begeleiding die ik krijg is heel fijn! Was ik maar eerder begonnen”</li>
					<li>De club waar trainers en leden elkaar kennen</li>
				</ul>
			</div>
			<?php
		}
	}

	$output = ob_get_contents();
	ob_end_clean();

	wp_enqueue_style('kls_anytime_marquee_style');
	wp_enqueue_script('kls_anytime_marquee_script');

	return $output;
}
add_shortcode('af_marquee', 'klsAnytimeMarquee');

function klsAnytimeAppointmentIframe($atts)
{
	shortcode_atts(
		array(
			'type' => '',
		),
		$atts
	);

	$url = get_option('kls_anytime_appointment_url');
	$type = isset($atts['type']) && !empty($atts['type']) ? '&type=' . $atts['type'] : '';

	$html = '<iframe rel="preload" src="' . $url . $type . '" class="anytime-afspraken-module" data-skip-lazy width="100%" height="615"></iframe>';

	return $html;
}
add_shortcode('af_afspraken_module', 'klsAnytimeAppointmentIframe');