<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Create the custom merge tags
 *
 * @since 0.0.45
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
class kls_merge_tags extends NF_Abstracts_MergeTags {

	protected $id = 'kls_merge_tags';

	public function __construct() {
		 parent::__construct();
		$this->title      = get_option( 'kls_admin_name' ) . ' ' . __( 'plugin addons', KP_TXT_DOMAIN );
		$this->merge_tags = array(
			// Customer company name
			'klscustomercompany'  => array(
				'id'       => 'kls_merge_customer_form_company',
				'tag'      => '{klant:bedrijfsnaam}',
				'label'    => __( 'Customer company', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_customer_form_company',
			),
			// Customer phone number
			'klscustomerphone'    => array(
				'id'       => 'kls_merge_customer_form_phone',
				'tag'      => '{klant:telefoonnummer}',
				'label'    => __( 'Customer phone', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_customer_form_phone',
			),
			// Customer address
			'klscustomeraddress'  => array(
				'id'       => 'kls_merge_customer_form_address',
				'tag'      => '{klant:adres}',
				'label'    => __( 'Customer address', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_customer_form_address',
			),
			// Customer mail
			'klscustomeremail'    => array(
				'id'       => 'kls_merge_customer_form_email',
				'tag'      => '{klant:emailadres}',
				'label'    => __( 'Customer email', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_customer_form_email',
			),
			// CC
			'klscustomerccemail'  => array(
				'id'       => 'kls_merge_customer_form_cc_email',
				'tag'      => '{klant:cc_emailadres}',
				'label'    => __( 'CC email', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_customer_form_cc_email',
			),
			// BCC
			'klscustomerbccemail' => array(
				'id'       => 'kls_merge_customer_form_bcc_email',
				'tag'      => '{klant:bcc_emailadres}',
				'label'    => __( 'BCC email', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_customer_form_bcc_email',
			),
			// Zapier email
			'klszapieremail'      => array(
				'id'       => 'kls_merge_zapier_email',
				'tag'      => '{zapier:emailadres}',
				'label'    => __( 'Zapier email', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_zapier_email',
			),
			// Zapier webhook
			'klszapierwebhook'    => array(
				'id'       => 'kls_merge_zapier_webhook',
				'tag'      => '{zapier:webhook}',
				'label'    => __( 'Zapier webhook', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_zapier_webhook',
			),
			// Admin name
			'klsadminname'        => array(
				'id'       => 'kls_merge_admin_name',
				'tag'      => '{admin:name}',
				'label'    => __( 'Admin name', KP_TXT_DOMAIN ),
				'callback' => 'kls_merge_admin_name',
			),
		);
	}

	// Return the customer form email
	protected function kls_merge_customer_form_company() {
		return get_option( 'kls_customer_name' );
	}

	// Return the customer form email
	protected function kls_merge_customer_form_phone() {
		return get_option( 'kls_customer_phone' );
	}

	// Return the customer form email
	protected function kls_merge_customer_form_address() {
		return get_option( 'kls_customer_street' ) . '<br>' . get_option( 'kls_customer_postcode' ) . ', ' . get_option( 'kls_customer_city' ) . '<br>' . get_option( 'kls_customer_country' );
	}

	// Return the customer form email
	protected function kls_merge_customer_form_email() {
		return get_option( 'kls_customer_form_email' );
	}

	// Return the customer cc email
	protected function kls_merge_customer_form_cc_email() {
		 return get_option( 'kls_customer_form_cc_email' );
	}

	// Return the customer bcc email
	protected function kls_merge_customer_form_bcc_email() {
		return get_option( 'kls_customer_form_bcc_email' );
	}

	// Return the zapier email
	protected function kls_merge_zapier_email() {
		return get_option( 'kls_customer_zapier_email' );
	}

	// Return the zapier email
	protected function kls_merge_zapier_webhook() {
		 return get_option( 'kls_customer_zapier_webhook' );
	}

	// Return the admin name
	protected function kls_merge_admin_name() {
		 return get_option( 'kls_admin_name' );
	}
}
