<?php // phpcs:ignore
/**
 * Mainenance class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/maintenance
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.92
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Maintenance' ) ) {
	/**
	 * Maintenance class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/maintenance
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.92
	 */
	class KP_Maintenance {

		/**
		 * Construct the maintenance.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function __construct() {
			 $url     = 'https://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
			$skip_url = 'onderhoud_overslaan';

			add_action( 'plugins_loaded', array( $this, 'checkForMaintenance' ) );

			remove_action( 'wp_head', 'kls_set_body_whitespace' );
		}

		/**
		 * Check if the maintenance page should be active.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function checkForMaintenance() {
			 $url     = 'https://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
			$skip_url = 'onderhoud_overslaan';

			if ( get_option( 'kls_maintenance_toggle' ) == 'on' && strpos( $url, $skip_url ) !== false ) {
				setcookie( 'skip_maintenance_cookie', 'yes', time() + ( 86400 * 1 ), '/' );
			} elseif ( get_option( 'kls_maintenance_toggle' ) == 'on' ) {
				add_action( 'wp_loaded', array( $this, 'getMaintenance' ) );
			}
		}

		/**
		 * Get the mainetenance page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function getMaintenance() {
			global $pagenow;

			if ( 'wp-login.php' !== $pagenow && ! isset( $_COOKIE['skip_maintenance_cookie'] ) && ! is_user_logged_in() && ! is_admin() ) {
				header( $_SERVER['SERVER_PROTOCOL'] . ' 503 Service Temporarily Unavailable', true, 503 );
				header( 'Retry-After: ' . ( 24 * 60 * 60 ) );
				header( 'Content-Type: text/html; charset=utf-8' );
				if ( file_exists( plugin_dir_path( __FILE__ ) . 'maintenance.view.php' ) ) {
					remove_action( 'wp_head', 'kls_set_body_whitespace' );
					remove_action( 'wp_footer', 'kls_footer' );

					include_once plugin_dir_path( __FILE__ ) . 'maintenance.view.php';
				}

				die();
			}
		}

	}

	new KP_Maintenance();
}
