<?php

namespace KP\PublicManager\GravityForms;

if (!defined('ABSPATH')) {
	exit;
}

/**
 * Create the session
 *
 * @since 0.1.12
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (!class_exists('SessionManager')) {
	class SessionManager
	{
		public function __construct()
		{
			add_action('wp_enqueue_scripts', array($this, 'registerScripts'));

			add_action('gform_after_submission', array($this, 'store_form_data_in_session'), 10, 2); 

			add_action('wp_ajax_kp_gf_get_session_value', array($this, 'getSessionValue'));
			add_action('wp_ajax_nopriv_kp_gf_get_session_value', array($this, 'getSessionValue'));

			add_shortcode('gf_session_value', array($this, 'display_form_data_shortcode'));
		}

		public function registerScripts()
		{
			wp_register_script('gf-session-js', KP_ASSETS_PATH . 'build/public/gf-session.js', array('jquery'), KP_VERSION, true);
			wp_localize_script('gf-session-js', 'kp_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
		}

		public function store_form_data_in_session($entry, $form)
		{
			if (!session_id()) {
				session_start();
			}

			$safe_data = [];

			foreach ($form['fields'] as $field) {
				// Sanitize each field value
				$field_id = $field->id;
				$field_name = $field->adminLabel;
				$field_value = sanitize_text_field($entry[$field_id] ?? '');

				if (isset($field_value) && !empty($field_value)) {
					$safe_data[$field_name] = $field_value;
				}
			}

			$_SESSION['form_data'] = $safe_data;
		}

		// public function display_form_data_shortcode()
		// {
		// 	if (!session_id()) {
		// 		session_start();
		// 	}

		// 	if (isset($_SESSION['form_data'])) {
		// 		// Output the session data
		// 		// Customize this part as per your needs
		// 		$output = '';
		// 		foreach ($_SESSION['form_data'] as $key => $value) {
		// 			$output .= $key . ' : ' . $value . '<br>';
		// 		}
		// 		return $output;
		// 	} else {
		// 		return 'No form data found.';
		// 	}
		// }

		public function display_form_data_shortcode($atts = array())
		{
			$field_key = isset($atts['field_key']) ? $atts['field_key'] : '';
			$value_before = isset($atts['value_before']) ? $atts['value_before'] : '';
			$value_after = isset($atts['value_after']) ? $atts['value_after'] : '';
			$nonce = wp_create_nonce('kp_gf_get_session_value');

			wp_enqueue_script('gf-session-js');

			return '<span class="kp-gf-session-value" data-field-key="' . esc_attr($field_key) . '" data-value-before="' . esc_html($value_before) . '" data-value-after="' . esc_html($value_after) . '" data-nonce="' . $nonce . '"></span>';
		}

		public function getSessionValue()
		{
			if (isset($_POST['nonce']) && !wp_verify_nonce($_POST['nonce'], 'gf_get_session_value')) {
				wp_die();
			}

			if (!session_id()) {
				session_start();
			}

			if (isset($_SESSION['form_data'])) {
				$field_key = isset($_POST['field_key']) ? wp_unslash($_POST['field_key']) : '';
				$output = '';

				if ($field_key && !empty($_SESSION['form_data'][$field_key])) {
					$value_before = isset($_POST['value_before']) ? wp_unslash($_POST['value_before']) : '';
					$value_after = isset($_POST['value_after']) ? wp_unslash($_POST['value_after']) : '';

					$output .= esc_html($value_before);
					$output .= $_SESSION['form_data'][$field_key];
					$output .= esc_html($value_after);
				}
			}

			echo $output;
			wp_die();
		}

	}
}