<?php

namespace KP\PublicManager\GravityForms;

if (!defined('ABSPATH')) {
	exit;
}

/**
 * Create the custom merge tags
 *
 * @since 0.1.12
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (!class_exists('MergeTagManager')) {
	class MergeTagManager
	{
		private $options;

		public function __construct($options)
		{
			$this->options = $options;

			add_filter('gform_custom_merge_tags', array($this, 'addCustomMergeTags'), 10, 4);
			add_filter('gform_replace_merge_tags', array($this, 'replaceCustomMergeTags'), 10, 7);
		}

		public function addCustomMergeTags($merge_tags, $form_id, $fields, $element_id)
		{
			foreach ($this->options as $option) {
				$merge_tags[] = array(
					'label' => $option['label'],
					'tag' => $option['tag']
				);
			}

			return $merge_tags;
		}

		public function replaceCustomMergeTags($text, $form, $entry, $url_encode, $esc_html, $nl2br, $format)
		{
			foreach ($this->options as $option) {
				$tag = str_replace(['{', '}'], '', $option['tag']);

				// Prepare a regex pattern to find tags that may include a default value
				$pattern = '/' . preg_quote($tag, '/') . '(?:\:([^\}]+))?/';

				// Use preg_match_all to find all occurrences of the tag, with or without default values
				if (preg_match_all($pattern, $text, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						// Determine the actual value to replace
						$actualValue = isset($option['custom_output']) ? $option['custom_output'] : get_option($option['name']);

						// If actual value is empty and a default value is specified in the tag, use the default
						if (empty($actualValue) && isset($match[1])) {
							$actualValue = $match[1]; // Use the specified default value from the tag
						}

						// Replace the found tag (including any default value specification) with the determined value
						$text = str_replace('{' . $match[0] . '}', $actualValue, $text);
					}
				}
			}

			return $text;
		}
	}
}