<?php // phpcs:ignore
/**
 * Debug class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/debug
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.92
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Debug' ) ) {
	/**
	 * Debug class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/debug
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.92
	 */
	class KP_Debug {

		/**
		 * Construct the debugger.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function __construct() {
			 add_action( 'wp_print_scripts', array( $this, 'kls_inspect_script_style' ) );
		}

		/**
		 * Show all the loaded styles & scripts in the body
		 *
		 * @since 0.0.05
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 */
		public function kls_inspect_script_style() {
			global $wp_scripts, $wp_styles;

			echo "\n" . '<!--' . "\n\n";
			echo "\n" . 'STYLE IDs:' . "\n";

			foreach ( $wp_styles->queue as $handle ) {
				echo esc_html( $handle ) . "\n";
			}

			echo "\n" . 'SCRIPT IDs:' . "\n";

			foreach ( $wp_scripts->queue as $handle ) {
				echo esc_html( $handle ) . "\n";
			}

			echo "\n" . '-->' . "\n\n";
		}
	}

	new KP_Debug();
}
