<?php // phpcs:ignore
/**
 * Cookie consent log class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/cookie-consentlog
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.92
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Cookie_Consentlog' ) ) {
	/**
	 * Cookie consentlog class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/cookie-consentlog
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.92
	 *
	 * [Dev] Todo, remove the items that are over 2 years old.
	 */
	class KP_Cookie_Consentlog {

		/**
		 * Construct the cookie.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function __construct() {
			 register_activation_hook( KP_PLUGIN_FILE_URL, array( $this, 'create_db' ) );

			add_action( 'wp_ajax_logConsent', array( $this, 'logConsent' ) );
			add_action( 'wp_ajax_nopriv_logConsent', array( $this, 'logConsent' ) );
		}

		/**
		 * Create the database
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function create_db() {

			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$table_name      = $wpdb->prefix . 'kls_consentlog';

			$sql = "CREATE TABLE $table_name (
				id int(11) NOT NULL AUTO_INCREMENT,
				time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
				ip_address text NOT NULL,
				consent_status varchar(45) NOT NULL,
				accepted_categories text null,
				rejected_categories text NULL,
				UNIQUE KEY id (id)
			) $charset_collate;";

			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta( $sql );
		}

		/**
		 * Log the consent to the log file.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.92
		 */
		public function logConsent() {
			check_ajax_referer( 'kls_ajax_validation', 'security' );

			global $wpdb;

			$table_name = $wpdb->prefix . 'kls_consentlog';

			if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
				$ip = filter_var( wp_unslash( $_SERVER['HTTP_CLIENT_IP'] ), FILTER_VALIDATE_IP );
			} elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
				$ip = filter_var( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ), FILTER_VALIDATE_IP );
			} else {
				$ip = isset( $_SERVER['REMOTE_ADDR'] ) ? filter_var( wp_unslash( $_SERVER['REMOTE_ADDR'] ), FILTER_VALIDATE_IP ) : 'undefined';
			}

			$consent_status      = isset( $_POST['status'] ) ? sanitize_text_field( wp_unslash( $_POST['status'] ) ) : '';
			$accepted_categories = isset( $_POST['accepted_categories'] ) ? json_encode( wp_unslash( $_POST['accepted_categories'] ) ) : '';
			$rejected_categories = isset( $_POST['rejected_categories'] ) ? json_encode( wp_unslash( $_POST['rejected_categories'] ) ) : '';

			$wpdb->insert(
				$table_name,
				array(
					'time'                => current_time( 'mysql' ),
					'consent_status'      => esc_html( $consent_status ),
					'ip_address'          => esc_html( $ip ),
					'accepted_categories' => $accepted_categories,
					'rejected_categories' => $rejected_categories,
				)
			);
		}
	}

	new KP_Cookie_Consentlog();
}
