<?php
// Todo, rename this file and add comments.
class KP_Send
{
	public function __construct()
	{
		add_action('wp', array($this, 'setup_cron'));
		add_action('send_url_to_portal', array($this, 'send_url'));
	}

	public function setup_cron()
	{
		if (!wp_next_scheduled('send_url_to_portal')) {
			wp_schedule_event(strtotime('midnight tomorrow'), 'daily', 'send_url_to_portal');
		}
	}

	public function send_url()
	{
		$site_url = get_site_url();
		$endpoint = 'https://portal.klassebv.nl/api/save-url';

		wp_safe_remote_post(
			$endpoint,
			array(
				'body' => json_encode(array('url' => $site_url, 'admin' => get_option('kls_admin_name', 'not defined'))),
				'headers' => array('Content-Type' => 'application/json'),
			)
		);
	}
}

new KP_Send();
