<?php // phpcs:ignore
/**
 * Api class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/api/post
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.94
 *
 * Todo, implement logger.
 * Todo, add maintenance page to exclude /wp-json/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Get' ) ) {
	/**
	 * Api class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/api/post
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.94
	 */
	class KP_Get {

		/**
		 * Construct the api.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.94
		 */
		public function __construct() {
			 add_action( 'rest_api_init', array( $this, 'registerRoutes' ) );
		}

		/**
		 * Register the routes for the options API
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function registerRoutes() {
			$api_v2 = 'klasse-api/v2';

			register_rest_route(
				$api_v2,
				'/get-options',
				array(
					'methods'             => 'GET',
					'callback'            => array( $this, 'getOptions' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);

			register_rest_route(
				$api_v2,
				'/get-option/(?P<option>[a-zA-Z0-9-_]+)',
				array(
					'methods'             => 'GET',
					'callback'            => array( $this, 'getOption' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);

			register_rest_route(
				$api_v2,
				'/get-theme-mods',
				array(
					'methods'             => 'GET',
					'callback'            => array( $this, 'getThemeMods' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);

			register_rest_route(
				$api_v2,
				'/get-theme-mod/(?P<thememod>[a-zA-Z0-9-_]+)',
				array(
					'methods'             => 'GET',
					'callback'            => array( $this, 'getThemeMod' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);
		}

		public function callAuth($request) {
			$api_controller = new KP_Api();

			return $api_controller->authenticate($request);
		}

		public function getOptions() {
			$all_options = wp_load_alloptions();

			foreach ( $all_options as $key => $value ) :
				if ( ! str_contains( $key, 'kls_api_key' ) && str_contains( $key, 'kls_' ) || str_contains( $key, 'blogname' ) ) :
					$options[ $key ] = $value;
				endif;
			endforeach;

			return new WP_REST_Response(
				array(
					'success' => true,
					'message' => $options,
				)
			);
		}

		public function getOption( $data ) {
			$option_name = $data['option'];
			if ( isset( $option_name ) && get_option( $option_name ) ) :
				if ( ! str_contains( $option_name, 'kls_api_key' ) && str_contains( $option_name, 'kls_' ) || str_contains( $option_name, 'blogname' ) ) :
					$option[ $option_name ] = get_option( $option_name );
					return new WP_REST_Response(
						array(
							'success' => true,
							'message' => $option,
						)
					);
				else :
					return new WP_REST_Response(
						array(
							'success' => false,
							'message' => 'Could not get option. Option name is not allowed to get.',
						),
						400,
					);
				endif;
			else :
				return new WP_REST_Response(
					array(
						'success' => false,
						'message' => 'Could not get option. Option name is not set or does not exist.',
					),
					400,
				);
			endif;
		}

		public function getThemeMods() {
			$all_theme_mods = get_theme_mods();

			foreach ( $all_theme_mods as $key => $value ) :
				$theme_mods[ $key ] = $value;
			endforeach;

			return new WP_REST_Response(
				array(
					'success' => true,
					'message' => $theme_mods,
				)
			);
		}

		public function getThemeMod( $data ) {
			$theme_mod[ $data['thememod'] ] = get_theme_mod( $data['thememod'] );

			return new WP_REST_Response(
				array(
					'success' => true,
					'message' => $theme_mod,
				)
			);
		}
	}

	new KP_Get();
}
