<?php // phpcs:ignore
/**
 * Upgrades class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/includes/upgrades
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.93
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Upgrades' ) ) {
	/**
	 * Upgrades class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/includes/ipgrades
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.93
	 */
	class KP_Upgrades {

		/**
		 * Construct the upgrades.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function __construct() {
			if ( get_option( 'kls_plugin_version' ) < '0.0.93' ) {
				$this->upgrades0093();
			}
		}

		/**
		 * Do the plugin upgrades for version 0.0.93.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 *
		 * [Dev] Todo, add logger implementation.
		 */
		private function upgrades0093() {
			// Create the cookie consent log DB.
			require_once KP_DIR_PATH . 'public/includes/cookie/cookie-consentlog.class.php';

			$cookie_consent_log = new KP_Cookie_Consentlog();
			$cookie_consent_log->create_db();

			// Update the plugin version.
			$this->updatePluginVersion( '0.0.93' );
		}

		/**
		 * Update the plugin version.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @param string $version_to_update_to String for the version to upgrade to.
		 *
		 * @since 0.0.93
		 *
		 * [Dev] Todo, add logger implementation.
		 */
		public function updatePluginVersion( $version_to_update_to ) {
			update_option( 'kls_plugin_version', $version_to_update_to );
		}
	}

	new KP_Upgrades();
}
