<?php // phpcs:ignore
/**
 * Speed page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Speed_Page')) {
	/**
	 * Speed page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Speed_Page
	{
		/**
		 * Construct the speed page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Speed settings', KP_TXT_DOMAIN), __('Speed settings', KP_TXT_DOMAIN), 'manage_speed_data_kls', 'kls_speed_page', array($this, 'speedPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Speed settings', KP_TXT_DOMAIN),
				'description' => __('Speedup the website', KP_TXT_DOMAIN),
				'url' => 'kls_speed_page',
				'capability' => 'manage_speed_data_kls',
				'order' => '90',
			);

			return $pages;
		}

		/**
		 * Speed page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function speedPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_speed_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Speed settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('Settings for improving the speed of the website. It is a bit more advanced so for questions let me know.', KP_TXT_DOMAIN); ?>.
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_speed_settings_section');

									do_settings_sections('kls_speed_settings');

									// Output save settings button.
									submit_button(__('Save', KP_TXT_DOMAIN));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Speed_Page();
}
