<?php // phpcs:ignore
/**
 * Settings page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Settings_Page')) {
	/**
	 * Settings page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Settings_Page
	{
		/**
		 * Construct the settings page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Settings', KP_TXT_DOMAIN), __('Settings', KP_TXT_DOMAIN), 'manage_settings_data_kls', 'kls_settings_page', array($this, 'settingsPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Settings', KP_TXT_DOMAIN),
				'description' => __('Updates, options, etc', KP_TXT_DOMAIN),
				'url' => 'kls_settings_page',
				'capability' => 'manage_settings_data_kls',
				'order' => '120',
			);

			return $pages;
		}

		/**
		 * Settings page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function settingsPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_settings_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');

			if (isset($_GET['tab'])) {
				$active_tab = $_GET['tab'];
			} else {
				$active_tab = 'kls_settings_page';
			}
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('General settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('General settings where you can control updates, loaded options, toggle debug mode/font-awesome, cleanup the WordPress standard dashboard and much more.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<h2 class="nav-tab-wrapper">
									<a href="?page=kls_settings_page&tab=kls_settings_page" class="nav-tab <?php echo $active_tab == 'kls_settings_page' ? 'nav-tab-active' : ''; ?>"><?php _e('Settings', KP_TXT_DOMAIN); ?></a>
									<a href="?page=kls_settings_page&tab=kls_settings_page_legacy" class="nav-tab <?php echo $active_tab == 'kls_settings_page_legacy' ? 'nav-tab-active' : ''; ?>"><?php _e('Legacy features', KP_TXT_DOMAIN); ?></a>
								</h2>

								<form method="post" action="options.php">
									<?php
									if ($active_tab == 'kls_settings_page') {
										settings_fields('kls_settings_section');

										do_settings_sections('kls_settings');
									} elseif ($active_tab == 'kls_settings_page_legacy') {
										settings_fields('kls_settings_legacy_section');

										do_settings_sections('kls_settings_legacy');
									}

									// Output save settings button..
									submit_button(__('Save', KP_TXT_DOMAIN));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}
	new KP_Settings_Page();
}