<?php // phpcs:ignore
/**
 * Scripts page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Scripts_Page')) {
	/**
	 * Scripts page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Scripts_Page
	{
		/**
		 * Construct the scripts page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Scripts & tracking', KP_TXT_DOMAIN), __('Scripts & tracking', KP_TXT_DOMAIN), 'manage_scripts_data_kls', 'kls_scripts', array($this, 'scriptsPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Scripts & tracking', KP_TXT_DOMAIN),
				'description' => __('Add tracking scripts', KP_TXT_DOMAIN),
				'url' => 'kls_scripts',
				'capability' => 'manage_scripts_data_kls',
				'order' => '30',
			);

			return $pages;
		}

		/**
		 * Scripts page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function scriptsPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_scripts_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Scripts & tracking settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('A simple function to implement scripts and tracking codes to the front-end of the website. It is recommended to use Google Tag Manager for implementing multiple tracking methods to keep the speed of the website optimal.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_scripts_section');

									do_settings_sections('kls_scripts');

									// Output save settings button.
									submit_button(__('Save', KP_TXT_DOMAIN));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Scripts_Page();
}