<?php // phpcs:ignore
/**
 * Maintenance page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Maintenance_Page')) {
	/**
	 * Maintenance page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Maintenance_Page
	{
		/**
		 * Construct the maintenance page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Maintenance', KP_TXT_DOMAIN), __('Maintenance page', KP_TXT_DOMAIN), 'manage_maintenance_data_kls', 'kls_maintenance_page', array($this, 'maintenancePageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Maintenance page', KP_TXT_DOMAIN),
				'description' => __('Under construction', KP_TXT_DOMAIN),
				'url' => 'kls_maintenance_page',
				'capability' => 'manage_maintenance_data_kls',
				'order' => '50',
			);

			return $pages;
		}

		/**
		 * Maintenance page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function maintenancePageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_maintenance_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Maintenance page', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('The maintenance page has a few options to make it quick and easy for implementing the maintenance page. This page is skipped when you are in admin mode or use this query string at the end of any url: <code>?onderhoud_overslaan</code>. (Example: https://www.website.com/about-us/?onderhoud_overslaan) The page hides for one day until you have to use the <code>?onderhoud_overslaan</code> link again.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_maintenance_section');

									do_settings_sections('kls_maintenance');

									// Output save settings button.
									submit_button(__('Save', KP_TXT_DOMAIN));
									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Maintenance_Page();
}