<?php // phpcs:ignore
/**
 * Help page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Help_Page')) {
	/**
	 * Help page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Help_Page
	{
		/**
		 * Construct the help page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Help', KP_TXT_DOMAIN), __('Help', KP_TXT_DOMAIN), 'manage_kls', 'kls_help_page', array($this, 'helpPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Help', KP_TXT_DOMAIN),
				'description' => __('Just help', KP_TXT_DOMAIN),
				'url' => 'kls_help_page',
				'capability' => 'manage_kls',
				'order' => '130',
			);

			return $pages;
		}

		/**
		 * Help page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function helpPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');

			if (isset($_GET['tab'])) {
				$active_tab = wp_unslash($_GET['tab']);
			} else {
				$active_tab = 'kls_customer_help';
			}
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Plugin information page', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('Here you find all the information about the plugin.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<h2 class="nav-tab-wrapper">
									<a href="?page=kls_help_page&tab=kls_customer_help" class="nav-tab <?php echo $active_tab == 'kls_customer_help' ? 'nav-tab-active' : ''; ?>">
										<?php _e('Customer shortcodes', KP_TXT_DOMAIN); ?>
									</a>
									<a href="?page=kls_help_page&tab=kls_admin_help" class="nav-tab <?php echo $active_tab == 'kls_admin_help' ? 'nav-tab-active' : ''; ?>">
										<?php _e('Admin shortcodes', KP_TXT_DOMAIN); ?>
									</a>
									<a href="?page=kls_help_page&tab=kls_general_help" class="nav-tab <?php echo $active_tab == 'kls_general_help' ? 'nav-tab-active' : ''; ?>">
										<?php _e('General shortcodes', KP_TXT_DOMAIN); ?>
									</a>
									<a href="?page=kls_help_page&tab=kls_ninja_forms_help" class="nav-tab <?php echo $active_tab == 'kls_ninja_forms_help' ? 'nav-tab-active' : ''; ?>">
										<?php _e('Ninja forms merge tags', KP_TXT_DOMAIN); ?>
									</a>
									<a href="?page=kls_help_page&tab=kls_cookie_help" class="nav-tab <?php echo $active_tab == 'kls_cookie_help' ? 'nav-tab-active' : ''; ?>">
										<?php _e('Cookie shortcodes', KP_TXT_DOMAIN); ?>
									</a>
									<?php if (get_option('kls_toggle_anytime_integration') == 'on'): ?>
										<a href="?page=kls_help_page&tab=kls_anytime_help" class="nav-tab <?php echo $active_tab == 'kls_anytime_help' ? 'nav-tab-active' : ''; ?>">
											<?php _e('Anytime Fitness shortcodes', KP_TXT_DOMAIN); ?>
										</a>
									<?php endif; ?>
									<?php
									do_action('kp_help_nav', $active_tab);
									?>
								</h2>

								<?php if ($active_tab == 'kls_customer_help'): ?>
									<h2>
										<?php _e('All shortcodes', KP_TXT_DOMAIN); ?>
									</h2>
									<h3>
										<?php _e('Customer', KP_TXT_DOMAIN); ?>
									</h3>
									<p>
										<?php _e('Customer name', KP_TXT_DOMAIN); ?>: <code>[klant_naam]</code>
									</p>
									<p>
										<?php _e('Customer slogan', KP_TXT_DOMAIN); ?>: <code>[klant_slogan]</code>
									</p>
									<p>
										<?php _e('Customer email address', KP_TXT_DOMAIN); ?>: <code>[klant_email show_icon="1"]</code>
									</p>
									<p>
										<?php _e('Customer phone number', KP_TXT_DOMAIN); ?>: <code>[klant_telefoon show_icon="1"]</code>
									</p>
									<p>
										<?php _e('Customer street', KP_TXT_DOMAIN); ?>: <code>[klant_straat_huisnummer]</code>
									</p>
									<p>
										<?php _e('Customer postal code', KP_TXT_DOMAIN); ?>: <code>[klant_postcode]</code>
									</p>
									<p>
										<?php _e('Customer city', KP_TXT_DOMAIN); ?>: <code>[klant_stad]</code>
									</p>
									<p>
										<?php _e('Customer country', KP_TXT_DOMAIN); ?>: <code>[klant_land]</code>
									</p>
									<p>
										<?php _e('Customer full address', KP_TXT_DOMAIN); ?>: <code>[klant_adres]</code>
									</p>
									<p>
										<?php _e('Customer KvK', KP_TXT_DOMAIN); ?>: <code>[klant_kvk]</code>
									</p>
									<p>
										<?php _e('Customer VAT number', KP_TXT_DOMAIN); ?>: <code>[klant_btw]</code>
									</p>
									<p>
										<?php _e('Customer opening hours', KP_TXT_DOMAIN); ?>: <code>[klant_openingstijden titel="Personeelstijden" type="static|table"]</code>
									</p>

									<h3>
										<?php _e('Social media', KP_TXT_DOMAIN); ?>
									</h3>
									<p>
										<?php _e('Facebook', KP_TXT_DOMAIN); ?>: <code>[klant_facebook show_icon=1]</code>
									</p>
									<p>
										<?php _e('Twitter', KP_TXT_DOMAIN); ?>: <code>[klant_twitter show_icon=1]</code>
									</p>
									<p>
										<?php _e('Instagram', KP_TXT_DOMAIN); ?>: <code>[klant_instagram show_icon=1]</code>
									</p>
									<p>
										<?php _e('LinkedIn', KP_TXT_DOMAIN); ?>: <code>[klant_linkedin show_icon=1]</code>
									</p>
									<p>
										<?php _e('Pinterest', KP_TXT_DOMAIN); ?>: <code>[klant_pinterest show_icon=1]</code>
									</p>
									<p>
										<?php _e('Youtube', KP_TXT_DOMAIN); ?>: <code>[klant_youtube show_icon=1]</code>
									</p>
									<p>
										<?php _e('Whatsapp', KP_TXT_DOMAIN); ?>: <code>[klant_whatsapp show_icon=1]</code>
									</p>
									<p>
										<?php _e('Tiktok', KP_TXT_DOMAIN); ?>: <code>[klant_tiktok show_icon=1]</code>
									</p>
									<p>
										<?php _e('All socials', KP_TXT_DOMAIN); ?>: <code>[klant_social_media color="#ffffff" font_size="22px"]</code>
									</p>

									<h3>
										<?php _e("Usp's", KP_TXT_DOMAIN); ?>
									</h3>
									<p>
										<?php _e('Usp 1', KP_TXT_DOMAIN); ?>: <code>[usp_1 icon=1 color="#ffffff"]</code>
									</p>
									<p>
										<?php _e('Usp 2', KP_TXT_DOMAIN); ?>: <code>[usp_2 icon=1 color="#ffffff"]</code>
									</p>
									<p>
										<?php _e('Usp 3', KP_TXT_DOMAIN); ?>: <code>[usp_3 icon=1 color="#ffffff"]</code>
									</p>
									<p>
										<?php _e('Usp 4', KP_TXT_DOMAIN); ?>: <code>[usp_4 icon=1 color="#ffffff"]</code>
									</p>
									<p>
										<?php _e('Usp 5', KP_TXT_DOMAIN); ?>: <code>[usp_5 icon=1 color="#ffffff"]</code>
									</p>
									<p>
										<?php _e('Usp 6', KP_TXT_DOMAIN); ?>: <code>[usp_6 icon=1 color="#ffffff"]</code>
									</p>
									<p>
										<?php _e('Usp 1 with description', KP_TXT_DOMAIN); ?>: <code>[usp_1_met_beschrijving]</code>
									</p>
									<p>
										<?php _e('Usp 2 with description', KP_TXT_DOMAIN); ?>: <code>[usp_2_met_beschrijving]</code>
									</p>
									<p>
										<?php _e('Usp 3 with description', KP_TXT_DOMAIN); ?>: <code>[usp_3_met_beschrijving]</code>
									</p>
									<p>
										<?php _e('Usp 4 with description', KP_TXT_DOMAIN); ?>: <code>[usp_4_met_beschrijving]</code>
									</p>
									<p>
										<?php _e('Usp 5 with description', KP_TXT_DOMAIN); ?>: <code>[usp_5_met_beschrijving]</code>
									</p>
									<p>
										<?php _e('Usp 6 with description', KP_TXT_DOMAIN); ?>: <code>[usp_6_met_beschrijving]</code>
									</p>
									<p>
										<?php _e('Usp 1 with custom icon', KP_TXT_DOMAIN); ?>: <code>[usp_1_custom_icoon]</code>
									</p>
									<p>
										<?php _e('Usp 2 with custom icon', KP_TXT_DOMAIN); ?>: <code>[usp_2_custom_icoon]</code>
									</p>
									<p>
										<?php _e('Usp 3 with custom icon', KP_TXT_DOMAIN); ?>: <code>[usp_3_custom_icoon]</code>
									</p>
									<p>
										<?php _e('Usp 4 with custom icon', KP_TXT_DOMAIN); ?>: <code>[usp_4_custom_icoon]</code>
									</p>
									<p>
										<?php _e('Usp 5 with custom icon', KP_TXT_DOMAIN); ?>: <code>[usp_5_custom_icoon]</code>
									</p>
									<p>
										<?php _e('Usp 6 with custom icon', KP_TXT_DOMAIN); ?>: <code>[usp_6_custom_icoon]</code>
									</p>

								<?php elseif ($active_tab == 'kls_admin_help'): ?>

									<h3>
										<?php _e('Admin', KP_TXT_DOMAIN); ?>
									</h3>
									<p>
										<?php _e('Admin name', KP_TXT_DOMAIN); ?>: <code>[admin_name]</code>
									</p>
									<p>
										<?php _e('Admin website', KP_TXT_DOMAIN); ?>: <code>[admin_site]</code>
									</p>

								<?php elseif ($active_tab == 'kls_general_help'): ?>

									<h3>
										<?php _e('General', KP_TXT_DOMAIN); ?>
									</h3>
									<p>
										<?php _e('Load custom script', KP_TXT_DOMAIN); ?>: <code>[custom_script name="script_name"]</code>
									</p>
									<p>
										<?php _e('Current website url', KP_TXT_DOMAIN); ?>: <code>[website_url link="1"]</code>
									</p>
									<p>
										<?php _e('Current year', KP_TXT_DOMAIN); ?>: <code>[jaar]</code>
									</p>
									<p>
										<?php _e('Page title', KP_TXT_DOMAIN); ?>: <code>[pagina_titel]</code>
									</p>
									<p>
										<?php _e('Sitemap page', KP_TXT_DOMAIN); ?>: <code>[sitemap_pagina paginas="1" posts="1" projecten="0" pagina_titel="Pagina's" post_titel="Blogs" project_titel="Projecten"]</code>
									</p>
									<p>
										<?php _e('Privacy policy content', KP_TXT_DOMAIN); ?>: <code>[privacy_policy]</code>
									</p>
									<p>
										<?php _e('Cookie policy content', KP_TXT_DOMAIN); ?>: <code>[cookie_policy]</code>
									</p>
									<p>
										<?php _e('Disclaimer content', KP_TXT_DOMAIN); ?>: <code>[disclaimer]</code>
									</p>
									<p>
										<?php _e('Spintax', KP_TXT_DOMAIN); ?>: <code>[spintax]{Hallo en {welkom|wat {leuk|goed|geweldig}} {dat je hier bent!|dat je dit leest!}}[/spintax]</code>
									</p>
									<p>
										<?php _e('Link integration', KP_TXT_DOMAIN); ?>: <code>[link_integratie category="seo-pagina" amount="3" seperator="|"]</code>
									</p>

									<?php
									do_action('kp_help_general_tab');

								elseif ($active_tab == 'kls_ninja_forms_help'): ?>

									<h2>
										<?php _e('Ninja Forms form mergetags', KP_TXT_DOMAIN); ?>
									</h2>
									<p>
										<?php _e('If you want to add a default value to the merge tag then place it at the end of the merge tag like so', KP_TXT_DOMAIN) ?>: <code>{klant:adres:Adres niet gevonden}</code>
									</p>
									<p>
										<?php _e('Customer company', KP_TXT_DOMAIN); ?>: <code>{klant:bedrijfsnaam}</code>
									</p>
									<p>
										<?php _e('Customer phone number', KP_TXT_DOMAIN); ?>: <code>{klant:telefoonnummer}</code>
									</p>
									<p>
										<?php _e('Customer address', KP_TXT_DOMAIN); ?>: <code>{klant:adres}</code>
									</p>
									<p>
										<?php _e('Email', KP_TXT_DOMAIN); ?>: <code>{klant:emailadres}</code>
									</p>
									<p>
										<?php _e('CC email', KP_TXT_DOMAIN); ?>: <code>{klant:cc_emailadres}</code>
									</p>
									<p>
										<?php _e('BCC email', KP_TXT_DOMAIN); ?>: <code>{klant:bcc_emailadres}</code>
									</p>
									<p>
										<?php _e('Zapier email', KP_TXT_DOMAIN); ?>: <code>{zapier:emailadres}</code>
									</p>
									<p>
										<?php _e('Zapier webhook', KP_TXT_DOMAIN); ?>: <code>{zapier:webhook}</code>
									</p>
									<p>
										<?php _e('Admin name', KP_TXT_DOMAIN); ?>: <code>{admin:name}</code>
									</p>
									<p>
										<?php _e('Website cookie tracking', KP_TXT_DOMAIN); ?>: <code>{website:cookie_tracking}</code>
									</p>
									<p>
										<?php _e('Website url', KP_TXT_DOMAIN); ?>: <code>{website:url}</code>
									</p>

									<p>
										<?php _e('Show field value (Ninja Forms)', KP_TXT_DOMAIN); ?>: <code>[nf_session_value field_key="value" value_before="" value_after=""]</code><br>
									</p>
									<p>
										<?php _e('Show field value (Gravity Forms)', KP_TXT_DOMAIN); ?>: <code>[gf_session_value field_key="value" value_before="" value_after=""]</code><br>
									</p>
									<p>
										<?php _e('This shortcode shows the value of an field after a form has been submitted. Value before and after lets you add whitespaces, colons or special characters to complete the output.', KP_TXT_DOMAIN); ?>
									</p>

								<?php elseif ($active_tab == 'kls_cookie_help'): ?>

									<h2>
										<?php _e('Cookie shortcodes', KP_TXT_DOMAIN); ?>
									</h2>
									<p>
										<?php _e('Cookie accept button text', KP_TXT_DOMAIN); ?>: <code>[cookie_button_text]</code>
									</p>
									<p>
										<?php _e('Change cookie settings button', KP_TXT_DOMAIN); ?>: <code>[edit_cookies_button]</code>
									</p>
									<p>
										<?php _e('Change cookie settings link', KP_TXT_DOMAIN); ?>: <code>[edit_cookies_link]</code>
									</p>

								<?php elseif (get_option('kls_toggle_anytime_integration') == 'on' && $active_tab == 'kls_anytime_help'): ?>
									<h2>
										<?php _e('Anytime Fitness shortcodes', KP_TXT_DOMAIN); ?>
									</h2>
									<p>
										<?php _e('Anytime algemene voorwaarden', KP_TXT_DOMAIN); ?>: <code>[af_algemene_voorwaarden]</code>
									</p>
									<p>
										<?php _e('Grouplesson url', KP_TXT_DOMAIN); ?>: <code>[af_groepsles_url]</code>
									</p>
									<p>
										<?php _e('Registration url', KP_TXT_DOMAIN); ?>: <code>[af_inschrijf_url]</code>
									</p>
									<p>
										<?php _e('Grouplessons button', KP_TXT_DOMAIN); ?>: <code>[af_groepslessen_knop style="primary" margin="20px 0px 0px 0px" text="Bekijk groepslesrooster"]</code>
									</p>
									<p>
										<?php _e('24/7 text', KP_TXT_DOMAIN); ?>: <code>[af_24_7 original="Text" other ="text"]</code>
									</p>
									<p>
										<?php _e('Grouplesson slider', KP_TXT_DOMAIN); ?>: <code>[af_groepslessen_slider]</code>
									</p>
									<p>
										<?php _e('Clubimpression slider', KP_TXT_DOMAIN); ?>: <code>[af_clubimpressie_slider]</code>
									</p>
									<p>
										<?php _e('Text marquee', KP_TXT_DOMAIN); ?>: <code>[af_marquee]</code>
									</p>
									<p>
										<?php _e('Appointment iframe', KP_TXT_DOMAIN); ?>: <code>[af_afspraken_module type="intake"]</code>
									</p>

									<h3>
										<?php _e('Presale shortcodes', KP_TXT_DOMAIN); ?>
									</h3>
									<p>
										<?php _e('Location openings date', KP_TXT_DOMAIN); ?>: <code>[af_locatie_opening]</code>
									</p>
									<p>
										<?php _e('Presale discount amount', KP_TXT_DOMAIN); ?>: <code>[af_presale_korting]</code>
									</p>
									<p>
										<?php _e('Presale date', KP_TXT_DOMAIN); ?>: <code>[af_presale_datum]</code>
									</p>
									<p>
										<?php _e('VIP weekend date', KP_TXT_DOMAIN); ?>: <code>[af_vip_weekend]</code>
									</p>
								<?php endif;

								do_action('kp_help_content', $active_tab);
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Help_Page();
}