<?php // phpcs:ignore
/**
 * Customer page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Customer_Page')) {
	/**
	 * Customer page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Customer_Page
	{
		/**
		 * Construct the customer page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Customer', KP_TXT_DOMAIN), __('Customer', KP_TXT_DOMAIN), 'manage_customer_data_kls', 'kls_customer', array($this, 'customerPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Customer', KP_TXT_DOMAIN),
				'description' => __('Data for shortcodes', KP_TXT_DOMAIN),
				'url' => 'kls_customer',
				'capability' => 'manage_customer_data_kls',
				'order' => '20',
			);

			return $pages;
		}

		/**
		 * Customer page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function customerPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_customer_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');

			if (isset($_GET['tab'])) {
				$active_tab = $_GET['tab'];
			} else {
				$active_tab = 'kls_customer';
			}
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Customer settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('Add the customer data here. The data can be used in shortcodes across the whole site.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<h2 class="nav-tab-wrapper">
									<a href="?page=kls_customer&tab=kls_customer" class="nav-tab <?php echo $active_tab == 'kls_customer' ? 'nav-tab-active' : ''; ?>"><?php _e('Customer settings', KP_TXT_DOMAIN); ?></a>
									<?php if (current_user_can('manage_kls')): ?>
										<a href="?page=kls_customer&tab=kls_usps" class="nav-tab <?php echo $active_tab == 'kls_usps' ? 'nav-tab-active' : ''; ?>"><?php _e('USP settings', KP_TXT_DOMAIN); ?></a>
									<?php endif; ?>
									<a href="?page=kls_customer&tab=kls_opening_hours" class="nav-tab <?php echo $active_tab == 'kls_opening_hours' ? 'nav-tab-active' : ''; ?>"><?php _e('Opening hours settings', KP_TXT_DOMAIN); ?></a>
									<a href="?page=kls_customer&tab=kls_customer_social" class="nav-tab <?php echo $active_tab == 'kls_customer_social' ? 'nav-tab-active' : ''; ?>"><?php _e('Customer social settings', KP_TXT_DOMAIN); ?></a>
									<?php if (current_user_can('manage_kls')): ?>
										<a href="?page=kls_customer&tab=kls_forms" class="nav-tab <?php echo $active_tab == 'kls_forms' ? 'nav-tab-active' : ''; ?>"><?php _e('Form settings', KP_TXT_DOMAIN); ?></a>
									<?php endif; ?>
									<?php if (get_option('kls_toggle_anytime_integration') == 'on'): ?>
										<a href="?page=kls_customer&tab=kls_anytime_fitness" class="nav-tab <?php echo $active_tab == 'kls_anytime_fitness' ? 'nav-tab-active' : ''; ?>"><?php _e('Anytime Fitness settings', KP_TXT_DOMAIN); ?></a>
									<?php endif; ?>
									<?php if (get_option('kls_toggle_anytime_presale_integration') == 'on'): ?>
										<a href="?page=kls_customer&tab=kls_anytime_fitness_presale" class="nav-tab <?php echo $active_tab == 'kls_anytime_fitness_presale' ? 'nav-tab-active' : ''; ?>"><?php _e('Anytime Fitness presale settings', KP_TXT_DOMAIN); ?></a>
									<?php endif; ?>
								</h2>

								<form method="post" action="options.php">
									<?php
									// output security fields for the registered setting
									if ($active_tab == 'kls_customer') {
										settings_fields('kls_customer');

										do_settings_sections('kls_customer');
									} elseif ($active_tab == 'kls_usps') {
										settings_fields('kls_usps');

										do_settings_sections('kls_usps');
									} elseif ($active_tab == 'kls_opening_hours') {
										settings_fields('kls_opening_hours');

										do_settings_sections('kls_opening_hours');
									} elseif ($active_tab == 'kls_customer_social') {
										settings_fields('kls_customer_social');

										do_settings_sections('kls_customer_social');
									} elseif ($active_tab == 'kls_forms') {
										settings_fields('kls_forms');

										do_settings_sections('kls_forms');
									} elseif (!current_user_can('manage_anytime_kls') && $active_tab == 'kls_anytime_fitness') {
										settings_fields('kls_anytime_fitness');

										do_settings_sections('kls_anytime_fitness');
									} elseif (!current_user_can('manage_anytime_kls') && $active_tab == 'kls_anytime_fitness_presale') {
										settings_fields('kls_anytime_fitness_presale');

										do_settings_sections('kls_anytime_fitness_presale');
									}

									// Output save settings button.
									submit_button(__('Save', KP_TXT_DOMAIN));
									?>
								</form>
								<?php
								if (current_user_can('manage_kls') && $active_tab == 'kls_anytime_fitness'):
									?>
									<h2>
										<?php _e('Add Anytime links to all posts', KP_TXT_DOMAIN); ?>
									</h2>
									<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
										<input type="hidden" name="action" value="kls_add_anytime_links">
										<button class="kls-button button button-secundary">
											<?php _e('Fix Anytime links', KP_TXT_DOMAIN); ?>
										</button>
									</form>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Customer_Page();
}