<?php // phpcs:ignore
/**
 * API page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_API_Page')) {
	/**
	 * API page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_API_Page
	{
		/**
		 * Construct the API page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('API', KP_TXT_DOMAIN), __('API', KP_TXT_DOMAIN), 'manage_admin_kls', 'kls_api', array($this, 'apiPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('API', KP_TXT_DOMAIN),
				'description' => __('API settings for the portal', KP_TXT_DOMAIN),
				'url' => 'kls_api',
				'capability' => 'manage_admin_kls',
				'order' => '60',
			);

			return $pages;
		}

		/**
		 * API page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function apiPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_admin_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');

			if (isset($_GET['tab'])) {
				$active_tab = $_GET['tab'];
			} else {
				$active_tab = 'kls_api';
			}
			// [Dev] Todo, split this up in multiple tabs. First tab with regeneration for the API. Second tab with the logs of the API. Third tab for the documentation of the API.
			// [Dev] Todo, consider making the API visible only once.
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Klasse API key', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('The Klasse API connects the customer dashboard with the customer portal.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<h2 class="nav-tab-wrapper">
									<a href="?page=kls_api&tab=kls_api" class="nav-tab <?php echo $active_tab == 'kls_api' ? 'nav-tab-active' : ''; ?>"><?php _e('Api', KP_TXT_DOMAIN); ?></a>
									<a href="?page=kls_api&tab=kls_api_documentation" class="nav-tab <?php echo $active_tab == 'kls_api_documentation' ? 'nav-tab-active' : ''; ?>"><?php _e('Documentation', KP_TXT_DOMAIN); ?></a>
									<a href="?page=kls_api&tab=kls_api_logs" class="nav-tab <?php echo $active_tab == 'kls_api_logs' ? 'nav-tab-active' : ''; ?>"><?php _e('Logs', KP_TXT_DOMAIN); ?></a>
								</h2>

								<?php
								if ($active_tab == 'kls_api') {
									?>
									<h2>
										<?php _e('Regenerate API key', KP_TXT_DOMAIN); ?>
									</h2>
									<p>
										<?php echo __('Current api key: ', KP_TXT_DOMAIN) . '<code>' . get_option('kls_api_key') . '</code>'; ?>
									</p>
									<p>
										<?php echo __('Last api change: ', KP_TXT_DOMAIN) . '<code>' . get_option('kls_api_last_change') . '</code>'; ?>
									</p>
									<p>
										<?php echo __('Last api connection: ', KP_TXT_DOMAIN) . '<code>' . get_option('kls_api_last_connection') . '</code>'; ?>
									</p>
									<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
										<input type="hidden" name="action" value="kls_regenerate_api_key">
										<button class="kls-button button button-secundary">
											<?php _e('Generate new api-key', KP_TXT_DOMAIN); ?>
										</button>
									</form>
									<?php
								} elseif ($active_tab == 'kls_api_documentation') {
									?>
									<h2>Endpoints V1 <small>(Deprecated)</small></h2>
									<h3>Post</h3>
									<p>Default endpoint: <code>?kls-website-api=API_KEY</code></p>
									<h5>Parameters</h5>
									<p>Key: <code>kls-website-api</code> value: <code>api key</code></p>
									<p>Key: <code>kls_clear_cache</code> value: <code>0 or 1</code></p>
									<p>Key: <code>kls_insert_ips</code> value: <code>0 or 1</code></p>
									<p>Key: <code>kls_combined</code> value: <code>0 or 1</code></p>
									<p>Key: <code>kls_trusted_ips</code> value: <code>192.168.178.1,192.168.178.2</code></p>
									<p>Key: <code>kls_update_options</code> value: <code>0 or 1</code></p>
									<p>Key: <code>kls_option_data-*option_name*</code> value: <code>kls_option_data|*option_name*|*option_value*</code></p>

									<h2>Endpoints V2</h2>

									<h3>Defaults</h3>
									<p>Secret key header. key: <code>secret-key</code> value: <code>*api_key*</code></p>

									<h3>Post</h3>
									<p>Endpoints to update data in the site.</p>
									<h4>Options</h4>
									<p><code>/wp-json/klasse-api/v2/update-options</code></p>
									<h5>Parameters</h5>
									<p>Simple. Key: <code>*option_name*</code> value: <code>*option_value*</code></p>
									<p>Combine the data. Key: <code>*option_name*|combine|*seperator*</code> value: <code>*option_value*</code></p>
									<p>Update a WP rocket option. Key: <code>*option_name*|rocket_option</code> value: <code>*option_value*</code></p>
									<h4>Theme mods: </h4>
									<p><code>/wp-json/klasse-api/v2/update-theme-mods</code></p>
									<h5>Parameters</h5>
									<p>Key: <code>*theme_mod_name*</code> value: <code>*theme_mod_value*</code></p>
									<h4>Trusted ip's:</h4>
									<p><code>/wp-json/klasse-api/v2/update-trusted-ips</code></p>
									<h5>Parameters</h5>
									<p>Key: <code>trusted_ips</code> value: <code>192.168.178.1,192.168.178.2</code></p>
									<p>Key: <code>combine</code> value: <code>1 or 0</code></p>
									<p>Key: <code>clear</code> value: <code>1 or 0</code></p>
									<h3>Get</h3>
									<p>Endpoints to get data from the site</p>
									<p>All options: <code>/wp-json/klasse-api/v2/get-options</code></p>
									<p>One option: <code>/wp-json/klasse-api/v2/get-option/*option_name*</code></p>
									<p>All theme mods: <code>/wp-json/klasse-api/v2/get-theme-mods</code></p>
									<p>One theme mod: <code>/wp-json/klasse-api/v2/get-theme-mod/*theme_mod_name*</code></p>
									<?php
								}
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_API_Page();
}