<?php // phpcs:ignore
/**
 * Admin pages class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if ( ! defined('ABSPATH') ) {
	exit;
}

if ( ! class_exists('KP_AdminPages') ) {
	/**
	 * Admin pages class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_AdminPages
	{
		/**
		 * Construct the admin pages.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			$server_name = isset($_SERVER['SERVER_NAME']) ? sanitize_text_field(wp_unslash($_SERVER['SERVER_NAME'])) : '';
			$request_uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';

			$url = 'https://' . esc_html( $server_name ) . esc_html( $request_uri );
			if ( is_admin() && strpos( $url, 'kls' ) !== false ) {
				add_action('admin_enqueue_scripts', array($this, 'adminStyle'));
			}

			/**
			 * Include all admin pages.
			 * 
			 * @since 0.0.01
			 * 
			 * @author Joeri van der Stek <joeri@klassebv.nl>
			 */
			require_once 'pages/dashboard.class.php';
			require_once 'pages/customer.class.php';
			require_once 'pages/scripts.class.php';
			require_once 'pages/cookie.class.php';
			require_once 'pages/maintenance.class.php';
			require_once 'pages/api.class.php';
			require_once 'pages/woocommerce.class.php';
			require_once 'pages/security.class.php';
			require_once 'pages/speed.class.php';
			require_once 'pages/tools.class.php';
			require_once 'pages/admin.class.php';
			require_once 'pages/settings.class.php';
			require_once 'pages/help.class.php';
		}

		/**
		 * Include admin scripts & styles
		 *
		 * @since 0.0.01
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 */
		public function adminStyle()
		{
			wp_enqueue_style('kls_admin_css', KP_ASSETS_PATH . 'build/admin/admin.css', false, KP_VERSION);
			wp_enqueue_script('kls_admin_js', KP_ASSETS_PATH . 'build/admin/admin.js', false, KP_VERSION);
		}
	}

	new KP_AdminPages();
}

/**
 * Include all admin includes
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/includes/permissions/permissions.php';
require_once __DIR__ . '/includes/api/api.php';
require_once __DIR__ . '/includes/settings/settings.php';
require_once __DIR__ . '/includes/options.php';
require_once __DIR__ . '/includes/htaccess/htaccess.php';
require_once __DIR__ . '/includes/admin/admin.php';
require_once __DIR__ . '/includes/admin/duplicate-post.class.php';
require_once __DIR__ . '/includes/admin/notifications.php';
require_once __DIR__ . '/includes/import-export/export.php';
require_once __DIR__ . '/includes/import-export/import.php'; 
