<?php

/**
 * Create standard pages
 *
 * @since 0.0.05
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_pages() {
	$privacy_content = '[et_pb_section fb_built="1" _builder_version="3.22" global_colors_info="{}"][et_pb_row _builder_version="3.25" background_size="initial" background_position="top_left" background_repeat="repeat" global_colors_info="{}"][et_pb_column type="4_4" _builder_version="3.25" custom_padding="|||" global_colors_info="{}" custom_padding__hover="|||"][et_pb_text _builder_version="4.9.11" background_size="initial" background_position="top_left" background_repeat="repeat" hover_enabled="0" global_colors_info="{}" sticky_enabled="0"][privacy_policy][/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]';

	$cookie_content = '[et_pb_section fb_built="1" _builder_version="3.22" global_colors_info="{}"][et_pb_row _builder_version="3.25" background_size="initial" background_position="top_left" background_repeat="repeat" global_colors_info="{}"][et_pb_column type="4_4" _builder_version="3.25" custom_padding="|||" global_colors_info="{}" custom_padding__hover="|||"][et_pb_text _builder_version="4.9.11" background_size="initial" background_position="top_left" background_repeat="repeat" hover_enabled="0" global_colors_info="{}" sticky_enabled="0"][cookie_policy][/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]';

	$disclaimer_content = '[et_pb_section fb_built="1" _builder_version="3.22" global_colors_info="{}"][et_pb_row _builder_version="3.25" background_size="initial" background_position="top_left" background_repeat="repeat" global_colors_info="{}"][et_pb_column type="4_4" _builder_version="3.25" custom_padding="|||" global_colors_info="{}" custom_padding__hover="|||"][et_pb_text _builder_version="4.9.11" background_size="initial" background_position="top_left" background_repeat="repeat" hover_enabled="0" global_colors_info="{}" sticky_enabled="0"][disclaimer][/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]';

	$thankyou_content = '[et_pb_section fb_built="1" _builder_version="3.22" global_colors_info="{}"][et_pb_row _builder_version="3.25" background_size="initial" background_position="top_left" background_repeat="repeat" global_colors_info="{}"][et_pb_column type="4_4" _builder_version="3.25" custom_padding="|||" global_colors_info="{}" custom_padding__hover="|||"][et_pb_text _builder_version="4.9.11" background_size="initial" background_position="top_left" background_repeat="repeat" hover_enabled="0" global_colors_info="{}" sticky_enabled="0"]<h1>Bedankt</h1><p>Dank je wel voor het invullen van ons contactformulier. We hebben je bericht ontvangen en nemen snel contact met je op.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]';

	$sitemap_content = '[et_pb_section fb_built="1" _builder_version="3.22" global_colors_info="{}"][et_pb_row _builder_version="3.25" background_size="initial" background_position="top_left" background_repeat="repeat" global_colors_info="{}"][et_pb_column type="4_4" _builder_version="3.25" custom_padding="|||" global_colors_info="{}" custom_padding__hover="|||"][et_pb_text _builder_version="4.9.11" background_size="initial" background_position="top_left" background_repeat="repeat" hover_enabled="0" global_colors_info="{}" sticky_enabled="0"][sitemap_pagina][/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]';

	$privacy_page = array(
		'post_title'   => wp_strip_all_tags( 'Privacyverklaring' ),
		'post_content' => $privacy_content,
		'post_status'  => 'publish',
		'post_author'  => 1,
		'post_type'    => 'page',
		'meta_input'   => array(
			'_et_pb_use_builder' => 'on',
		),
	);

	$cookie_page = array(
		'post_title'   => wp_strip_all_tags( 'Cookiebeleid' ),
		'post_content' => $cookie_content,
		'post_status'  => 'publish',
		'post_author'  => 1,
		'post_type'    => 'page',
		'meta_input'   => array(
			'_et_pb_use_builder' => 'on',
		),
	);

	$disclaimer_page = array(
		'post_title'   => wp_strip_all_tags( 'Disclaimer' ),
		'post_content' => $disclaimer_content,
		'post_status'  => 'publish',
		'post_author'  => 1,
		'post_type'    => 'page',
		'meta_input'   => array(
			'_et_pb_use_builder' => 'on',
		),
	);

	$thankyou_page = array(
		'post_title'   => wp_strip_all_tags( 'Bedankt' ),
		'post_content' => $thankyou_content,
		'post_status'  => 'publish',
		'post_author'  => 1,
		'post_type'    => 'page',
		'meta_input'   => array(
			'_et_pb_use_builder' => 'on',
		),
	);

	$sitemap_page = array(
		'post_title'   => wp_strip_all_tags( 'Sitemap' ),
		'post_content' => $sitemap_content,
		'post_status'  => 'publish',
		'post_author'  => 1,
		'post_type'    => 'page',
		'meta_input'   => array(
			'_et_pb_use_builder' => 'on',
		),
	);

	// Insert the post into the database.
	wp_insert_post( $privacy_page );
	wp_insert_post( $cookie_page );
	wp_insert_post( $disclaimer_page );
	wp_insert_post( $thankyou_page );
	wp_insert_post( $sitemap_page );

	// Redirect to the settings page.
	wp_redirect( admin_url( 'admin.php?page=kls_settings_page' ) );
	kls_admin_notice( __( 'Standard pages have been created.', KP_TXT_DOMAIN ), 'success', true );
}

add_action( 'admin_post_kls_create_pages', 'kls_create_pages' );

/**
 * Clear cache button
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_clear_caches() {
	// Clear Divi cache.
	if ( function_exists( 'remove_static_resources' ) ) {
		ET_Core_PageResource::do_remove_static_resources( 'all', 'all', true );
		kls_admin_notice( __( 'Divi static css has been cleared.', KP_TXT_DOMAIN ), 'success', true );
	}

	// Clear WP Rocket cache.
	// Clear cache.
	if ( function_exists( 'rocket_clean_domain' ) ) {
		rocket_clean_domain();
		kls_admin_notice( __( 'WP Rocket cache have been cleared.', KP_TXT_DOMAIN ), 'success', true );
	}

	// Clear minified CSS and JavaScript files.
	if ( function_exists( 'rocket_clean_minify' ) ) {
		rocket_clean_minify();
		kls_admin_notice( __( 'WP Rocket minify have been cleared.', KP_TXT_DOMAIN ), 'success', true );
	}

	// Preload cache.
	if ( function_exists( 'run_rocket_bot' ) ) {
		run_rocket_bot();
		kls_admin_notice( __( 'WP Rocket preload has started.', KP_TXT_DOMAIN ), 'success', true );
	}

	// Clear Litespeed caches.
	// Clear all caches.
	do_action( 'litespeed_purge_all' );

	// Redirect back to the page.
	$location = isset( $_SERVER['HTTP_REFERER'] ) ? wp_unslash( $_SERVER['HTTP_REFERER'] ) : admin_url( 'admin.php?page=kls_dashboard' );
	wp_safe_redirect( $location );
	kls_admin_notice( __( 'All caches have been cleared.', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_clear_caches', 'kls_clear_caches' );

/**
 * Check the site for lorem ipsum.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.89
 */
function kls_check_loremipsum() {
	$args = array(
		'post_type' => 'any',
	);

	$page_query = new WP_Query(
		array(
			'posts_per_page' => -1,
			'post_type'      => 'page',
		)
	);
	$post_query = new WP_Query(
		array(
			'posts_per_page' => -1,
			'post_type'      => 'post',
		)
	);

	$lorem_count = 0;
	$lorem_ids   = array();

	if ( $page_query->have_posts() ) {
		while ( $page_query->have_posts() ) {
			$page_query->the_post();
			$the_content = get_the_content();
			$the_title   = get_the_title();

			if ( strpos( strtolower( $the_content ), 'lorem' ) !== false ) {
				$lorem_count++;
				array_push( $lorem_ids, $the_title );
			}
		}
	}

	if ( $post_query->have_posts() ) {
		while ( $post_query->have_posts() ) {
			$post_query->the_post();
			$the_content = get_the_content();
			$the_title   = get_the_title();

			if ( strpos( strtolower( $the_content ), 'lorem' ) !== false ) {
				$lorem_count++;
				array_push( $lorem_ids, $the_title );
			}
		}
	}

	// Redirect back to the page.
	wp_redirect( admin_url( 'admin.php?page=kls_dashboard' ) );
	if ( 0 == $lorem_count ) {
		kls_admin_notice( __( 'There are no posts containing Lorem Ipsum!', KP_TXT_DOMAIN ), 'success', true );
	} else {
		$lorem_ids = implode( ', ', $lorem_ids );
		// Translators: The first variable is the lorem ipsum count in a number. The second variable are numbers comma separated.
		kls_admin_notice( sprintf( __( 'There are %1$s posts with Lorem ipsum. The post or page ids are: %2$s. The text could be invisible on the front-end but make sure to check all the pages!', KP_TXT_DOMAIN ), $lorem_count, $lorem_ids ), 'warning', true );
	}
}
add_action( 'admin_post_kls_check_loremipsum', 'kls_check_loremipsum' );

/**
 * Check the site for falsely spelled words.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.96
 */
function kls_check_words() {
	$page_query = new WP_Query(
		array(
			'posts_per_page' => -1,
			'post_type'      => 'page',
		)
	);
	$post_query = new WP_Query(
		array(
			'posts_per_page' => -1,
			'post_type'      => 'post',
		)
	);

	$lorem_count = 0;
	$lorem_ids   = array();

	$words = wp_remote_get( 'https://portal.klassebv.nl/api/words' );
	$body  = json_decode( wp_remote_retrieve_body( $words ) );

	foreach ( $body as $word ) {
		if ( $page_query->have_posts() ) {
			while ( $page_query->have_posts() ) {
				$page_query->the_post();
				$the_content = get_the_content();
				$the_title   = get_the_title();

				if ( strpos( strtolower( $the_content ), $word ) !== false ) {
					print_r( strtolower( $the_content ) );
					$lorem_count++;
					array_push( $lorem_ids, $the_title . ' - Woord: ' . $word );
				}
			}
		}

		if ( $post_query->have_posts() ) {
			while ( $post_query->have_posts() ) {
				$post_query->the_post();
				$the_content = get_the_content();
				$the_title   = get_the_title();

				if ( strpos( strtolower( $the_content ), $word ) !== false ) {
					$lorem_count++;
					array_push( $lorem_ids, $the_title . ' - Woord: ' . $word );
				}
			}
		}
	}

	// Redirect back to the page.
	wp_redirect( admin_url( 'admin.php?page=kls_dashboard' ) );
	if ( 0 == $lorem_count ) {
		kls_admin_notice( __( 'There are no posts containing incorrectly spelled words!', KP_TXT_DOMAIN ), 'success', true );
	} else {
		$lorem_ids = implode( ', ', $lorem_ids );
		// Translators: The first variable is the lorem ipsum count in a number. The second variable are numbers comma separated.
		kls_admin_notice( sprintf( __( 'There are %1$s posts with incorrectly spelled words. The post or page names including the word are: %2$s. The text could be invisible on the front-end but make sure to check all the pages!', KP_TXT_DOMAIN ), $lorem_count, $lorem_ids ), 'warning', true );
	}
}
add_action( 'admin_post_kls_check_words', 'kls_check_words' );
