<?php

/**
 * Search console sanitization
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.86
 */
function kls_search_console_sanitization( $value ) {
	$value = str_replace( '<meta name="google-site-verification" content="', '', $value );
	$value = str_replace( '" />', '', $value );

	return $value;
}

/**
 * Chatbot code sanitization
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.89
 */
function kls_chatbot_sanitization( $value ) {
	if ( strpos( $value, 'script' ) !== false ) {
		preg_match( "/configUrl: '(.*?)'/", $value, $values );
		$value = $values[1];
	}

	return $value;
}

/**
 * Chatbot code sanitization
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.89
 */
function kls_cookie_script_sanitization($value)
{
	if (strpos($value, '<script') !== false) {
		preg_match('/src="(.*?)"/', $value, $values);
		$value = $values[1];
	}

	return $value;
}
