<?php

/**
 * Create and add capabilities to specific user roles.
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_add_cap() {
	// Gets the simple_role role object.
	$role_admin  = get_role( 'administrator' );
	$role_editor = get_role( 'editor' );
	$role_author = get_role( 'author' );

	// Add a new capability.
	$role_admin->add_cap( 'manage_kls', true );
	$role_editor->add_cap( 'manage_kls', false );
	$role_admin->add_cap( 'manage_admin_kls', true );

	$role_admin->add_cap( 'manage_customer_data_kls', true );
	$role_editor->add_cap( 'manage_customer_data_kls', true );
	$role_author->add_cap( 'manage_customer_data_kls', true );

	$role_admin->add_cap( 'manage_scripts_data_kls', true );
	$role_editor->add_cap( 'manage_scripts_data_kls', true );

	$role_admin->add_cap( 'manage_maintenance_data_kls', true );
	$role_editor->add_cap( 'manage_maintenance_data_kls', true );

	$role_admin->add_cap( 'manage_cookie_data_kls', true );
	$role_editor->add_cap( 'manage_cookie_data_kls', true );

	$role_admin->add_cap( 'manage_speed_data_kls', true );
	$role_editor->add_cap( 'manage_speed_data_kls', true );

	$role_admin->add_cap( 'manage_woocommerce_data_kls', true );
	$role_editor->add_cap( 'manage_woocommerce_data_kls', true );

	$role_admin->add_cap( 'manage_settings_data_kls', true );
	$role_editor->add_cap( 'manage_settings_data_kls', true );

	$role_admin->add_cap( 'manage_installer_kls', true );
}
add_action( 'init', 'kls_add_cap', 11 );

/**
 * Grant authors access to edit posts.
 *
 * @since 0.0.62
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_access_to_options_page_for_authors() {
	 return 'edit_posts';
}
add_filter( 'option_page_capability_kls_customer', 'kls_access_to_options_page_for_authors' );
add_filter( 'option_page_capability_kls_usps', 'kls_access_to_options_page_for_authors' );
add_filter( 'option_page_capability_kls_opening_hours', 'kls_access_to_options_page_for_authors' );
add_filter( 'option_page_capability_kls_customer_social', 'kls_access_to_options_page_for_authors' );
add_filter( 'option_page_capability_kls_forms', 'kls_access_to_options_page_for_authors' );
add_filter( 'option_page_capability_kls_anytime_fitness', 'kls_access_to_options_page_for_authors' );
