<?php

/**
 * Require the field sanitization
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.86
 */
require_once __DIR__ . '/setting_sanitization.php';
require_once __DIR__ . '/options/anytime-options.class.php';

/**
 * Create all section
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_sections() {
	// Customer.
	add_settings_section( 'kls_customer_section', __( 'Customer data', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_customer' );
	add_settings_section( 'kls_usps_section', __( 'USPs', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_usps' );
	add_settings_section( 'kls_opening_hours_section', __( 'Opening hours', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_opening_hours' );
	add_settings_section( 'kls_customer_social_section', __( 'Customer social media', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_customer_social' );
	add_settings_section( 'kls_forms_section', __( 'Forms', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_forms' );
	add_settings_section( 'kls_anytime_fitness_section', __( 'Anytime Fitness', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_anytime_fitness' );
	add_settings_section( 'kls_anytime_fitness_presale_section', __( 'Anytime Fitness presale', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_anytime_fitness_presale' );

	// Api.
	add_settings_section( 'kls_api_section', __( 'API', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_api' );

	// Scripts.
	add_settings_section( 'kls_scripts_section', __( 'Tracking & scripts', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_scripts' );

	// Security.
	add_settings_section( 'kls_security_section', __( 'Security', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_security' );

	// Maintenance.
	add_settings_section( 'kls_maintenance_section', __( 'Maintenance page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_maintenance' );

	// Cookie notice.
	add_settings_section( 'kls_cookie_section', __( 'Cookie notice page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_cookie' );
	add_settings_section( 'kls_cookie_popup_text_section', __( 'Cookie popup text page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_cookie_popup_text' );
	add_settings_section( 'kls_cookie_styling_section', __( 'Cookie colors page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_cookie_styling' );
	add_settings_section( 'kls_cookie_settings_section', __( 'Cookie settings page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_cookie_settings' );

	// Speed.
	add_settings_section( 'kls_speed_settings_section', __( 'Speed settings page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_speed_settings' );

	// Woocommerce.
	add_settings_section( 'kls_woocommerce_settings_section', __( 'Woocommerce settings page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_woocommerce' );

	// Settings.
	add_settings_section( 'kls_settings_section', __( 'Settings page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_settings' );
	add_settings_section( 'kls_settings_legacy_section', __( 'Legacy settings page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_settings_legacy' );

	// Admin settings.
	add_settings_section( 'kls_admin_settings_section', __( 'Admin settings page', KP_TXT_DOMAIN ), 'kls_section_cb_empty', 'kls_admin_settings' );
}
add_action( 'admin_init', 'kls_create_sections' );

/**
 * Create customer settings fields
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_customer() {
	// Logo.
	add_settings_field(
		'kls_customer_logo',
		__( 'Customer logo', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_customer',
		'kls_customer_section',
		array(
			'label_for'   => 'kls_customer_logo',
			'button_text' => __(
				'Upload logo',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field(
		'kls_customer_favicon',
		__( 'Customer favicon', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_customer',
		'kls_customer_section',
		array(
			'label_for'   => 'kls_customer_favicon',
			'button_text' => __(
				'Upload favicon',
				KP_TXT_DOMAIN
			),
		)
	);

	// Data.
	add_settings_field( 'kls_customer_name', __( 'Customer name', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_name' ) );
	add_settings_field( 'kls_customer_slogan', __( 'Customer slogan', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_slogan' ) );
	add_settings_field( 'kls_customer_email', __( 'Customer email', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_email' ) );
	add_settings_field( 'kls_customer_phone', __( 'Customer phonenumber', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_phone' ) );
	add_settings_field( 'kls_customer_street', __( 'Customer adres', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_street' ) );
	add_settings_field( 'kls_customer_postcode', __( 'Customer postal code', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_postcode' ) );
	add_settings_field( 'kls_customer_city', __( 'Customer city', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_city' ) );
	add_settings_field( 'kls_customer_country', __( 'Customer country', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_country' ) );
	add_settings_field( 'kls_customer_maps_link', __( 'Customer Google Maps link', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_maps_link' ) );
	add_settings_field( 'kls_customer_kvk', __( 'Customer KVK', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_kvk' ) );
	add_settings_field( 'kls_customer_btw', __( 'Customer BTW', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_btw' ) );
	add_settings_field( 'kls_customer_main_color', __( 'Customer main color', KP_TXT_DOMAIN ), 'kls_colorpicker_field', 'kls_customer', 'kls_customer_section', array( 'label_for' => 'kls_customer_main_color' ) );

	add_settings_field( 'kls_customer_form_email', __( 'Form email', KP_TXT_DOMAIN ), 'kls_email_field', 'kls_forms', 'kls_forms_section', array( 'label_for' => 'kls_customer_form_email' ) );
	add_settings_field( 'kls_customer_form_cc_email', __( 'Form CC email', KP_TXT_DOMAIN ), 'kls_email_field', 'kls_forms', 'kls_forms_section', array( 'label_for' => 'kls_customer_form_cc_email' ) );
	add_settings_field( 'kls_customer_form_bcc_email', __( 'Form BCC email', KP_TXT_DOMAIN ), 'kls_email_field', 'kls_forms', 'kls_forms_section', array( 'label_for' => 'kls_customer_form_bcc_email' ) );
	add_settings_field( 'kls_customer_zapier_email', __( 'Zapier email', KP_TXT_DOMAIN ), 'kls_email_field', 'kls_forms', 'kls_forms_section', array( 'label_for' => 'kls_customer_zapier_email' ) );
	add_settings_field( 'kls_customer_zapier_webhook', __( 'Zapier webhook', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_forms', 'kls_forms_section', array( 'label_for' => 'kls_customer_zapier_webhook' ) );

	add_settings_field( 'kls_customer_usp_1', __( 'Customer usp 1', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_1' ) );
	add_settings_field( 'kls_customer_usp_1_description', __( 'Customer usp 1 description', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_1_description' ) );
	add_settings_field(
		'kls_customer_usp_1_icon',
		__( 'Icon usp 1', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_usps',
		'kls_usps_section',
		array(
			'label_for'   => 'kls_customer_usp_1_icon',
			'button_text' => __(
				'Upload usp 1 icon',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field( 'kls_customer_usp_2', __( 'Customer usp 2', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_2' ) );
	add_settings_field( 'kls_customer_usp_2_description', __( 'Customer usp 2 description', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_2_description' ) );
	add_settings_field(
		'kls_customer_usp_2_icon',
		__( 'Icon usp 2', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_usps',
		'kls_usps_section',
		array(
			'label_for'   => 'kls_customer_usp_2_icon',
			'button_text' => __(
				'Upload usp 2 icon',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field( 'kls_customer_usp_3', __( 'Customer usp 3', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_3' ) );
	add_settings_field( 'kls_customer_usp_3_description', __( 'Customer usp 3 description', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_3_description' ) );
	add_settings_field(
		'kls_customer_usp_3_icon',
		__( 'Icon usp 3', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_usps',
		'kls_usps_section',
		array(
			'label_for'   => 'kls_customer_usp_3_icon',
			'button_text' => __(
				'Upload usp 3 icon',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field( 'kls_customer_usp_4', __( 'Customer usp 4', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_4' ) );
	add_settings_field( 'kls_customer_usp_4_description', __( 'Customer usp 4 description', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_4_description' ) );
	add_settings_field(
		'kls_customer_usp_4_icon',
		__( 'Icon usp 4', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_usps',
		'kls_usps_section',
		array(
			'label_for'   => 'kls_customer_usp_4_icon',
			'button_text' => __(
				'Upload usp 4 icon',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field( 'kls_customer_usp_5', __( 'Customer usp 5', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_5' ) );
	add_settings_field( 'kls_customer_usp_5_description', __( 'Customer usp 5 description', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_5_description' ) );
	add_settings_field(
		'kls_customer_usp_5_icon',
		__( 'Icon usp 5', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_usps',
		'kls_usps_section',
		array(
			'label_for'   => 'kls_customer_usp_5_icon',
			'button_text' => __(
				'Upload usp 5 icon',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field( 'kls_customer_usp_6', __( 'Customer usp 6', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_6' ) );
	add_settings_field( 'kls_customer_usp_6_description', __( 'Customer usp 6 description', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_6_description' ) );
	add_settings_field(
		'kls_customer_usp_6_icon',
		__( 'Icon usp 6', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_usps',
		'kls_usps_section',
		array(
			'label_for'   => 'kls_customer_usp_6_icon',
			'button_text' => __(
				'Upload usp 6 icon',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field( 'kls_customer_usp_icon_size', __( 'Customer usp size', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_usps', 'kls_usps_section', array( 'label_for' => 'kls_customer_usp_icon_size' ) );

	// Opening hours.
	add_settings_field( 'kls_opening_hours_monday', __( 'Monday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_monday' ) );
	add_settings_field( 'kls_opening_hours_tuesday', __( 'Tuesday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_tuesday' ) );
	add_settings_field( 'kls_opening_hours_wednesday', __( 'Wednesday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_wednesday' ) );
	add_settings_field( 'kls_opening_hours_thursday', __( 'Thursday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_thursday' ) );
	add_settings_field( 'kls_opening_hours_friday', __( 'Friday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_friday' ) );
	add_settings_field( 'kls_opening_hours_saterday', __( 'Saterday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_saterday' ) );
	add_settings_field( 'kls_opening_hours_sunday', __( 'Sunday', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_opening_hours', 'kls_opening_hours_section', array( 'label_for' => 'kls_opening_hours_sunday' ) );

	// Customer social media.
	add_settings_field( 'kls_customer_facebook', __( 'Facebook url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_facebook' ) );
	add_settings_field( 'kls_customer_twitter', __( 'Twitter url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_twitter' ) );
	add_settings_field( 'kls_customer_instagram', __( 'Instagram url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_instagram' ) );
	add_settings_field( 'kls_customer_linkedin', __( 'LinkedIn url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_linkedin' ) );
	add_settings_field( 'kls_customer_youtube', __( 'Youtube url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_youtube' ) );
	add_settings_field( 'kls_customer_pinterest', __( 'Pinterest url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_pinterest' ) );
	add_settings_field( 'kls_customer_whatsapp', __( 'Whatsapp url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_whatsapp' ) );
	add_settings_field( 'kls_customer_tiktok', __( 'Tiktok url', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_customer_social', 'kls_customer_social_section', array( 'label_for' => 'kls_customer_tiktok' ) );
}
add_action( 'admin_init', 'kls_create_settings_customer' );

/**
 * Register customer settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_customer() {
	// Logo.
	register_setting( 'kls_customer', 'kls_customer_logo' );
	register_setting( 'kls_customer', 'kls_customer_favicon' );

	// Data.
	register_setting( 'kls_customer', 'kls_customer_name' );
	register_setting( 'kls_customer', 'kls_customer_slogan' );
	register_setting( 'kls_customer', 'kls_customer_email' );
	register_setting( 'kls_customer', 'kls_customer_phone' );
	register_setting( 'kls_customer', 'kls_customer_street' );
	register_setting( 'kls_customer', 'kls_customer_postcode' );
	register_setting( 'kls_customer', 'kls_customer_city' );
	register_setting( 'kls_customer', 'kls_customer_country' );
	register_setting( 'kls_customer', 'kls_customer_maps_link' );
	register_setting( 'kls_customer', 'kls_customer_kvk' );
	register_setting( 'kls_customer', 'kls_customer_btw' );
	register_setting( 'kls_customer', 'kls_customer_main_color' );

	register_setting( 'kls_forms', 'kls_customer_form_email' );
	register_setting( 'kls_forms', 'kls_customer_form_cc_email' );
	register_setting( 'kls_forms', 'kls_customer_form_bcc_email' );
	register_setting( 'kls_forms', 'kls_customer_zapier_email' );
	register_setting( 'kls_forms', 'kls_customer_zapier_webhook' );

	register_setting( 'kls_usps', 'kls_customer_usp_1' );
	register_setting( 'kls_usps', 'kls_customer_usp_1_description' );
	register_setting( 'kls_usps', 'kls_customer_usp_1_icon' );
	register_setting( 'kls_usps', 'kls_customer_usp_2' );
	register_setting( 'kls_usps', 'kls_customer_usp_2_description' );
	register_setting( 'kls_usps', 'kls_customer_usp_2_icon' );
	register_setting( 'kls_usps', 'kls_customer_usp_3' );
	register_setting( 'kls_usps', 'kls_customer_usp_3_description' );
	register_setting( 'kls_usps', 'kls_customer_usp_3_icon' );
	register_setting( 'kls_usps', 'kls_customer_usp_4' );
	register_setting( 'kls_usps', 'kls_customer_usp_4_description' );
	register_setting( 'kls_usps', 'kls_customer_usp_4_icon' );
	register_setting( 'kls_usps', 'kls_customer_usp_5' );
	register_setting( 'kls_usps', 'kls_customer_usp_5_description' );
	register_setting( 'kls_usps', 'kls_customer_usp_5_icon' );
	register_setting( 'kls_usps', 'kls_customer_usp_6' );
	register_setting( 'kls_usps', 'kls_customer_usp_6_description' );
	register_setting( 'kls_usps', 'kls_customer_usp_6_icon' );
	register_setting( 'kls_usps', 'kls_customer_usp_icon_size' );

	// Opening hours.
	register_setting( 'kls_opening_hours', 'kls_opening_hours_monday' );
	register_setting( 'kls_opening_hours', 'kls_opening_hours_tuesday' );
	register_setting( 'kls_opening_hours', 'kls_opening_hours_wednesday' );
	register_setting( 'kls_opening_hours', 'kls_opening_hours_thursday' );
	register_setting( 'kls_opening_hours', 'kls_opening_hours_friday' );
	register_setting( 'kls_opening_hours', 'kls_opening_hours_saterday' );
	register_setting( 'kls_opening_hours', 'kls_opening_hours_sunday' );

	// Social media.
	register_setting( 'kls_customer_social', 'kls_customer_facebook' );
	register_setting( 'kls_customer_social', 'kls_customer_twitter' );
	register_setting( 'kls_customer_social', 'kls_customer_instagram' );
	register_setting( 'kls_customer_social', 'kls_customer_linkedin' );
	register_setting( 'kls_customer_social', 'kls_customer_youtube' );
	register_setting( 'kls_customer_social', 'kls_customer_pinterest' );
	register_setting( 'kls_customer_social', 'kls_customer_whatsapp' );
	register_setting( 'kls_customer_social', 'kls_customer_tiktok' );
}
add_action( 'admin_init', 'kls_register_settings_customer' );

/**
 * Create scripts settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_scripts() {
	add_settings_field(
		'kls_scripts_searchconsole',
		__( 'Search console code', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for' => 'kls_scripts_searchconsole',
			'info_text' => __(
				'Want to use more than 1 code? separate the codes by a comma!',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field(
		'kls_scripts_gtm',
		__( 'GTM code', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for' => 'kls_scripts_gtm',
			'info_text' => __(
				'Only useable with the Child theme and newer templates. Check with the tag assistant before publishing to production.<br>Want to use more than 1 code? separate the codes by a comma!',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field(
		'kls_scripts_gtm_optimization',
		__( 'GTM code speed optimization', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for'   => 'kls_scripts_gtm_optimization',
			'info_text'   => __( 'Warning! This delays the GTM script until a first mouse movement, scroll or click. ', KP_TXT_DOMAIN ),
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_scripts_ua',
		__( 'Google Analytics G- code', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for' => 'kls_scripts_ua',
			'info_text' => __(
				'Want to use more than 1 code? separate the codes by a comma!',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field(
		'kls_scripts_fbpixel',
		__( 'Facebook pixel code', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for' => 'kls_scripts_fbpixel',
			'info_text' => __(
				'Want to use more than 1 code? separate the codes by a comma!',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field(
		'kls_scripts_fbpixel_optimization',
		__( 'Facebook pixel code speed optimization', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for'   => 'kls_scripts_fbpixel_optimization',
			'info_text'   => __( 'Warning! This delays the FB pixel script until a first mouse movement, scroll or click. Use with caution.', KP_TXT_DOMAIN ),
			'check_value' => 'on',
		)
	);
	add_settings_field( 'kls_scripts_chatbot', __( 'Landbot Chatbot code', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_scripts', 'kls_scripts_section', array( 'label_for' => 'kls_scripts_chatbot' ) );

	add_settings_field(
		'kls_scripts_cookie_script',
		__( 'Cookie-script.com script source', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_scripts',
		'kls_scripts_section',
		array(
			'label_for' => 'kls_scripts_cookie_script',
		)
	);

	if ( 'on' == get_option( 'kls_legacy_scripts_toggle' ) ) :
		add_settings_field( 'kls_scripts_head', __( 'Header', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_scripts', 'kls_scripts_section', array( 'label_for' => 'kls_scripts_head' ) );
		add_settings_field(
			'kls_scripts_body',
			__( 'Body', KP_TXT_DOMAIN ),
			'kls_textarea_field',
			'kls_scripts',
			'kls_scripts_section',
			array(
				'label_for' => 'kls_scripts_body',
				'info_text' => __(
					'Only useable with the Child theme and newer templates. Check the code of the page before publishing to production.',
					KP_TXT_DOMAIN
				),
			)
		);
		add_settings_field( 'kls_scripts_footer', __( 'Footer', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_scripts', 'kls_scripts_section', array( 'label_for' => 'kls_scripts_footer' ) );
	else :
		add_settings_field(
			'kls_script_selector',
			__( 'Custom scripts and styling', KP_TXT_DOMAIN ),
			'klsScriptsSelector',
			'kls_scripts',
			'kls_scripts_section',
			array(
				'label_for'   => 'kls_script_selector',
				'check_value' => 'on',
			)
		);
	endif;
}
add_action( 'admin_init', 'kls_create_settings_scripts' );

/**
 * Register scripts settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_scripts() {
	register_setting( 'kls_scripts_section', 'kls_scripts_searchconsole', 'kls_search_console_sanitization' );
	register_setting( 'kls_scripts_section', 'kls_scripts_gtm_optimization' );
	register_setting( 'kls_scripts_section', 'kls_scripts_gtm' );
	register_setting( 'kls_scripts_section', 'kls_scripts_ua' );
	register_setting( 'kls_scripts_section', 'kls_scripts_fbpixel' );
	register_setting( 'kls_scripts_section', 'kls_scripts_fbpixel_optimization' );
	register_setting( 'kls_scripts_section', 'kls_scripts_chatbot', 'kls_chatbot_sanitization' );
	register_setting( 'kls_scripts_section', 'kls_scripts_cookie_script', 'kls_cookie_script_sanitization' );

	register_setting( 'kls_scripts_section', 'kls_scripts_head' );
	register_setting( 'kls_scripts_section', 'kls_scripts_body' );
	register_setting( 'kls_scripts_section', 'kls_scripts_footer' );

	register_setting( 'kls_scripts_section', 'kls_script_selector' );
}
add_action( 'admin_init', 'kls_register_settings_scripts' );

/**
 * Create maintenance page settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_maintenance() {
	add_settings_field(
		'kls_maintenance_toggle',
		__( 'Toggle maintenance page', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_maintenance',
		'kls_maintenance_section',
		array(
			'label_for'   => 'kls_maintenance_toggle',
			'check_value' => 'on',
		)
	);

	add_settings_field( 'kls_maintenance_title', __( 'Page title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_maintenance', 'kls_maintenance_section', array( 'label_for' => 'kls_maintenance_title' ) );
	add_settings_field( 'kls_maintenance_text', __( 'Page text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_maintenance', 'kls_maintenance_section', array( 'label_for' => 'kls_maintenance_text' ) );
	add_settings_field(
		'kls_maintenance_background_select',
		__( 'Page background', KP_TXT_DOMAIN ),
		'kls_select_field',
		'kls_maintenance',
		'kls_maintenance_section',
		array(
			'label_for' => 'kls_maintenance_background_select',
			'class'     => 'select-choice',
			'selects'   => array(
				'Image',
				'Color',
				'Gradient',
			),
		)
	);

	add_settings_field(
		'kls_maintenance_background_image',
		__( 'Background image', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_maintenance',
		'kls_maintenance_section',
		array(
			'label_for'   => 'kls_maintenance_background_image',
			'class'       => 'select-row image',
			'button_text' => __(
				'Select image',
				KP_TXT_DOMAIN
			),
		)
	);
	add_settings_field(
		'kls_maintenance_background_color',
		__( 'Background color', KP_TXT_DOMAIN ),
		'kls_colorpicker_field',
		'kls_maintenance',
		'kls_maintenance_section',
		array(
			'label_for' => 'kls_maintenance_background_color',
			'class'     => 'select-row color',
		)
	);
	add_settings_field(
		'kls_maintenance_background_gradient',
		__( 'Background gradient', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_maintenance',
		'kls_maintenance_section',
		array(
			'label_for'   => 'kls_maintenance_background_gradient',
			'class'       => 'select-row gradient',
			'placeholder' => 'linear-gradient(90deg, rgba(2,0,36,1) 0%, rgba(0,212,255,1) 100%);',
			'info_text'   => __(
				'Generate a gradient using: <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a> and past everything behind background in the field.',
				KP_TXT_DOMAIN
			),
		)
	);

	add_settings_field(
		'kls_maintenance_customer_data_toggle',
		__( 'Toggle customer contact information', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_maintenance',
		'kls_maintenance_section',
		array(
			'label_for'   => 'kls_maintenance_customer_data_toggle',
			'check_value' => 'on',
		)
	);
}
add_action( 'admin_init', 'kls_create_settings_maintenance' );

/**
 * Register maintenance settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_maintenance() {
	register_setting( 'kls_maintenance_section', 'kls_maintenance_toggle' );

	register_setting( 'kls_maintenance_section', 'kls_maintenance_title' );
	register_setting( 'kls_maintenance_section', 'kls_maintenance_text' );
	register_setting( 'kls_maintenance_section', 'kls_maintenance_background_select' );

	register_setting( 'kls_maintenance_section', 'kls_maintenance_background_image' );
	register_setting( 'kls_maintenance_section', 'kls_maintenance_background_color' );
	register_setting( 'kls_maintenance_section', 'kls_maintenance_background_gradient' );

	register_setting( 'kls_maintenance_section', 'kls_maintenance_customer_data_toggle' );
}
add_action( 'admin_init', 'kls_register_settings_maintenance' );

/**
 * Create cookie settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_cookie() {
	add_settings_field( 'kls_cookie_title', __( 'Cookie notice title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie', 'kls_cookie_section', array( 'label_for' => 'kls_cookie_title' ) );
	add_settings_field( 'kls_cookie_text', __( 'Cookie notice text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_cookie', 'kls_cookie_section', array( 'label_for' => 'kls_cookie_text' ) );

	add_settings_field( 'kls_cookie_button_text', __( 'Button text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie', 'kls_cookie_section', array( 'label_for' => 'kls_cookie_button_text' ) );

	add_settings_field( 'kls_cookie_link_text', __( 'Cookie policy read more button text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie', 'kls_cookie_section', array( 'label_for' => 'kls_cookie_link_text' ) );
	if ( 'on' == get_option( 'kls_legacy_cookie_toggle' ) ) :
		add_settings_field(
			'kls_cookie_link_page',
			__( 'Cookie link page or link?', KP_TXT_DOMAIN ),
			'kls_toggle_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for'   => 'kls_cookie_link_page',
				'check_value' => 'on',
			)
		);

		if ( 'on' == get_option( 'kls_cookie_link_page' ) ) :
			add_settings_field(
				'kls_cookie_link',
				__('Cookie policy read more button link', KP_TXT_DOMAIN),
				'kls_text_field',
				'kls_cookie',
				'kls_cookie_section',
				array('label_for' => 'kls_cookie_link')
			);
		else:
			add_settings_field(
				'kls_cookie_link',
				__('Cookie policy read more button link', KP_TXT_DOMAIN),
				'kls_select_page_field',
				'kls_cookie',
				'kls_cookie_section',
				array(
					'label_for' => 'kls_cookie_link',
					'placeholder' => __(
						'/cookiestatement/',
						KP_TXT_DOMAIN
					),
				)
			);
		endif;
	endif;

	// Cookie styling.
	if ( wp_get_theme() == 'Klasse theme' || wp_get_theme() == 'Klasse Theme' || wp_get_theme() == 'Klasse child theme' || wp_get_theme() == 'Klasse Child Theme' ) :
		add_settings_field(
			'kls_cookie_button_styling',
			__( 'Change button styling methode', KP_TXT_DOMAIN ),
			'kls_select_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_button_styling',
				'class'     => 'select-choice',
				'selects'   => array(
					'custom',
					'theme',
				),
			)
		);
	endif;

	if ( 'on' == get_option( 'kls_legacy_cookie_toggle' ) ) :
		add_settings_field(
			'kls_cookie_button_color',
			__( 'Button text color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_button_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_button_background_color',
			__( 'Button background color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_button_background_color',
				'class'     => 'select-row custom',
			)
		);
	else :
		add_settings_field( 'kls_cookie_body_text_color', __( 'Body text color', KP_TXT_DOMAIN ), 'kls_colorpicker_field', 'kls_cookie_styling', 'kls_cookie_styling_section', array( 'label_for' => 'kls_cookie_body_text_color' ) );
		add_settings_field( 'kls_cookie_background_color', __( 'Background color', KP_TXT_DOMAIN ), 'kls_colorpicker_field', 'kls_cookie_styling', 'kls_cookie_styling_section', array( 'label_for' => 'kls_cookie_background_color' ) );
		add_settings_field( 'kls_cookie_table_background_color', __( 'Popup table background color', KP_TXT_DOMAIN ), 'kls_colorpicker_field', 'kls_cookie_styling', 'kls_cookie_styling_section', array( 'label_for' => 'kls_cookie_table_background_color' ) );
		add_settings_field(
			'kls_cookie_button_border_radius',
			__( 'Button border radius', KP_TXT_DOMAIN ),
			'kls_text_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_button_border_radius',
				'class'     => 'select-row custom',
			)
		);

		add_settings_field(
			'kls_cookie_styling_seperator_primary',
			__( 'Primary button', KP_TXT_DOMAIN ),
			'kls_seperator',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_styling_seperator_primary',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_primary_button_color',
			__( 'Primary button text color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_primary_button_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_primary_button_background_color',
			__( 'Primary button background color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_primary_button_background_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_primary_button_hover_color',
			__( 'Primary button text hover color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_primary_button_hover_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_primary_button_hover_background_color',
			__( 'Primary button hover background color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_primary_button_hover_background_color',
				'class'     => 'select-row custom',
			)
		);

		add_settings_field(
			'kls_cookie_styling_seperator_secundary',
			__( 'Secundary button', KP_TXT_DOMAIN ),
			'kls_seperator',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_styling_seperator_secundary',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_secundary_button_color',
			__( 'Secundary button text color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_secundary_button_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_secundary_button_background_color',
			__( 'Secundary button background color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_secundary_button_background_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_secundary_button_hover_color',
			__( 'Secundary button text hover color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_secundary_button_hover_color',
				'class'     => 'select-row custom',
			)
		);
		add_settings_field(
			'kls_cookie_secundary_button_hover_background_color',
			__( 'Secundary button hover background color', KP_TXT_DOMAIN ),
			'kls_colorpicker_field',
			'kls_cookie_styling',
			'kls_cookie_styling_section',
			array(
				'label_for' => 'kls_cookie_secundary_button_hover_background_color',
				'class'     => 'select-row custom',
			)
		);
	endif;

	// Cookie settings.
	add_settings_field(
		'kls_cookie_toggle',
		__( 'Toggle cookie notice', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_cookie_settings',
		'kls_cookie_settings_section',
		array(
			'label_for'   => 'kls_cookie_toggle',
			'check_value' => 'on',
		)
	);

	if ( ! 'on' == get_option( 'kls_legacy_cookie_toggle' ) ) :
		add_settings_field(
			'kls_cookie_consentlog_toggle',
			__( 'Toggle the cookie consent log', KP_TXT_DOMAIN ),
			'kls_toggle_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for'   => 'kls_cookie_consentlog_toggle',
				'check_value' => 'on',
			)
		);

		add_settings_field( 'kls_cookie_expiration', __( 'Cookie expiration time in days', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_settings', 'kls_cookie_settings_section', array( 'label_for' => 'kls_cookie_expiration' ) );

		add_settings_field(
			'kls_cookie_bar_styling',
			__( 'Change cookie bar styling', KP_TXT_DOMAIN ),
			'kls_select_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for' => 'kls_cookie_bar_styling',
				'selects'   => array(
					'box',
					'cloud',
					'bar',
				),
			)
		);

		add_settings_field(
			'kls_cookie_bar_location_horizontal',
			__( 'Horizontal position', KP_TXT_DOMAIN ),
			'kls_select_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for' => 'kls_cookie_bar_location_horizontal',
				'selects'   => array(
					'left',
					'center',
					'right',
				),
			)
		);

		add_settings_field(
			'kls_cookie_bar_location_vertical',
			__( 'Vertical position', KP_TXT_DOMAIN ),
			'kls_select_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for' => 'kls_cookie_bar_location_vertical',
				'selects'   => array(
					'top',
					'middle',
					'bottom',
				),
			)
		);

		add_settings_field(
			'kls_cookie_bar_transition',
			__( 'Transition', KP_TXT_DOMAIN ),
			'kls_select_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for' => 'kls_cookie_bar_transition',
				'selects'   => array(
					'zoom',
					'slide',
				),
			)
		);

		add_settings_field(
			'kls_cookie_analytics_enabled',
			__('Toggle analytics default on', KP_TXT_DOMAIN),
			'kls_toggle_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for' => 'kls_cookie_analytics_enabled',
				'check_value' => 'on',
			)
		);

		add_settings_field(
			'kls_cookie_marketing_enabled',
			__('Toggle marketing default on', KP_TXT_DOMAIN),
			'kls_toggle_field',
			'kls_cookie_settings',
			'kls_cookie_settings_section',
			array(
				'label_for' => 'kls_cookie_marketing_enabled',
				'check_value' => 'on',
			)
		);
	endif;

	// Cookie popup settings.
	add_settings_field( 'kls_cookie_popup_title', __( 'Cookie notice popup title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_title' ) );

	add_settings_field( 'kls_cookie_popup_seperator_1', __( 'Popup introduction', KP_TXT_DOMAIN ), 'kls_seperator', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_seperator_1' ) );

	add_settings_field( 'kls_cookie_popup_intro_title', __( 'Cookie notice popup introduction title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_intro_title' ) );
	add_settings_field( 'kls_cookie_popup_intro_text', __( 'Cookie notice popup introduction text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_intro_text' ) );

	add_settings_field( 'kls_cookie_popup_seperator_2', __( 'Necessary section', KP_TXT_DOMAIN ), 'kls_seperator', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_seperator_2' ) );

	add_settings_field( 'kls_cookie_popup_necessary_title', __( 'Cookie notice popup necessary title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_necessary_title' ) );
	add_settings_field( 'kls_cookie_popup_necessary_text', __( 'Cookie notice popup necessary text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_necessary_text' ) );

	add_settings_field( 'kls_cookie_popup_seperator_3', __( 'Analytics section', KP_TXT_DOMAIN ), 'kls_seperator', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_seperator_3' ) );

	add_settings_field( 'kls_cookie_popup_analytics_title', __( 'Cookie notice popup analytics title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_analytics_title' ) );
	add_settings_field( 'kls_cookie_popup_analytics_text', __( 'Cookie notice popup analytics text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_analytics_text' ) );

	add_settings_field( 'kls_cookie_popup_seperator_4', __( 'Marketing section', KP_TXT_DOMAIN ), 'kls_seperator', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_seperator_4' ) );

	add_settings_field( 'kls_cookie_popup_marketing_title', __( 'Cookie notice popup marketing title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_marketing_title' ) );
	add_settings_field( 'kls_cookie_popup_marketing_text', __( 'Cookie notice popup marketing text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_marketing_text' ) );

	add_settings_field( 'kls_cookie_popup_seperator_5', __( 'More information section', KP_TXT_DOMAIN ), 'kls_seperator', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_seperator_5' ) );
	add_settings_field(
		'kls_cookie_popup_more_info_toggle',
		__( 'Toggle the more information section', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_cookie_popup_text',
		'kls_cookie_popup_text_section',
		array(
			'label_for'   => 'kls_cookie_popup_more_info_toggle',
			'check_value' => 'on',
		)
	);

	add_settings_field( 'kls_cookie_popup_more_info_title', __( 'Cookie notice popup more info title', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_more_info_title' ) );
	add_settings_field( 'kls_cookie_popup_more_info_text', __( 'Cookie notice popup more info text', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_more_info_text' ) );

	add_settings_field( 'kls_cookie_popup_seperator_6', __( 'Buttons text', KP_TXT_DOMAIN ), 'kls_seperator', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_seperator_6' ) );

	add_settings_field( 'kls_cookie_popup_accept_all_text', __( 'Cookie notice popup accept all text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_accept_all_text' ) );
	add_settings_field( 'kls_cookie_popup_reject_all_text', __( 'Cookie notice popup reject all text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_reject_all_text' ) );
	add_settings_field( 'kls_cookie_popup_save_settings_text', __( 'Cookie notice popup save settings text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_cookie_popup_text', 'kls_cookie_popup_text_section', array( 'label_for' => 'kls_cookie_popup_save_settings_text' ) );

}
add_action( 'admin_init', 'kls_create_settings_cookie' );

/**
 * Register cookie settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_cookie() {
	register_setting( 'kls_cookie_section', 'kls_cookie_title' );
	register_setting( 'kls_cookie_section', 'kls_cookie_text' );
	register_setting( 'kls_cookie_section', 'kls_cookie_button_text' );

	register_setting( 'kls_cookie_section', 'kls_cookie_link_text' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_link_page' );
	register_setting( 'kls_cookie_section', 'kls_cookie_link');

	register_setting( 'kls_cookie_styling_section', 'kls_cookie_button_styling' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_body_text_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_background_color' );

	register_setting( 'kls_cookie_styling_section', 'kls_cookie_button_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_button_background_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_table_background_color' );

	register_setting( 'kls_cookie_styling_section', 'kls_cookie_button_border_radius' );

	register_setting( 'kls_cookie_styling_section', 'kls_cookie_primary_button_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_primary_button_background_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_primary_button_hover_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_primary_button_hover_background_color' );

	register_setting( 'kls_cookie_styling_section', 'kls_cookie_secundary_button_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_secundary_button_background_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_secundary_button_hover_color' );
	register_setting( 'kls_cookie_styling_section', 'kls_cookie_secundary_button_hover_background_color' );

	register_setting( 'kls_cookie_settings_section', 'kls_cookie_toggle' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_consentlog_toggle' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_bar_styling' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_expiration' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_bar_location_horizontal' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_bar_location_vertical' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_bar_transition' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_analytics_enabled' );
	register_setting( 'kls_cookie_settings_section', 'kls_cookie_marketing_enabled' );

	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_title' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_intro_title' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_intro_text' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_necessary_title' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_necessary_text' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_analytics_title' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_analytics_text' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_marketing_title' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_marketing_text' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_more_info_toggle' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_more_info_title' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_more_info_text' );

	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_accept_all_text' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_reject_all_text' );
	register_setting( 'kls_cookie_popup_text_section', 'kls_cookie_popup_save_settings_text' );
}
add_action( 'admin_init', 'kls_register_settings_cookie' );

/**
 * Create speed settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_speed() {
	add_settings_field(
		'kls_speed_toggle',
		__( 'Toggle speed optimization', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_speed_settings',
		'kls_speed_settings_section',
		array(
			'label_for'   => 'kls_speed_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field( 'kls_dequeue_styles', __( 'Dequeue styles for the homepage', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_speed_settings', 'kls_speed_settings_section', array( 'label_for' => 'kls_dequeue_styles' ) );
	add_settings_field( 'kls_dequeue_scripts', __( 'Dequeue scripts for the homepage', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_speed_settings', 'kls_speed_settings_section', array( 'label_for' => 'kls_dequeue_scripts' ) );
	add_settings_field( 'kls_front_page_css', __( 'Insert critical path css for the homepage', KP_TXT_DOMAIN ), 'kls_textarea_field', 'kls_speed_settings', 'kls_speed_settings_section', array( 'label_for' => 'kls_front_page_css' ) );
	add_settings_field( 'kls_wp_rocket_preload_interval', __( 'Set custom WP Rocket preload interval per page in MS', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_speed_settings', 'kls_speed_settings_section', array( 'label_for' => 'kls_wp_rocket_preload_interval' ) );
}
add_action( 'admin_init', 'kls_create_settings_speed' );

/**
 * Register speed settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_speed() {
	register_setting( 'kls_speed_settings_section', 'kls_speed_toggle' );
	register_setting( 'kls_speed_settings_section', 'kls_dequeue_styles', array( 'default' => 'wp-block-library, dashicons' ) );
	register_setting( 'kls_speed_settings_section', 'kls_dequeue_scripts' );
	register_setting( 'kls_speed_settings_section', 'kls_front_page_css' );
	register_setting( 'kls_speed_settings_section', 'kls_wp_rocket_preload_interval' );
}
add_action( 'admin_init', 'kls_register_settings_speed' );

/**
 * Create woocommerce settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_woocommerce() {
	add_settings_field(
		'kls_from_price_range',
		__( 'Toggle "From" to products with price range', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_woocommerce',
		'kls_woocommerce_settings_section',
		array(
			'label_for'   => 'kls_from_price_range',
			'check_value' => 'on',
		)
	);
	add_settings_field( 'kls_price_range_text', __( 'Price range "from" text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_woocommerce', 'kls_woocommerce_settings_section', array( 'label_for' => 'kls_price_range_text' ) );

	add_settings_field( 'kls_couponcode_text', __( 'Couponcode text', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_woocommerce', 'kls_woocommerce_settings_section', array( 'label_for' => 'kls_couponcode_text' ) );

	add_settings_field(
		'kls_hide_shipping_when_free',
		__( 'Hide shipping methodes when free or local pickup is available', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_woocommerce',
		'kls_woocommerce_settings_section',
		array(
			'label_for'   => 'kls_hide_shipping_when_free',
			'check_value' => 'on',
		)
	);

	add_settings_field( 'kls_woocommerce_usp_1', __( 'WooCommerce usp 1', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_woocommerce', 'kls_woocommerce_settings_section', array( 'label_for' => 'kls_woocommerce_usp_1' ) );
	add_settings_field( 'kls_woocommerce_usp_2', __( 'WooCommerce usp 2', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_woocommerce', 'kls_woocommerce_settings_section', array( 'label_for' => 'kls_woocommerce_usp_2' ) );
	add_settings_field( 'kls_woocommerce_usp_3', __( 'WooCommerce usp 3', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_woocommerce', 'kls_woocommerce_settings_section', array( 'label_for' => 'kls_woocommerce_usp_3' ) );
	add_settings_field( 'kls_woocommerce_usp_4', __( 'WooCommerce usp 4', KP_TXT_DOMAIN ), 'kls_text_field', 'kls_woocommerce', 'kls_woocommerce_settings_section', array( 'label_for' => 'kls_woocommerce_usp_4' ) );

}
add_action( 'admin_init', 'kls_create_settings_woocommerce' );

/**
 * Register woocommerce settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_woocommerce() {
	register_setting( 'kls_woocommerce_settings_section', 'kls_from_price_range' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_price_range_text' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_couponcode_text' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_hide_shipping_when_free' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_woocommerce_usp_1' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_woocommerce_usp_2' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_woocommerce_usp_3' );
	register_setting( 'kls_woocommerce_settings_section', 'kls_woocommerce_usp_4' );
}
add_action( 'admin_init', 'kls_register_settings_woocommerce' );

/**
 * Create settings page settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_settings_page() {
	add_settings_field(
		'kls_updates_toggle',
		__( 'Toggle updates', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_updates_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_webshop_toggle',
		__( 'Toggle webshop functions', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_webshop_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_user_tracking_toggle',
		__('Toggle usage tracking', KP_TXT_DOMAIN),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for' => 'kls_user_tracking_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_wordpress_standard_toggle',
		__( 'Toggle standard WordPress functions', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_wordpress_standard_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_debug_toggle',
		__( 'Toggle debug mode', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_debug_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_dashboard_clean_up_toggle',
		__( 'Cleanup WordPress dashboard', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_dashboard_clean_up_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_toggle_font_awesome',
		__( 'Toggle Font Awesome', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_toggle_font_awesome',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_toggle_anytime_integration',
		__( 'Toggle Anytime Fitness integration', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_toggle_anytime_integration',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_toggle_anytime_presale_integration',
		__( 'Toggle Anytime Fitness Presale integration', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings',
		'kls_settings_section',
		array(
			'label_for'   => 'kls_toggle_anytime_presale_integration',
			'check_value' => 'on',
		)
	);

	add_settings_field(
		'kls_legacy_cookie_toggle',
		__( 'Toggle legacy cookie notice', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings_legacy',
		'kls_settings_legacy_section',
		array(
			'label_for'   => 'kls_legacy_cookie_toggle',
			'check_value' => 'on',
		)
	);

	add_settings_field(
		'kls_legacy_scripts_toggle',
		__( 'Toggle legacy scripts & tracking view', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_settings_legacy',
		'kls_settings_legacy_section',
		array(
			'label_for'   => 'kls_legacy_scripts_toggle',
			'check_value' => 'on',
		)
	);
}
add_action( 'admin_init', 'kls_create_settings_settings_page' );

/**
 * Register settings page settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_settings_page() {
	register_setting( 'kls_settings_section', 'kls_updates_toggle' );
	register_setting( 'kls_settings_section', 'kls_webshop_toggle' );
	register_setting( 'kls_settings_section', 'kls_user_tracking_toggle' );
	register_setting( 'kls_settings_section', 'kls_wordpress_standard_toggle' );
	register_setting( 'kls_settings_section', 'kls_debug_toggle' );
	register_setting( 'kls_settings_section', 'kls_dashboard_clean_up_toggle' );
	register_setting( 'kls_settings_section', 'kls_toggle_font_awesome' );
	register_setting( 'kls_settings_section', 'kls_toggle_anytime_integration' );
	register_setting( 'kls_settings_section', 'kls_toggle_anytime_presale_integration' );

	register_setting( 'kls_settings_legacy_section', 'kls_legacy_cookie_toggle' );
	register_setting( 'kls_settings_legacy_section', 'kls_legacy_scripts_toggle' );
}
add_action( 'admin_init', 'kls_register_settings_settings_page' );

/**
 * Create admin settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_settings_admin() {
	add_settings_field(
		'kls_admin_select',
		__( 'Select a whitelabel', KP_TXT_DOMAIN ),
		'kls_select_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_select',
			'class'     => 'select-choice',
			'selects'   => array(
				'Klasse B.V.',
				'Totstraksonline.nl',
				'Websitexperts',
				'Fitleads',
				'Novaleads',
				'SyncSilo',
				'Werbeland',
				'Linkbuilding Marketing',
				'other',
			),
		)
	);

	add_settings_field(
		'kls_admin_logo',
		__( 'Admin logo', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for'   => 'kls_admin_logo',
			'button_text' => __( 'Upload logo', KP_TXT_DOMAIN ),
			'class'       => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_favicon',
		__( 'Admin favicon', KP_TXT_DOMAIN ),
		'kls_image_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for'   => 'kls_admin_favicon',
			'button_text' => __( 'Upload logo', KP_TXT_DOMAIN ),
			'class'       => 'select-row other',
		)
	);

	add_settings_field(
		'kls_admin_name',
		__( 'Admin name', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_name',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_email',
		__( 'Admin email', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_email',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_phone',
		__( 'Admin phone', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_phone',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_website',
		__( 'Admin website', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_website',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_street',
		__( 'Admin street', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_street',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_postal_code',
		__( 'Admin postal code', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_postal_code',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_city',
		__( 'Admin city', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_city',
			'class'     => 'select-row other',
		)
	);
	add_settings_field(
		'kls_admin_country',
		__( 'Admin country', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for' => 'kls_admin_country',
			'class'     => 'select-row other',
		)
	);

	add_settings_field(
		'kls_beta_updates_toggle',
		__( 'Toggle beta updates', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for'   => 'kls_beta_updates_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_deinstallation_toggle',
		__( 'Toggle deinstallation', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_admin_settings',
		'kls_admin_settings_section',
		array(
			'label_for'   => 'kls_deinstallation_toggle',
			'check_value' => 'on',
		)
	);
}
add_action( 'admin_init', 'kls_create_settings_admin' );

/**
 * Register admin settings
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_settings_admin() {
	register_setting( 'kls_admin_settings_section', 'kls_admin_select' );

	register_setting( 'kls_admin_settings_section', 'kls_admin_logo' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_favicon' );

	register_setting( 'kls_admin_settings_section', 'kls_admin_name' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_email' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_phone' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_website' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_street' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_postal_code' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_city' );
	register_setting( 'kls_admin_settings_section', 'kls_admin_country' );

	register_setting( 'kls_admin_settings_section', 'kls_beta_updates_toggle' );
	register_setting( 'kls_admin_settings_section', 'kls_deinstallation_toggle' );
}
add_action( 'admin_init', 'kls_register_settings_admin' );

/**
 * Create security page settings
 *
 * @since 0.0.06
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_security_settings_page() {
	add_settings_field(
		'kls_security_toggle',
		__( 'Toggle security optimization', KP_TXT_DOMAIN ),
		'kls_toggle_field',
		'kls_security',
		'kls_security_section',
		array(
			'label_for'   => 'kls_security_toggle',
			'check_value' => 'on',
		)
	);
	add_settings_field(
		'kls_security_trusted_ips',
		__( 'Trusted IPs', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_security',
		'kls_security_section',
		array(
			'label_for' => 'kls_security_trusted_ips',
			'class'     => 'kls-hidden',
		)
	);
}
add_action( 'admin_init', 'kls_create_security_settings_page' );

/**
 * Register security page settings
 *
 * @since 0.0.06
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_security_settings_page() {
	register_setting( 'kls_security_section', 'kls_security_toggle' );
	register_setting( 'kls_security_section', 'kls_security_trusted_ips' );
}
add_action( 'admin_init', 'kls_register_security_settings_page' );

/**
 * Create security page settings
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_api_settings_page() {
	add_settings_field(
		'kls_api_key',
		__( 'Toggle security optimization', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_api',
		'kls_api_section',
		array(
			'label_for' => 'kls_api_key',
			'disabled'  => 'disabled',
			'class'     => 'kls-hidden',
		)
	);
	add_settings_field(
		'kls_api_last_change',
		__( 'Last api key changed', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_api',
		'kls_api_section',
		array(
			'label_for' => 'kls_api_last_change',
			'disabled'  => 'disabled',
			'class'     => 'kls-hidden',
		)
	);
	add_settings_field(
		'kls_api_last_connection',
		__( 'Last connection', KP_TXT_DOMAIN ),
		'kls_text_field',
		'kls_api',
		'kls_api_section',
		array(
			'label_for' => 'kls_api_last_connection',
			'disabled'  => 'disabled',
			'class'     => 'kls-hidden',
		)
	);
}
add_action( 'admin_init', 'kls_create_api_settings_page' );

/**
 * Register security page settings
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_api_settings_page() {
	register_setting( 'kls_api_section', 'kls_api_key' );
	register_setting( 'kls_api_section', 'kls_api_last_change' );
	register_setting( 'kls_api_section', 'kls_api_last_connection' );
}
add_action( 'admin_init', 'kls_register_api_settings_page' );

/**
 * Create section callbacks
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_section_cb_empty() { }

/**
 * Require all the field callbacks
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/field_callbacks.php';
