<?php

/**
 *
 *
 * @package KlassePlugin
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.77
 */

/**
 * Import json
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.77
 *
 * @return Creates
 */
function kls_import_json() {
	$options_toggle = $_POST['kls_plugin_options'];
	$mods_toggle    = $_POST['kls_theme_mods'];
	$data           = $_POST['kls_import_json'];
	$data           = stripslashes( $data );
	$data           = json_decode( $data );

	foreach ( $data as $d ) :
		// Klasse options
		if ( $options_toggle == 'on' && substr_compare( $d, 'kls_option_data', 0, strlen( 'kls_option_data' ) ) === 0 ) : // Check the string for kls_option_data.
			$d = explode( '|', $d );

			if ( substr_compare( $d[1], 'kls_', 0, strlen( 'kls_' ) ) === 0 ) : // Check if the string has kls_ to prevent other options from being updatet.
				if ( $d[2] > null ) : // Don't update values that are null.
					update_option( $d[1], $d[2] );
				endif;
			else : // Abort if not a Klasse option.
				wp_redirect( admin_url( 'admin.php?page=kls_tools_page' ) );
				kls_admin_notice( __( 'You tried to update an option that is not correct. Check your Json data.', KP_TXT_DOMAIN ), 'warning', true );
				die();
			endif;
			// Klasse theme mods
		elseif ( $mods_toggle == 'on' && substr_compare( $d, 'kls_mod_data', 0, strlen( 'kls_mod_data' ) ) === 0 ) :
			$d = explode( '|', $d );

			if ( substr_compare( $d[0], 'kls_', 0, strlen( 'kls_' ) ) === 0 ) : // Check if the string has kls_ to prevent other options from being updatet.
				if ( $d[2] > null ) : // Don't update values that are null.
					set_theme_mod( $d[1], $d[2] );
				endif;
			else : // Abort if not a Klasse option.
				wp_redirect( admin_url( 'admin.php?page=kls_tools_page' ) );
				kls_admin_notice( __( 'You tried to update an option that is not correct. Check your Json data.', KP_TXT_DOMAIN ), 'warning', true );
				die();
			endif;
		endif;
	endforeach;

	// Redirect to the tools page
	wp_redirect( admin_url( 'admin.php?page=kls_tools_page' ) );
	kls_admin_notice( __( 'All settings have been imported', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_import_settings', 'kls_import_json' );
