<?php

/**
 * Update the htaccess trusted ips
 *
 * @since 0.0.51
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_update_htaccess_trusted_ips( $htaccess_content ) {
	 $htaccess_file = get_home_path() . '.htaccess';

	insert_with_markers( $htaccess_file, 'Klasse B.V. trusted ips', (array) $htaccess_content );

	// Redirect and admin notice.
	wp_redirect( admin_url( 'admin.php?page=kls_security' ) );
	kls_admin_notice( __( 'All trusted ips have been removed!', KP_TXT_DOMAIN ), 'success', true );
}

/**
 * Add trusted IP's to the htaccess
 *
 * @since 0.0.51
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_add_trusted_ips() {
	// Update the security option.
	$trusted_ips = $_REQUEST['kls_trusted_ips'];

	$trusted_ips = implode( ',', array_unique( explode( ',', $trusted_ips ) ) );
	$trusted_ips = rtrim( $trusted_ips, ',' );
	$trusted_ips = ltrim( $trusted_ips, ',' );

	update_option( 'kls_security_trusted_ips', $trusted_ips );

	$htaccess_content[] = '<IfModule Litespeed>Trusted:' . get_option( 'kls_security_trusted_ips' ) . '</IfModule>';

	kls_update_htaccess_trusted_ips( $htaccess_content );

	// Redirect and admin notice.
	wp_redirect( admin_url( 'admin.php?page=kls_security' ) );
	kls_admin_notice( __( 'Trusted IPs has been updated!', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_add_trusted_ips', 'kls_add_trusted_ips' );

/**
 * Remove trusted IP's from the htaccess
 *
 * @since 0.0.51
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_flush_trusted_ips() {
	update_option( 'kls_security_trusted_ips', '' );

	kls_update_htaccess_trusted_ips( '' );

	// Redirect and admin notice.
	wp_redirect( admin_url( 'admin.php?page=kls_security' ) );
	kls_admin_notice( __( 'All trusted ips have been removed!', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_flush_trusted_ips', 'kls_flush_trusted_ips' );

/**
 * Update the htaccess
 *
 * @since 0.0.51
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_update_htaccess( $htaccess_content ) {
	 $htaccess_file = get_home_path() . '.htaccess';

	insert_with_markers( $htaccess_file, 'Klasse B.V. standard htaccess data', (array) $htaccess_content );

	// Redirect and admin notice.
	wp_redirect( admin_url( 'admin.php?page=kls_security' ) );
	kls_admin_notice( __( 'All trusted ips have been removed!', KP_TXT_DOMAIN ), 'success', true );
}

/**
 * Add standard http to https redirect
 *
 * @since 0.0.54
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_add_http_redirect() {
	$htaccess_content = '
    RewriteEngine On
    RewriteCond %{HTTPS} off
    RewriteRule (.*) https://%{HTTP_HOST}%{REQUEST_URI} [R=301,L]
    ';

	kls_update_htaccess( $htaccess_content );

	// Redirect and admin notice.
	wp_redirect( admin_url( 'admin.php?page=kls_security' ) );
	kls_admin_notice( __( 'Added http to https redirect to the htaccess!', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_add_http_redirect', 'kls_add_http_redirect' );
