<?php
/**
 * Create text field callback
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_text_field($args)
{
	$field_name = $args['label_for'];
	$options = get_option($field_name);
	?>
	<input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $options; ?>" <?php
			 if (isset($args['placeholder'])) {
				 $placeholder = $args['placeholder'];
				 ?> placeholder="<?php echo $placeholder; ?>" <?php
			 }
			 ;
			 ?> 	<?php
				  if (isset($args['disabled'])) {
					  ?> disabled <?php
				  }
				  ;
				  ?> class="kls_input kls_text_field" />

	<?php
	if (isset($args['info_text'])) {
		$info_text = $args['info_text'];

		?>
		<div class="tooltip-highlight"><span class="tooltip-icon"></span><span class="tooltip-text">
				<?php echo $info_text; ?>
			</span></div>
		<?php
	}
}

/**
 * Create email field callback
 *
 * @since 0.0.82
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_email_field($args)
{
	$field_name = $args['label_for'];
	$options = get_option($field_name);
	?>
	<input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $options; ?>" <?php
			 if (isset($args['placeholder'])) {
				 $placeholder = $args['placeholder'];
				 ?> placeholder="<?php echo $placeholder; ?>" <?php
			 }
			 ;

			 if (isset($args['disabled'])) {
				 ?> disabled <?php
			 }
			 ;
			 ?> class="kls_input kls_text_field" />

	<?php
	if (isset($args['info_text'])) {
		$info_text = $args['info_text'];
		?>
		<div class="tooltip-highlight"><span class="tooltip-icon"></span><span class="tooltip-text">
				<?php echo $info_text; ?>
			</span></div>
		<?php
	}
}

/**
 * Create textarea field callback
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_textarea_field($args)
{
	$field_name = $args['label_for'];
	$options = get_option($field_name);

	?>
	<textarea type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" class="kls_textarea"><?php echo $options; ?></textarea>
	<?php
	if (isset($args['info_text'])) {
		$info_text = $args['info_text'];

		?>
		<div class="tooltip-highlight"><span class="tooltip-icon"></span><span class="tooltip-text">
				<?php echo $info_text; ?>
			</span></div>
		<?php
	}
}

/**
 * Create select field callback
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_select_field($args)
{
	$field_name = $args['label_for'];
	$select_options = $args['selects'];
	$options = get_option($field_name);
	?>

	<select id='<?php echo $field_name; ?>' name='<?php echo $field_name; ?>' class="kls_input kls_select">
		<?php
		foreach ($select_options as $select_option) {
			$selected = ($options == $select_option) ? 'selected="selected"' : '';
			?>
			<option value='<?php echo $select_option; ?>' <?php echo $selected; ?>>
				<?php _e($select_option); ?>
			</option>
		<?php } ?>
	</select>
	<?php
	if (isset($args['info_text'])) {
		$info_text = $args['info_text'];

		?>
		<div class="tooltip-highlight"><span class="tooltip-icon"></span><span class="tooltip-text">
				<?php echo $info_text; ?>
			</span></div>
		<?php
	}
}

/**
 * Create toggle field
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_toggle_field($args)
{
	$field_name = $args['label_for'];
	$check_value = $args['check_value'];
	$options = get_option($field_name);

	$checked = ($options == true) ? 'checked' : '';
	?>
	<label for="<?php echo $field_name; ?>" class="kls_toggle">
		<input <?php echo $checked; ?> type="checkbox" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $check_value; ?>" />
		<span class="slider"></span>
	</label>
	<?php
	if (isset($args['info_text'])) {
		$info_text = $args['info_text'];

		?>
		<div class="tooltip-highlight"><span class="tooltip-icon"></span><span class="tooltip-text">
				<?php echo $info_text; ?>
			</span></div>
		<?php
	}
}

/**
 * Create color picker callback
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_colorpicker_field($args)
{
	$field_name = $args['label_for'];
	$options = get_option($field_name);

	?>
	<input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" value="<?php echo $options; ?>" class="color-picker" data-alpha-enabled="true" data-default-color="#ffffff" />
	<?php

	wp_enqueue_style('wp-color-picker');
	wp_register_script('wp-color-picker-alpha', KP_ASSETS_PATH . 'build/admin/wp-color-picker-alpha.js', array('wp-color-picker'));
	wp_add_inline_script(
		'wp-color-picker-alpha',
		'jQuery( function() { jQuery( ".color-picker" ).wpColorPicker(); } );'
	);
	wp_enqueue_script('wp-color-picker-alpha');
}

/**
 * Create select field callback
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_select_page_field($args)
{
	$field_name = $args['label_for'];
	$options = get_option($field_name);
	?>

	<select id='<?php echo $field_name; ?>' name='<?php echo $field_name; ?>' class="kls_input kls_select">
		<option value=''>None</option>
		<?php
		$pages = get_pages();
		if ($pages = get_pages()) {
			foreach ($pages as $page) {
				$pageID = $page->ID;
				$selected = ($options == $pageID) ? 'selected="selected"' : '';
				?>
				<option value='<?php echo $pageID; ?>' <?php echo $selected; ?>>
					<?php echo $page->post_title; ?>
				</option>
				<?php
			}
		}
		;
		?>

	</select>
	<?php
}

/**
 * Create image field callback
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_image_field($args)
{
	$field_name = $args['label_for'];
	$button_text = $args['button_text'];
	$options = get_option($field_name);

	$image = wp_get_attachment_image_src($options, 'thumbnail');

	wp_enqueue_media();

	?>
	<div class='image-preview-wrapper'>
		<img id='image-preview<?php echo $field_name; ?>' src='<?php echo $image[0]; ?>' width='100' height='100' style='max-height: 100px; width: 100px;'>
	</div>
	<input id="upload_image_button<?php echo $field_name; ?>" type="button" class="button" value="<?php echo $button_text; ?>" />
	<input type='hidden' name='<?php echo $field_name; ?>' id='<?php echo $field_name; ?>' value='<?php echo $options; ?>'>
	<?php

	// Image media gallery script
	$my_saved_attachment_post_id = get_option('media_selector_attachment_id', 0);

	?>
	<script type='text/javascript'>

		jQuery(document).ready(function ($) {

			// Uploading files
			var file_frame;
			var wp_media_post_id = wp.media.model.settings.post.id; // Store the old id
			var set_to_post_id = <?php echo $my_saved_attachment_post_id; ?>; // Set this

			jQuery('#upload_image_button<?php echo $field_name; ?>').on('click', function (event) {

				event.preventDefault();

				// If the media frame already exists, reopen it.
				if (file_frame) {
					// Set the post ID to what we want
					file_frame.uploader.uploader.param('post_id', set_to_post_id);
					// Open frame
					file_frame.open();
					return;
				} else {
					// Set the wp.media post id so the uploader grabs the ID we want when initialised
					wp.media.model.settings.post.id = set_to_post_id;
				}

				// Create the media frame.
				file_frame = wp.media.frames.file_frame = wp.media({
					title: 'Select a image to upload',
					button: {
						text: 'Use this image',
					},
					multiple: false    // Set to true to allow multiple files to be selected
				});

				// When an image is selected, run a callback.
				file_frame.on('select', function () {
					// We set multiple to false so only get one image from the uploader
					attachment = file_frame.state().get('selection').first().toJSON();

					// Do something with attachment.id and/or attachment.url here
					$('#image-preview<?php echo $field_name; ?>').attr('src', attachment.url).css('width', 'auto');
					$('#<?php echo $field_name; ?>').val(attachment.id);

					// Restore the main post ID
					wp.media.model.settings.post.id = wp_media_post_id;
				});

				// Finally, open the modal
				file_frame.open();
			});

			// Restore the main ID when the add media button is pressed
			jQuery('a.add_media').on('click', function () {
				wp.media.model.settings.post.id = wp_media_post_id;
			});
		});

	</script>
	<?php
}

/**
 * File upload
 *
 * @since 0.0.67
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_simple_file_upload($args)
{
	$field_name = $args['label_for'];
	$button_text = $args['button_text'];
	$option = get_option($field_name);

	wp_enqueue_media();
	?>
	<input id="upload_image" type="text" class="kls_input kls_text_field" name="<?php echo $field_name; ?>" value="<?php echo $option; ?>" />
	<input id="upload_file_button" class="button kls-button button button-secundary" type="button" value="<?php echo $button_text; ?>" />

	<script>
		jQuery(document).ready(function ($) {
			var custom_uploader;
			$('#upload_file_button').click(function (e) {
				e.preventDefault();
				//If the uploader object has already been created, reopen the dialog
				if (custom_uploader) {
					custom_uploader.open();
					return;
				}
				//Extend the wp.media object
				custom_uploader = wp.media.frames.file_frame = wp.media({
					title: 'Select document',
					button: {
						text: 'Select document'
					},
					multiple: false
				});
				//When a file is selected, grab the URL and set it as the text field's value
				custom_uploader.on('select', function () {
					attachment = custom_uploader.state().get('selection').first().toJSON();
					$('#upload_image').val(attachment.url);
				});
				//Open the uploader dialog
				custom_uploader.open();
			});
		});
	</script>
	<?php
}

/**
 * Seperator
 *
 * @since 0.0.93
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_seperator($args)
{
	?>
	<hr>
	<?php
}

/**
 * Scripts callback
 *
 * @param array $args Array of the passed arguments.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.93
 *
 * Todo, add an option to exclude the script on specific posts.
 * Todo, after deletion it should add a 0 script.
 * Todo, when the option is empty it should add a 0 script instead of showing an error.
 */
function klsScriptsSelector($args)
{
	$field_name = $args['label_for'];
	$check_value = $args['check_value'];
	$options = get_option($field_name);

	echo '<div class="kls-scripts-container">';

	foreach ($options as $key => $value) {
		$checked = (isset($value['toggle']) && true == $value['toggle']) ? 'checked' : '';
		?>
		<div class="kls-scripts-item" data-setting-id="<?php echo esc_html($key); ?>">
			<div class="kls-scripts-toggle-title">
				<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][toggle]" class="kls_toggle" title="<?php esc_html_e('Toggle the script', KP_TXT_DOMAIN); ?>">
					<input <?php echo esc_attr($checked); ?> type="checkbox" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][toggle]" id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][toggle]" value="<?php echo esc_attr($check_value); ?>" />
					<span class="slider"></span>
				</label>
				<span class="kls-scripts-title">
					<?php echo esc_html($value['title']); ?>
				</span>
				<?php
				if ('shortcode' == $value['location']) {
					$shortcode_name = strtolower(preg_replace('/[^a-zA-Z0-9\']/', '_', $value['title']));
					$shortcode_name = rtrim($shortcode_name, '_');
					?>
					<div class="tooltip-highlight"><span class="tooltip-icon"></span><span class="tooltip-text">Shortcode: <code>[custom_script name="<?php echo esc_html($shortcode_name); ?>"]</code></span></div>
					<?php
				}
				?>
				<div class="kls-toggle-accordion">
					<i class="fas fa-chevron-down"></i>
				</div>
			</div>
			<div class="kls-scripts-toggle-content">
				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][title]" class="kls-label">
						<?php esc_html_e('Script title', KP_TXT_DOMAIN); ?>
					</label>
					<input type="text" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][title]" id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][title]" value="<?php echo esc_html($value['title']); ?>" class="kls_input kls_text_field" required />
				</div>

				<div class="kls-option-container kls-option-container-half ">
					<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][cookie_category]" class="kls-label">
						<?php esc_html_e('Script cookie category', KP_TXT_DOMAIN); ?>
					</label>
					<select id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][cookie_category]" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][cookie_category]" class="kls_input kls_select">
						<option value="necessary" <?php echo 'necessary' == $value['cookie_category'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Necessary', KP_TXT_DOMAIN); ?>
						</option>
						<option value="analytics" <?php echo 'analytics' == $value['cookie_category'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Analytics', KP_TXT_DOMAIN); ?>
						</option>
						<option value="marketing" <?php echo 'marketing' == $value['cookie_category'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Marketing', KP_TXT_DOMAIN); ?>
						</option>
						<option value="none" <?php echo 'none' == $value['cookie_category'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('None', KP_TXT_DOMAIN); ?>
						</option>
					</select>
				</div>

				<div class="kls-option-container kls-option-container-half ">
					<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][location]" class="kls-label">
						<?php esc_html_e('Script location', KP_TXT_DOMAIN); ?>
					</label>
					<select id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][location]" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][location]" class="kls_input kls_select">
						<option value="head" <?php echo 'head' == $value['location'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Head', KP_TXT_DOMAIN); ?>
						</option>
						<option value="body" <?php echo 'body' == $value['location'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Body', KP_TXT_DOMAIN); ?>
						</option>
						<option value="footer" <?php echo 'footer' == $value['location'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Footer', KP_TXT_DOMAIN); ?>
						</option>
						<option value="shortcode" <?php echo 'shortcode' == $value['location'] ? 'selected="selected"' : ''; ?>>
							<?php esc_html_e('Custom shortcode', KP_TXT_DOMAIN); ?>
						</option>
					</select>
				</div>

				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][script]" class="kls-label">
						<?php esc_html_e('Script contents', KP_TXT_DOMAIN); ?>
					</label>
					<textarea type="text" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][script]" id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][script]" class="kls_textarea"><?php echo $value['script']; ?></textarea>
				</div>

				<?php if (!0 == $key): ?>
					<div class="kls-remove">
						<i class="fas fa-trash"></i>
						<?php esc_html_e('Remove this script', KP_TXT_DOMAIN); ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}
	echo '</div>';
	?>

	<div class="kp-link-button add-new"><i class="fas fa-plus"></i>
		<?php esc_html_e('Add new script', KP_TXT_DOMAIN); ?>
	</div>

	<noscript class="standard-template">
		<div class="kls-scripts-item open" data-setting-id="0">
			<div class="kls-scripts-toggle-title">
				<label for="<?php echo esc_attr($field_name); ?>[0][toggle]" class="kls_toggle">
					<input type="checkbox" name="<?php echo esc_attr($field_name); ?>[0][toggle]" id="<?php echo esc_attr($field_name); ?>[0][toggle]" value="<?php echo esc_attr($check_value); ?>" />
					<span class="slider"></span>
				</label>
				<span class="kls-scripts-title">
					<?php echo esc_html_e('Not set', KP_TXT_DOMAIN); ?>
				</span>
				<div class="kls-toggle-accordion">
					<i class="fas fa-chevron-down"></i>
				</div>
			</div>
			<div class="kls-scripts-toggle-content">
				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[0][title]" class="kls-label">
						<?php esc_html_e('Script title', KP_TXT_DOMAIN); ?>
					</label>
					<input type="text" name="<?php echo esc_attr($field_name); ?>[0][title]" id="<?php echo esc_attr($field_name); ?>[0][title]" value="" class="kls_input kls_text_field" required />
				</div>

				<div class="kls-option-container kls-option-container-half ">
					<label for="<?php echo esc_attr($field_name); ?>[0][cookie_category]" class="kls-label">
						<?php esc_html_e('Script cookie category', KP_TXT_DOMAIN); ?>
					</label>
					<select id="<?php echo esc_attr($field_name); ?>[0][cookie_category]" name="<?php echo esc_attr($field_name); ?>[0][cookie_category]" class="kls_input kls_select">
						<option value="necessary" selected="selected">
							<?php esc_html_e('Necessary', KP_TXT_DOMAIN); ?>
						</option>
						<option value="analytics">
							<?php esc_html_e('Analytics', KP_TXT_DOMAIN); ?>
						</option>
						<option value="marketing">
							<?php esc_html_e('Marketing', KP_TXT_DOMAIN); ?>
						</option>
						<option value="none">
							<?php esc_html_e('None', KP_TXT_DOMAIN); ?>
						</option>
					</select>
				</div>

				<div class="kls-option-container kls-option-container-half ">
					<label for="<?php echo esc_attr($field_name); ?>[0][location]" class="kls-label">
						<?php esc_html_e('Script location', KP_TXT_DOMAIN); ?>
					</label>
					<select id="<?php echo esc_attr($field_name); ?>[0][location]" name="<?php echo esc_attr($field_name); ?>[0][location]" class="kls_input kls_select">
						<option value="head" selected="selected">
							<?php esc_html_e('Head', KP_TXT_DOMAIN); ?>
						</option>
						<option value="body">
							<?php esc_html_e('Body', KP_TXT_DOMAIN); ?>
						</option>
						<option value="footer">
							<?php esc_html_e('Footer', KP_TXT_DOMAIN); ?>
						</option>
					</select>
				</div>

				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[0][script]" class="kls-label">
						<?php esc_html_e('Script contents', KP_TXT_DOMAIN); ?>
					</label>
					<textarea type="text" name="<?php echo esc_attr($field_name); ?>[0][script]" id="<?php echo esc_attr($field_name); ?>[0][script]" class="kls_textarea"></textarea>
				</div>

				<div class="kls-remove">
					<i class="fas fa-trash"></i>
					<?php esc_html_e('Remove this script', KP_TXT_DOMAIN); ?>
				</div>
			</div>
		</div>
	</noscript>

	<script>
		jQuery(document).ready(
			function ($) {
				$('.add-new').on(
					'click',
					function () {
						var amount = $('.kls-scripts-item:last').data('setting-id');

						var standard = $('.standard-template').html();
						if (amount !== undefined) {
							var standard = standard.replace(/0/g, amount + 1);
						} else {
							var standard = standard.replace(/0/g, 1);
						}

						$('.kls-scripts-container').append(standard);
					}
				);

				$('.kls-remove').on(
					'click',
					function () {
						if (confirm('<?php esc_html_e('Are you sure?', KP_TXT_DOMAIN); ?>')) {
							$(this).parent().parent().remove();
						}
						return false;
					}
				);

				$('.kls-toggle-accordion, .kls-scripts-title').on(
					'click',
					function () {
						$(this).parent().parent().toggleClass('open');
					}
				)
			}
		);
	</script>
	<?php
}


/**
 * Create image field callback
 *
 * @since 0.1.03
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_multiple_image_field($args)
{
	$field_name = $args['label_for'];
	$button_text = $args['button_text'];
	$options = get_option($field_name);
	$options_val = '';
	$images = array();

	if (isset($options) && !empty($options)) {
		$options = explode(',', $options);

		foreach ($options as $option) {
			$image = wp_get_attachment_image_src($option, 'thumbnail');
			array_push($images, $image[0]);
		}

		$options_val = implode(",", $options);
	}

	wp_enqueue_media();
	?>
	<div class='image-preview-wrapper'>
		<?php foreach ($images as $image) { ?>
			<img class='image-preview' src='<?php echo $image; ?>' width='100' height='100' style='max-height: 100px; width: 100px;'>
		<?php } ?>
	</div>
	<input id="upload_image_button<?php echo $field_name; ?>" type="button" class="button" value="<?php echo $button_text; ?>" />
	<input type='hidden' name='<?php echo $field_name; ?>' id='<?php echo $field_name; ?>' value='<?php echo $options_val; ?>'>
	<?php

	$my_saved_attachment_post_id = get_option('media_selector_attachment_id', 0);

	?>
	<script type='text/javascript'>
		jQuery(document).ready(function ($) {

			var file_frame;
			var wp_media_post_id = wp.media.model.settings.post.id;
			var set_to_post_id = <?php echo $my_saved_attachment_post_id; ?>;

			jQuery('#upload_image_button<?php echo $field_name; ?>').on('click', function (event) {

				event.preventDefault();

				if (file_frame) {
					file_frame.uploader.uploader.param('post_id', set_to_post_id);
					file_frame.open();
					return;
				} else {
					wp.media.model.settings.post.id = set_to_post_id;
				}

				file_frame = wp.media.frames.file_frame = wp.media({
					title: 'Select images to upload',
					button: {
						text: 'Use these images',
					},
					multiple: true
				});

				file_frame.on('select', function () {
					var attachment_ids = [];
					var attachments = file_frame.state().get('selection').toJSON();

					$('.image-preview-wrapper').html('');

					attachments.forEach(function (attachment) {
						attachment_ids.push(attachment.id);
						$('.image-preview-wrapper').append('<img class="image-preview" src="' + attachment.url + '" width="100" height="100" style="max-height: 100px; width: 100px;">');
					});

					$('#<?php echo $field_name; ?>').val(attachment_ids.join(','));

					wp.media.model.settings.post.id = wp_media_post_id;
				});

				file_frame.open();
			});

			jQuery('a.add_media').on('click', function () {
				wp.media.model.settings.post.id = wp_media_post_id;
			});
		});

	</script>
	<?php
}

/**
 * Scripts callback
 *
 * @param array $args Array of the passed arguments.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.93
 *
 * [Dev] Todo, add an option to exclude the script on specific posts.
 */
function klsAnytimeGrouplessonSelector($args)
{
	$field_name = $args['label_for'];
	$options = get_option($field_name);

	echo '<div class="kls-scripts-container">';

	if (isset($options) && !empty($options)) {
		foreach ($options as $key => $value) {
			$options = get_option($field_name)[esc_attr($key)]['image'];
			$image = wp_get_attachment_image_src($options, 'thumbnail');
			if (isset($image) && !empty($image)) {
				$image = $image[0];
			} else {
				$image = '';
			}

			?>
			<div class="kls-scripts-item" data-setting-id="<?php echo esc_html($key); ?>">
				<div class="kls-scripts-toggle-title">
					<span class="kls-scripts-title">
						<?php echo esc_html($value['title']); ?>
					</span>
					<div class="kls-toggle-accordion">
						<i class="fas fa-chevron-down"></i>
					</div>
				</div>
				<div class="kls-scripts-toggle-content">
					<div class="kls-option-container">
						<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][order]" class="kls-label">
							<?php esc_html_e('Order', KP_TXT_DOMAIN); ?>
						</label>
						<input type="text" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][order]" id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][order]" value="<?php echo esc_html($value['order']); ?>" class="kls_input kls_text_field" required />
					</div>

					<div class="kls-option-container">
						<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][title]" class="kls-label">
							<?php esc_html_e('Groeplesson name', KP_TXT_DOMAIN); ?>
						</label>
						<input type="text" name="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][title]" id="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][title]" value="<?php echo esc_html($value['title']); ?>" class="kls_input kls_text_field" required />
					</div>

					<div class="kls-option-container">
						<label for="<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][image]" class="kls-label">
							<?php esc_html_e('Groeplesson image', KP_TXT_DOMAIN); ?>
						</label>
						<div class='image-preview-wrapper'>
							<img class='image-preview' src='<?php echo $image; ?>' width='100' height='100' style='max-height: 100px; width: 100px;'>
						</div>
						<input class="upload_image_button<?php echo $field_name; ?> button" type="button" value="<?php _e('Upload image', KP_TXT_DOMAIN); ?>" data-setting-id="<?php echo esc_attr($key); ?>" />
						<input type='hidden' class="image-input" name='<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][image]' id='<?php echo esc_attr($field_name); ?>[<?php echo esc_attr($key); ?>][image]' value='<?php echo esc_html($value['image']); ?>'>
					</div>

					<?php if (!0 == $key): ?>
						<div class="kls-remove">
							<i class="fas fa-trash"></i>
							<?php esc_html_e('Remove this grouplesson', KP_TXT_DOMAIN); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<?php
		}
		echo '</div>';
	}

	$field_name = $args['label_for'];
	$button_text = $args['button_text'];
	$options = get_option($field_name);

	$image = wp_get_attachment_image_src($options, 'thumbnail');

	wp_enqueue_media();

	// Image media gallery script
	$my_saved_attachment_post_id = get_option('media_selector_attachment_id', 0);

	?>

	<div class="kp-link-button add-new-grouplesson"><i class="fas fa-plus"></i>
		<?php esc_html_e('Add new grouplesson', KP_TXT_DOMAIN); ?>
	</div>

	<noscript class="standard-template">
		<div class="kls-scripts-item open" data-setting-id="0">
			<div class="kls-scripts-toggle-title">
				<span class="kls-scripts-title">
					<?php echo esc_html_e('Not set', KP_TXT_DOMAIN); ?>
				</span>
				<div class="kls-toggle-accordion">
					<i class="fas fa-chevron-down"></i>
				</div>
			</div>
			<div class="kls-scripts-toggle-content">
				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[0][order]" class="kls-label">
						<?php esc_html_e('Order', KP_TXT_DOMAIN); ?>
					</label>
					<input type="text" name="<?php echo esc_attr($field_name); ?>[0][order]" id="<?php echo esc_attr($field_name); ?>[0][order]" value="0" class="kls_input kls_text_field" required />
				</div>
				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[0][title]" class="kls-label">
						<?php esc_html_e('Grouplesson name', KP_TXT_DOMAIN); ?>
					</label>
					<input type="text" name="<?php echo esc_attr($field_name); ?>[0][title]" id="<?php echo esc_attr($field_name); ?>[0][title]" value="" class="kls_input kls_text_field" required />
				</div>

				<div class="kls-option-container">
					<label for="<?php echo esc_attr($field_name); ?>[0][image]" class="kls-label">
						<?php esc_html_e('Groeplesson image', KP_TXT_DOMAIN); ?>
					</label>
					<div class='image-preview-wrapper'>
						<img class='image-preview' src='' width='100' height='100' style='max-height: 100px; width: 100px;'>
					</div>
					<input class="upload_image_button<?php echo esc_attr($field_name); ?> button" type="button" value="<?php _e('Upload image', KP_TXT_DOMAIN); ?>" data-setting-id="0" />
					<input type='hidden' class="image-input" name='<?php echo esc_attr($field_name); ?>[0][image]' id='<?php echo esc_attr($field_name); ?>[0][image]' value=''>
				</div>

				<div class="kls-remove">
					<i class="fas fa-trash"></i>
					<?php esc_html_e('Remove this grouplesson', KP_TXT_DOMAIN); ?>
				</div>
			</div>
		</div>
	</noscript>

	<script>
		jQuery(document).ready(
			function ($) {
				$('.add-new-grouplesson').on(
					'click',
					function () {
						var amount = $('.kls-scripts-item:last').data('setting-id');
						if (isNaN(amount)) {
							var amount = 0;
						} else {
							var amount = $('.kls-scripts-item:last').data('setting-id');
						}

						var standard = $('.standard-template').html();
						var standard = standard.replace(/0/g, amount + 1);

						$('.kls-scripts-container').append(standard);

						// $(document).trigger('readyAgain'); // Todo, when this gets triggert multiple times it will open de image uploader multiple times.
					}
				);

				$('.kls-remove').on(
					'click',
					function () {
						if (confirm('<?php esc_html_e('Are you sure?', KP_TXT_DOMAIN); ?>')) {
							$(this).parent().parent().remove();
						}
						return false;
					}
				);

				$('.kls-toggle-accordion, .kls-scripts-title').on(
					'click',
					function () {
						$(this).parent().parent().toggleClass('open');
					}
				)
			}
		);
	</script>

	<script type='text/javascript'>
		jQuery(document).on('click', '.upload_image_button<?php echo $field_name; ?>', function (event) {
			console.log('Click');
			// Uploading files
			var file_frame;
			var wp_media_post_id = wp.media.model.settings.post.id; // Store the old id
			var set_to_post_id = <?php echo $my_saved_attachment_post_id; ?>; // Set this

			var setting_id = jQuery(this).data('setting-id');
			var image_preview = jQuery(this).parent().find('.image-preview');
			var image_input = jQuery(this).parent().find('.image-input');

			event.preventDefault();

			// If the media frame already exists, reopen it.
			if (file_frame) {
				// Set the post ID to what we want
				file_frame.uploader.uploader.param('post_id', set_to_post_id);
				// Open frame
				file_frame.open();
				return;
			} else {
				// Set the wp.media post id so the uploader grabs the ID we want when initialised
				wp.media.model.settings.post.id = set_to_post_id;
			}

			// Create the media frame.
			file_frame = wp.media.frames.file_frame = wp.media({
				title: 'Select a image to upload',
				button: {
					text: 'Use this image',
				},
				multiple: false
			});

			// When an image is selected, run a callback.
			file_frame.on('select', function () {
				// We set multiple to false so only get one image from the uploader
				attachment = file_frame.state().get('selection').first().toJSON();
				// Do something with attachment.id and/or attachment.url here
				jQuery(image_preview).attr('src', attachment.url).css('width', 'auto');
				jQuery(image_input).val(attachment.id);

				// Restore the main post ID
				wp.media.model.settings.post.id = wp_media_post_id;
			});

			// Finally, open the modal
			file_frame.open();
		});

		// Restore the main ID when the add media button is pressed
		jQuery('a.add_media').on('click', function () {
			wp.media.model.settings.post.id = wp_media_post_id;
		});
	</script>
	<?php
}
