<?php

/**
 * Generate random string
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_random_str(
	int $length = 64,
	string $keyspace = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'
): string {
	if ( $length < 1 ) {
		throw new \RangeException( 'Length must be a positive integer' );
	}
	$pieces = array();
	$max    = mb_strlen( $keyspace, '8bit' ) - 1;
	for ( $i = 0; $i < $length; ++$i ) {
		$pieces [] = $keyspace[ random_int( 0, $max ) ];
	}
	return implode( '', $pieces );
}

/**
 * API regeneration
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_regenerate_api_key() {
	 update_option( 'kls_api_key', kls_random_str( '64' ) );

	date_default_timezone_set( 'Europe/Amsterdam' );
	update_option( 'kls_api_last_change', date( 'd/m/Y - H:i:s' ) );

	// Redirect back to the page
	wp_redirect( admin_url( 'admin.php?page=kls_api' ) );
	kls_admin_notice( __( 'All caches have been cleared.', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_regenerate_api_key', 'kls_regenerate_api_key' );
