<?php

/**
 * Create admin options from admin select
 *
 * @since 0.0.02
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

if ( $GLOBALS['pagenow'] === 'wp-login.php' || is_admin() ) {
	if ( get_option( 'kls_admin_select' ) == 'Totstraksonline.nl' ) {
		// Totstraksonline
		update_option( 'kls_admin_name', 'Totstraksonline.nl' );
		update_option( 'kls_admin_email', 'support@totstraksonline.nl' );
		update_option( 'kls_admin_phone', '024 23 40 111' );
		update_option( 'kls_admin_website', 'https://totstraksonline.nl' );
		update_option( 'kls_admin_street', 'Kerkenbos 1039 2e etage' );
		update_option( 'kls_admin_postal_code', '6546BB' );
		update_option( 'kls_admin_city', 'Nijmegen' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_totstraksonline.png' );
		update_option( 'kls_admin_favicon', 'favicon_totstraksonline.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option('kls_admin_logo');
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#4ca44c';
		$adminSecundaryColor = '#fcb912';
	} elseif ( get_option( 'kls_admin_select' ) == 'Websitexperts' ) {
		// Websitexperts
		update_option( 'kls_admin_name', 'Websitexperts' );
		update_option( 'kls_admin_email', 'support@websitexperts.nl' );
		update_option( 'kls_admin_phone', '024 23 40 040' );
		update_option( 'kls_admin_website', 'https://websitexperts.nl' );
		update_option( 'kls_admin_street', 'Kerkenbos 1039 2e etage' );
		update_option( 'kls_admin_postal_code', '6546BB' );
		update_option( 'kls_admin_city', 'Nijmegen' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_websitexperts.png' );
		update_option( 'kls_admin_favicon', 'favicon_websitexperts.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#47698f';
		$adminSecundaryColor = '#f6a42d';
	} elseif ( get_option( 'kls_admin_select' ) == 'Fitleads' ) {
		// Fitleads
		update_option( 'kls_admin_name', 'Fitleads' );
		update_option( 'kls_admin_email', 'info@fitleads.nl' );
		update_option( 'kls_admin_phone', '024 23 40 409' );
		update_option( 'kls_admin_website', 'https://fitleads.nl' );
		update_option( 'kls_admin_street', 'Kerkenbos 1039 2e etage' );
		update_option( 'kls_admin_postal_code', '6546BB' );
		update_option( 'kls_admin_city', 'Nijmegen' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_fitleads.png' );
		update_option( 'kls_admin_favicon', 'favicon_fitleads.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#167abd';
		$adminSecundaryColor = '#fcc900';
	} elseif ( get_option( 'kls_admin_select' ) == 'Novaleads' ) {
		// Novaloads
		update_option( 'kls_admin_name', 'Novaleads' );
		update_option( 'kls_admin_email', 'info@novaleads.nl' );
		update_option( 'kls_admin_phone', '-' );
		update_option( 'kls_admin_website', 'https://novaleads.nl' );
		update_option( 'kls_admin_street', 'Kerkenbos 1039 2e etage' );
		update_option( 'kls_admin_postal_code', '6546BB' );
		update_option( 'kls_admin_city', 'Nijmegen' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_novaleads.png' );
		update_option( 'kls_admin_favicon', 'favicon_novaleads.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#4374b9';
		$adminSecundaryColor = '#333333';
	} elseif ( get_option( 'kls_admin_select' ) == 'Klasse B.V.' ) {
		// Klasse Software & Development B.V.
		update_option( 'kls_admin_name', 'Klasse Software & Development B.V.' );
		update_option( 'kls_admin_email', 'info@klassebv.nl' );
		update_option( 'kls_admin_phone', '-' );
		update_option( 'kls_admin_website', 'https://klassebv.nl' );
		update_option( 'kls_admin_street', 'Kerkenbos 1039 2e etage' );
		update_option( 'kls_admin_postal_code', '6546BB' );
		update_option( 'kls_admin_city', 'Nijmegen' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_klasse.png' );
		update_option( 'kls_admin_favicon', 'favicon_klasse.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#292e42';
		$adminSecundaryColor = '#ccbfa2';
	} elseif ( get_option( 'kls_admin_select' ) == 'SyncSilo' ) {
		// SyncSilo
		update_option( 'kls_admin_name', 'SyncSilo Ecommerce' );
		update_option( 'kls_admin_email', 'support@syncsilo.com' );
		update_option( 'kls_admin_phone', '085 060 2830' );
		update_option( 'kls_admin_website', 'https://syncsilo.com/' );
		update_option( 'kls_admin_street', 'Sibculobrink 20' );
		update_option( 'kls_admin_postal_code', '7544 AB' );
		update_option( 'kls_admin_city', 'Enschede' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_syncsilo.png' );
		update_option( 'kls_admin_favicon', 'favicon_syncsilo.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#161e2e';
		$adminSecundaryColor = '#5850ec';
	} elseif ( get_option( 'kls_admin_select' ) == 'Werbeland' ) {
		// Werbeland
		update_option( 'kls_admin_name', 'Werbeland' );
		update_option( 'kls_admin_email', 'info@werbeland.com' );
		update_option( 'kls_admin_phone', '04431 945540' );
		update_option( 'kls_admin_website', 'https://werbeland.com/' );
		update_option( 'kls_admin_street', 'Cornauer Tor 4' );
		update_option( 'kls_admin_postal_code', '27793' );
		update_option( 'kls_admin_city', 'Wildeshausen' );
		update_option( 'kls_admin_country', 'Deutschland' );
		update_option( 'kls_admin_logo', 'logo_werbeland.png' );
		update_option( 'kls_admin_favicon', 'favicon_werbeland.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#3b3c42';
		$adminSecundaryColor = '#b4bc00';
	} elseif ( get_option( 'kls_admin_select' ) == 'Linkbuilding Marketing' ) {
		// Lion marketing.
		update_option( 'kls_admin_name', 'Linkbuilding Marketing' );
		update_option( 'kls_admin_email', 'info@linkbuildingmarketing.nl' );
		update_option( 'kls_admin_phone', '085 - 04 10 177' );
		update_option( 'kls_admin_website', 'https://www.linkbuildingmarketing.nl/' );
		update_option( 'kls_admin_street', 'Passage 240' );
		update_option( 'kls_admin_postal_code', '2741 GS' );
		update_option( 'kls_admin_city', 'Waddinxveen' );
		update_option( 'kls_admin_country', 'Nederland' );
		update_option( 'kls_admin_logo', 'logo_linkbuilding_marketing.png' );
		update_option( 'kls_admin_favicon', 'favicon_linkbuilding_marketing.png' );
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#0f81ba';
		$adminSecundaryColor = '#50c487';
	} else {
		// Other whitelabel options
		$adminLogo           = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_logo' );
		$adminFavicon        = KP_ASSETS_PATH . '/images/' . get_option( 'kls_admin_favicon' );
		$adminPrimaryColor   = '#2196F3';
		$adminSecundaryColor = '#1d2327';
	}

	$adminUrl   = get_option( 'kls_admin_website' );
	$adminName  = get_option( 'kls_admin_name' );
	$adminEmail = get_option( 'kls_admin_email' );
	$adminPhone = get_option( 'kls_admin_phone' );
}

if ( is_admin() ) {
	/**
	* Add dashboard widget
	*
	* @since 0.0.02
	*
	* @author Joeri van der Stek <joeri@klassebv.nl>
	*/
	add_action( 'wp_dashboard_setup', 'kls_dashboard_widget' );

	function kls_dashboard_widget() {
		global $wp_meta_boxes;

		wp_add_dashboard_widget( 'custom_help_widget', __( 'Made possible by ', KP_TXT_DOMAIN ) . $GLOBALS['adminName'], 'custom_dashboard_help' );
	}

	function custom_dashboard_help() {
		echo '<table>
            <tr>
                <td colspan="2"><strong>' . __( 'Theme owned by', KP_TXT_DOMAIN ) . ' <a href=" ' . $GLOBALS['adminUrl'] . ' " style="text-decoration:none;"> ' . $GLOBALS['adminName'] . ' </a></strong></td>
            </tr>
            <tr>
                <td><br></td>
                <td></td>
            </tr>
            <tr>
                <td colspan="2"><strong>' . __( 'Our support is ready for you!', KP_TXT_DOMAIN ) . '</strong></td>
                </tr>
            <tr>
                <td><strong>' . __( 'Email address', KP_TXT_DOMAIN ) . '</strong</td>
                <td><a href="mailto:' . $GLOBALS['adminEmail'] . '">' . $GLOBALS['adminEmail'] . '</a></td>
            </tr>
            <tr>
                <td><strong>' . __( 'Phone number', KP_TXT_DOMAIN ) . '</strong</td>
                <td><a href="tel:' . $GLOBALS['adminPhone'] . '">' . $GLOBALS['adminPhone'] . '</a></td>
            </tr>
        </table>';
	}

	/**
	 * Change admin footer text
	 *
	 * @since 0.0.02
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	function kls_admin_footer() {
		echo '<span id="footer-thankyou">' . __( 'Made possible by ', KP_TXT_DOMAIN ) . ' <a href=" ' . $GLOBALS['adminUrl'] . ' " target="_blank">' . $GLOBALS['adminName'] . '</a></span>';
	}

	add_filter( 'admin_footer_text', 'kls_admin_footer' );

	/**
	 * Change top left icon
	 *
	 * @since 0.0.02
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	function kls_admin_top_left_logo() {        ?>
		<style type="text/css">
			#wpadminbar #wp-admin-bar-wp-logo>.ab-item {
				position: relative !important;
			}

			#wpadminbar #wp-admin-bar-wp-logo>.ab-item .ab-icon {
				width: 20px !important;
				height: 32px !important;
				padding: 0px 0 !important;
			}

			#wpadminbar #wp-admin-bar-wp-logo.hover>.ab-item .ab-icon {
				background-position: 0 0;
			}

			#wpadminbar #wp-admin-bar-wp-logo>.ab-item .ab-icon:before {
				content: "" !important;
				background-image: url(<?php echo $GLOBALS['adminFavicon']; ?>) !important;
				background-position: center;
				color: rgba(0, 0, 0, 0);
				width: 100%;
				height: 100%;
				position: absolute;
				left: 0;
				top: 0;
				background-size: contain;
				background-repeat: no-repeat;
			}
		</style>
		<?php
	}

	add_action( 'wp_before_admin_bar_render', 'kls_admin_top_left_logo' );

	/**
	 * Change admin Favicon
	 *
	 * @since 0.0.02
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	function kls_admin_favicon() {
		echo '<link rel="icon" type="image/x-icon" href="' . $GLOBALS['adminFavicon'] . '" />';
	}
	add_action( 'admin_head', 'kls_admin_favicon' );

	/**
	* Clean up the WordPress dashboard
	*
	* @since 0.0.02
	*
 * @author Joeri van der Stek <joeri@klassebv.nl>
	*/
	if ( get_option( 'kls_dashboard_clean_up_toggle' ) == 'on' ) {
		function kls_clear_dashboard() {
			remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
			remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'side' );
			remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
			remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' );
			remove_meta_box( 'wpseo-dashboard-overview', 'dashboard', 'normal' ); // Yoast
			remove_meta_box( 'wordfence_activity_report_widget', 'dashboard', 'normal' ); // WordFence standard message
			remove_meta_box( 'dashboard_primary', 'dashboard', 'side' ); // WordPress events and news
			remove_meta_box( 'dashboard_activity', 'dashboard', 'normal' ); // WordPress activities panel
			remove_meta_box( 'dashboard_site_health', 'dashboard', 'normal' ); // WordPress site meta box
			remove_action( 'welcome_panel', 'wp_welcome_panel' ); // WordPress welcome message
			remove_action( 'try_gutenberg_panel', 'wp_try_gutenberg_panel' ); // WordPress Guttenburg editor
		}
		add_action( 'wp_dashboard_setup', 'kls_clear_dashboard' );
	}

	/**
	 * Add admin color styling
	 *
	 * @since 0.0.38
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	function kls_add_admin_color_styling() {
		?>
		<style type="text/css">
			.kls-admin-primary-text,
			.kls-page-wrapper h1,
			.kls-setup-button-container .kls-setup-button,
			.sidebar-menu .sidebar-menu-icon{
				color: <?php echo $GLOBALS['adminPrimaryColor']; ?>;
			}
			.kls-admin-primary-background,
			.kls-page-wrapper .submit .button{
				background-color: <?php echo $GLOBALS['adminPrimaryColor']; ?>;
			}
			.kls-admin-primary-border,
			.sidebar-menu li a:hover,
			.sidebar-menu li.active a,
			.kls-page-wrapper hr {
				border-color: <?php echo $GLOBALS['adminPrimaryColor']; ?>;
			}
			.kls-admin-secundary-text,
			.kp-link-button{
				color: <?php echo $GLOBALS['adminSecundaryColor']; ?>;
			}
			.kls-admin-secundary-background,
			.kls_toggle input:checked+.slider{
				background-color: <?php echo $GLOBALS['adminSecundaryColor']; ?>;
			}
			.kls-admin-secundary-border{
				border-color: <?php echo $GLOBALS['adminSecundaryColor']; ?>;
			}
		</style>
		<?php
	}

	add_action( 'wp_before_admin_bar_render', 'kls_add_admin_color_styling' );
}

/**
 * Set admin login logo
 *
 * @since 0.0.02
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( $GLOBALS['pagenow'] === 'wp-login.php' ) {
	function kls_login_logo() {
		?>
		<style type='text/css'>
			#login h1 a,
			.login h1 a {
				background-image: url(<?php echo $GLOBALS['adminLogo']; ?>);
				height: 150px;
				width: 100%;
				background-size: contain;
				background-repeat: no-repeat;
				background-position: bottom;
				padding-bottom: 0;
			}
		</style>
		<?php
	}

	add_action( 'login_enqueue_scripts', 'kls_login_logo' );
}

/**
 * Add clear cache button in admin bar
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.89
 */
function kls_add_admin_toolbar_items( $admin_bar ) {
	$admin_bar->add_menu(
		array(
			'id'    => 'kls-clear-caches',
			'title' => __( 'Clear all caches', KP_TXT_DOMAIN ),
			'href'  => '/wp-admin/admin-post.php?action=kls_clear_caches',
			'meta'  => array(
				'title' => __( 'Clear all caches', KP_TXT_DOMAIN ),
			),
		)
	);
}
add_action( 'admin_bar_menu', 'kls_add_admin_toolbar_items', 100 );
