<?php
/**
 * Background Pattern Style - Shippo.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Shippo
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Shippo extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Shippo', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M48,0A48,48,0,0,1,96,48,48,48,0,0,1,48,0Zm0,0A48,48,0,0,0,0,48,48,48,0,0,0,48,0ZM96,48A48,48,0,0,0,48,96,48,48,0,0,0,96,48ZM0,48A48,48,0,0,0,48,96,48,48,0,0,0,0,48Z"/>',
				'default-inverted' => '<path d="M96,48V96H48A48,48,0,0,0,96,48ZM0,48V96H48A48,48,0,0,1,0,48ZM48,0H0V48A48,48,0,0,1,48,0Zm0,0A48,48,0,0,1,0,48,48,48,0,0,1,48,96,48,48,0,0,1,96,48,48,48,0,0,1,48,0Zm0,0A48,48,0,0,1,96,48V0Z"/>',
				'rotated'          => '<path d="M48,0A48,48,0,0,1,96,48,48,48,0,0,1,48,0Zm0,0A48,48,0,0,0,0,48,48,48,0,0,0,48,0ZM96,48A48,48,0,0,0,48,96,48,48,0,0,0,96,48ZM0,48A48,48,0,0,0,48,96,48,48,0,0,0,0,48Z"/>',
				'rotated-inverted' => '<path d="M96,48V96H48A48,48,0,0,0,96,48ZM0,48V96H48A48,48,0,0,1,0,48ZM48,0H0V48A48,48,0,0,1,48,0Zm0,0A48,48,0,0,1,0,48,48,48,0,0,1,48,96,48,48,0,0,1,96,48,48,48,0,0,1,48,0Zm0,0A48,48,0,0,1,96,48V0Z"/>',
				'thumbnail'        => '<path d="M10,0A10,10,0,0,1,20,10,10,10,0,0,1,10,0Zm0,0A10,10,0,0,0,0,10,10,10,0,0,0,10,0ZM20,10A10,10,0,0,0,10,20,10,10,0,0,0,20,10ZM0,10A10,10,0,0,0,10,20,10,10,0,0,0,0,10Zm40,0A10,10,0,0,0,30,0,10,10,0,0,0,40,10ZM30,0A10,10,0,0,0,20,10,10,10,0,0,0,30,0ZM40,10A10,10,0,0,0,30,20,10,10,0,0,0,40,10ZM20,10A10,10,0,0,0,30,20,10,10,0,0,0,20,10Zm40,0A10,10,0,0,0,50,0,10,10,0,0,0,60,10ZM50,0A10,10,0,0,0,40,10,10,10,0,0,0,50,0ZM60,10A10,10,0,0,0,50,20,10,10,0,0,0,60,10ZM40,10A10,10,0,0,0,50,20,10,10,0,0,0,40,10Zm40,0A10,10,0,0,0,70,0,10,10,0,0,0,80,10ZM70,0A10,10,0,0,0,60,10,10,10,0,0,0,70,0ZM80,10A10,10,0,0,0,70,20,10,10,0,0,0,80,10ZM60,10A10,10,0,0,0,70,20,10,10,0,0,0,60,10ZM20,30A10,10,0,0,0,10,20,10,10,0,0,0,20,30ZM10,20A10,10,0,0,0,0,30,10,10,0,0,0,10,20ZM20,30A10,10,0,0,0,10,40,10,10,0,0,0,20,30ZM0,30A10,10,0,0,0,10,40,10,10,0,0,0,0,30Zm40,0A10,10,0,0,0,30,20,10,10,0,0,0,40,30ZM30,20A10,10,0,0,0,20,30,10,10,0,0,0,30,20ZM40,30A10,10,0,0,0,30,40,10,10,0,0,0,40,30ZM20,30A10,10,0,0,0,30,40,10,10,0,0,0,20,30Zm40,0A10,10,0,0,0,50,20,10,10,0,0,0,60,30ZM50,20A10,10,0,0,0,40,30,10,10,0,0,0,50,20ZM60,30A10,10,0,0,0,50,40,10,10,0,0,0,60,30ZM40,30A10,10,0,0,0,50,40,10,10,0,0,0,40,30Zm40,0A10,10,0,0,0,70,20,10,10,0,0,0,80,30ZM70,20A10,10,0,0,0,60,30,10,10,0,0,0,70,20ZM80,30A10,10,0,0,0,70,40,10,10,0,0,0,80,30ZM60,30A10,10,0,0,0,70,40,10,10,0,0,0,60,30ZM20,50A10,10,0,0,0,10,40,10,10,0,0,0,20,50ZM10,40A10,10,0,0,0,0,50,10,10,0,0,0,10,40ZM20,50A10,10,0,0,0,10,60,10,10,0,0,0,20,50ZM0,50A10,10,0,0,0,10,60,10,10,0,0,0,0,50Zm40,0A10,10,0,0,0,30,40,10,10,0,0,0,40,50ZM30,40A10,10,0,0,0,20,50,10,10,0,0,0,30,40ZM40,50A10,10,0,0,0,30,60,10,10,0,0,0,40,50ZM20,50A10,10,0,0,0,30,60,10,10,0,0,0,20,50Zm40,0A10,10,0,0,0,50,40,10,10,0,0,0,60,50ZM50,40A10,10,0,0,0,40,50,10,10,0,0,0,50,40ZM60,50A10,10,0,0,0,50,60,10,10,0,0,0,60,50ZM40,50A10,10,0,0,0,50,60,10,10,0,0,0,40,50Zm40,0A10,10,0,0,0,70,40,10,10,0,0,0,80,50ZM70,40A10,10,0,0,0,60,50,10,10,0,0,0,70,40ZM80,50A10,10,0,0,0,70,60,10,10,0,0,0,80,50ZM60,50A10,10,0,0,0,70,60,10,10,0,0,0,60,50Z"/>',
			),
			'width'      => '96px',
			'height'     => '96px',
		);
	}
}

return new ET_Builder_Pattern_Shippo();
